<?php

use TYPO3\CMS\Extbase\Utility\ExtensionUtility;
use Ig\IgRuckzuckevent\Controller\EventController;
use Ig\IgRuckzuckevent\Controller\RegistrationController;
use Ig\IgRuckzuckevent\Controller\CategoryController;
use Ig\IgRuckzuckevent\Controller\FeedbackController;
use Ig\IgRuckzuckevent\Controller\OrganizerController;
use Ig\IgRuckzuckevent\Controller\SponsorController;
use Ig\IgRuckzuckevent\Controller\RestController;
use Ig\IgRuckzuckevent\Controller\CalendarController;
use Ig\IgRuckzuckevent\Controller\UserController;
use Ig\IgRuckzuckevent\Controller\SubscriptionController;
use TYPO3\CMS\Core\Utility\ExtensionManagementUtility;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Imaging\IconRegistry;
use TYPO3\CMS\Core\Imaging\IconProvider\SvgIconProvider;
use TYPO3\CMS\Core\Imaging\IconProvider\BitmapIconProvider;
use Ig\IgRuckzuckevent\Form\Element\AdditionalFieldsFormElement;
use Ig\IgRuckzuckevent\Hook\AdditionalFieldsDataHandlerHook;
use Ig\IgRuckzuckevent\Hook\ClearCacheDataHandlerHook;
use Ig\IgRuckzuckevent\Hook\ValidateEventDeadlineDataHandlerHook;
use Ig\IgRuckzuckevent\Upgrades\PluginToCTypeUpgradeWizard;

defined('TYPO3') or die();


call_user_func(
    function () {
        ExtensionUtility::configurePlugin(
            'IgRuckzuckevent',
            'Events',
            [
                EventController::class => 'list',
                RegistrationController::class => 'acceptWaitlistPromotion, declineWaitlistPromotion',
            ],
            // non-cacheable actions
            [
                EventController::class => 'list',
                RegistrationController::class => 'acceptWaitlistPromotion, declineWaitlistPromotion',
            ],
            ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
        );

        ExtensionUtility::configurePlugin(
            'IgRuckzuckevent',
            'Resteventlist',
            [
                RestController::class => 'eventList',
            ],
            // non-cacheable actions
            [
                RestController::class => 'eventList',
            ],
            ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
        );

        ExtensionUtility::configurePlugin(
            'IgRuckzuckevent',
            'Resteventshow',
            [
                RestController::class => 'eventShow',
            ],
            // non-cacheable actions
            [
                RestController::class => 'eventShow',
            ],
            ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
        );
        ExtensionUtility::configurePlugin(
            'IgRuckzuckevent',
            'EventListFromJson',
            [
                EventController::class => 'listJson',
            ],
            // non-cacheable actions
            [
                EventController::class => 'listJson',
            ],
            ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
        );

        ExtensionUtility::configurePlugin(
            'IgRuckzuckevent',
            'EventDetail',
            [
                EventController::class => 'show',
            ],
            // non-cacheable actions
            [

            ],
            ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
        );

        ExtensionUtility::configurePlugin(
            'IgRuckzuckevent',
            'EventDetailFromJson',
            [
                EventController::class => 'showJson',
            ],
            // non-cacheable actions
            [
                EventController::class => 'showJson',
            ],
            ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
        );

        ExtensionUtility::configurePlugin(
            'IgRuckzuckevent',
            'CurrentEvents',
            [
                EventController::class => 'listCurrent',
            ],
            // non-cacheable actions
            [
                EventController::class => 'listCurrent',
            ],
            ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
        );

        ExtensionUtility::configurePlugin(
            'IgRuckzuckevent',
            'Registration',
            [
                RegistrationController::class => 'new, create, createSimple, newWaitlist, createWaitlist'
            ],
            // non-cacheable actions
            [
                RegistrationController::class => 'new, create, createSimple, newWaitlist, createWaitlist'
            ],
            ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
        );

        ExtensionUtility::configurePlugin(
            'IgRuckzuckevent',
            'ThankYou',
            [
                RegistrationController::class => 'thankYou'
            ],
            // non-cacheable actions
            [
                RegistrationController::class => 'thankYou'
            ],
            ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
        );

        ExtensionUtility::configurePlugin(
            'IgRuckzuckevent',
            'Feedback',
            [
                FeedbackController::class => 'list'
            ],
            // non-cacheable actions
            [
                FeedbackController::class => 'list'
            ],
            ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
        );

        ExtensionUtility::configurePlugin(
            'IgRuckzuckevent',
            'SearchForm',
            [
                EventController::class => 'searchForm',
            ],
            // non-cacheable actions
            [
                EventController::class => 'searchForm',
            ],
            ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
        );

        /*ExtensionUtility::configurePlugin(
            'IgRuckzuckevent',
            'HtmlTitle',
            [
                EventController::class => 'htmlTitle',

            ],
            // non-cacheable actions
            [
                EventController::class => 'htmlTitle',

            ],
            ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
        );*/

        ExtensionUtility::configurePlugin(
            'IgRuckzuckevent',
            'Create',
            [
                EventController::class => 'publicNew,publicCreate,ajaxUpload,accept'
            ],
            // non-cacheable actions
            [
                EventController::class => 'publicNew,publicCreate,ajaxUpload,accept'
            ],
            ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
        );




        ExtensionUtility::configurePlugin(
            'IgRuckzuckevent',
            'EventsCalendar',
            [
                CalendarController::class => 'list,show',
                RegistrationController::class => 'create, loginFirst, subscribe, list, delete',
                UserController::class => 'new, create, reminder, confirmation, edit, update',

            ],
            // non-cacheable actions
            [
                CalendarController::class => 'list,show',
                RegistrationController::class => 'create, loginFirst, subscribe, list, delete',
                UserController::class => 'new, create, reminder, confirmation, edit, update',

            ],
            ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
        );
        ExtensionUtility::configurePlugin(
            'IgRuckzuckevent',
            'EventManagement',
            [
                EventController::class => 'organizerList, show, new, create, edit, update, delete, duplicate, ajaxUpload, export',
                RegistrationController::class => 'new, create, createSimple, newWaitlist, createWaitlist, export',
                CategoryController::class => 'list, new, create, edit, update, delete, ajaxUpload',
                FeedbackController::class => 'organizerList, new, create, edit, update, delete',
                OrganizerController::class => 'list, new, create, edit, update, delete, ajaxUpload',
                SponsorController::class => 'list, new, create, edit, update, delete, ajaxUpload',
            ],
            // non-cacheable actions
            [
                EventController::class => 'organizerList, show, new, create, edit, update, delete, duplicate, ajaxUpload, export',
                RegistrationController::class => 'new, create, createSimple, newWaitlist, createWaitlist',
                CategoryController::class => 'list, new, create, edit, update, delete, ajaxUpload',
                FeedbackController::class => 'organizerList, new, create, edit, update, delete',
                OrganizerController::class => 'list, new, create, edit, update, delete, ajaxUpload',
                SponsorController::class => 'list, new, create, edit, update, delete, ajaxUpload',
            ],
            ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
        );

        ExtensionUtility::configurePlugin(
            'IgRuckzuckevent',
            'EventsInProcessing',
            [
                EventController::class => 'eventsInProcessing, new, create, edit, update, delete, duplicate, ajaxUpload, export',
            ],
            // non-cacheable actions
            [
                EventController::class => 'eventsInProcessing, new, create, edit, update, delete, duplicate, ajaxUpload, export',
            ],
            ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
        );

        ExtensionUtility::configurePlugin(
            'IgRuckzuckevent',
            'EventsArchive',
            [
                EventController::class => 'eventsArchive, new, create, edit, update, delete, duplicate, ajaxUpload, export',
            ],
            // non-cacheable actions
            [
                EventController::class => 'eventsArchive, new, create, edit, update, delete, duplicate, ajaxUpload, export',
            ],
            ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
        );
        ExtensionUtility::configurePlugin(
            'IgRuckzuckevent',
            'SlugSuggest',
            [
                EventController::class => 'slugSuggest',
            ],
            // non-cacheable actions
            [
                EventController::class => 'slugSuggest',
            ],
            ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
        );

        ExtensionUtility::configurePlugin(
            'IgRuckzuckevent',
            'CategoryManagement',
            [
                CategoryController::class => 'list, new, create, edit, update, delete, ajaxUpload',
            ],
            // non-cacheable actions
            [
                CategoryController::class => 'list, new, create, edit, update, delete, ajaxUpload',
            ],
            ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
        );

        ExtensionUtility::configurePlugin(
            'IgRuckzuckevent',
            'SponsorManagement',
            [
                SponsorController::class => 'list, new, create, edit, update, delete, ajaxUpload',
            ],
            // non-cacheable actions
            [
                SponsorController::class => 'list, new, create, edit, update, delete, ajaxUpload',
            ],
            ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
        );

        ExtensionUtility::configurePlugin(
            'IgRuckzuckevent',
            'FeedbackManagement',
            [
                FeedbackController::class => 'organizerList, new, create, edit, update, delete',
            ],
            // non-cacheable actions
            [
                FeedbackController::class => 'organizerList, new, create, edit, update, delete',
            ],
            ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
        );

        ExtensionUtility::configurePlugin(
            'IgRuckzuckevent',
            'OrganizerManagement',
            [
                OrganizerController::class => 'list, new, create, edit, update, delete, ajaxUpload',
            ],
            // non-cacheable actions
            [
                OrganizerController::class => 'list, new, create, edit, update, delete, ajaxUpload',
            ],
            ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
        );

        ExtensionUtility::configurePlugin(
            'IgRuckzuckevent',
            'Management',
            [
                CalendarController::class => 'organizerList, new, create, edit, update, delete, export, list, show',
                RegistrationController::class => 'create, loginFirst, subscribe, list, listByEvent, delete, searchExport, exportXls',
                UserController::class => 'new, create, reminder, confirmation, edit, update, delete, list, newSubscription, createSubscription, exportXls, deleteSubscription',
            ],
            // non-cacheable actions
            [
                CalendarController::class => 'organizerList, new, create, edit, update, delete, export, list, show',
                RegistrationController::class => 'create, loginFirst, subscribe, list, listByEvent, delete, searchExport, exportXls',
                UserController::class => 'new, create, reminder, confirmation, edit, update, delete, list, newSubscription, createSubscription, exportXls, deleteSubscription',
            ],
            ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
        );
        ExtensionUtility::configurePlugin(
            'IgRuckzuckevent',
            'ManagementStatistik',
            [
                RegistrationController::class => 'searchExport, exportXls',
            ],
            // non-cacheable actions
            [
                RegistrationController::class => 'searchExport, exportXls',
            ],
            ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
        );
        ExtensionUtility::configurePlugin(
            'IgRuckzuckevent',
            'ManagementUser',
            [
                UserController::class => 'list, new, create, reminder, confirmation, edit, update, delete, newSubscription, createSubscription, exportXls, deleteSubscription',
                RegistrationController::class => 'list, listByEvent, create, loginFirst, subscribe, delete, searchExport, exportXls',
                SubscriptionController::class => 'edit, update',
            ],
            // non-cacheable actions
            [
                UserController::class => 'list, new, create, reminder, confirmation, edit, update, delete, newSubscription, createSubscription, exportXls, deleteSubscription',
                RegistrationController::class => 'list, listByEvent, create, loginFirst, subscribe, delete, searchExport, exportXls',
                SubscriptionController::class => 'edit, update',
            ],
            ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
        );

        ExtensionUtility::configurePlugin(
            'IgRuckzuckevent',
            'User',
            [
                UserController::class => 'show, new, create, reminder, confirmation, edit, update, passwordChange, updatePassword, delete, list',
                RegistrationController::class => 'list, subscribe, delete',
            ],
            // non-cacheable actions
            [
                UserController::class => 'show, new, create, reminder, confirmation, edit, update, passwordChange, updatePassword, delete, list',
                RegistrationController::class => 'list, subscribe, delete',
            ],
            ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
        );
        ExtensionUtility::configurePlugin(
            'IgRuckzuckevent',
            'Payment',
            [
                SubscriptionController::class => 'payment, checkout, transaction',
            ],
            // non-cacheable actions
            [
                SubscriptionController::class => 'payment, checkout, transaction',
            ],
            ExtensionUtility::PLUGIN_TYPE_CONTENT_ELEMENT
        );


        $iconRegistry = GeneralUtility::makeInstance(IconRegistry::class);

        $iconRegistry->registerIcon(
        'ig_ruckzuckevent-plugin-management',
        SvgIconProvider::class,
        ['source' => 'EXT:ig_ruckzuckevent/Resources/Public/Icons/user_plugin_management.svg']
    );

        $iconRegistry->registerIcon(
        'ig_ruckzuckevent-plugin-events',
        SvgIconProvider::class,
        ['source' => 'EXT:ig_ruckzuckevent/Resources/Public/Icons/user_plugin_events.svg']
    );

        $iconRegistry->registerIcon(
        'ig_ruckzuckevent-plugin-feedback',
        SvgIconProvider::class,
        ['source' => 'EXT:ig_ruckzuckevent/Resources/Public/Icons/user_plugin_feedback.svg']
    );

    $iconRegistry->registerIcon(
        'ig_ruckzuckevent-plugin-eventsInProcessing',
        SvgIconProvider::class,
        ['source' => 'EXT:ig_ruckzuckevent/Resources/Public/Icons/kurse_in_bearbeitung.svg']
    );

    $iconRegistry->registerIcon(
        'ig_ruckzuckevent-plugin-eventsArchive',
        SvgIconProvider::class,
        ['source' => 'EXT:ig_ruckzuckevent/Resources/Public/Icons/vergangene_kurse.svg']
    );
    $icons = [
        'igruckzuckevent-folder' => ['source' => 'EXT:ig_ruckzuckevent/Resources/Public/Icons/folder-module-igruckzuckevent.svg'],
    ];
    // registering icons
    $iconProviderClassName = BitmapIconProvider::class;
    foreach ($icons as $identifier => $options) {
        $iconRegistry->registerIcon($identifier, $iconProviderClassName, $options);
    }



    $GLOBALS['TYPO3_CONF_VARS']['MAIL']['layoutRootPaths'][50] = 'EXT:ig_ruckzuckevent/Resources/Private/Email/Layouts/';
    $GLOBALS['TYPO3_CONF_VARS']['MAIL']['partialRootPaths'][50] = 'EXT:ig_ruckzuckevent/Resources/Private/Email/Partials/';
    $GLOBALS['TYPO3_CONF_VARS']['MAIL']['templateRootPaths'][50] = 'EXT:ig_ruckzuckevent/Resources/Private/Email/Templates/';
    }
);

// Register page TSconfig for event category link handler
ExtensionManagementUtility::addPageTSConfig(
    '@import "EXT:ig_ruckzuckevent/Configuration/page.tsconfig"'
);

$GLOBALS['TYPO3_CONF_VARS']['SC_OPTIONS']['t3lib/class.t3lib_tcemain.php']['processCmdmapClass'][] = ClearCacheDataHandlerHook::class;
$GLOBALS['TYPO3_CONF_VARS']['SC_OPTIONS']['t3lib/class.t3lib_tcemain.php']['processDatamapClass'][] = ClearCacheDataHandlerHook::class;

$GLOBALS['TYPO3_CONF_VARS']['SC_OPTIONS']['t3lib/class.t3lib_tcemain.php']['processDatamapClass'][] = AdditionalFieldsDataHandlerHook::class;

// Register event deadline validation hook
$GLOBALS['TYPO3_CONF_VARS']['SC_OPTIONS']['t3lib/class.t3lib_tcemain.php']['processDatamapClass'][] = ValidateEventDeadlineDataHandlerHook::class;


$GLOBALS['TYPO3_CONF_VARS']['SYS']['formEngine']['nodeRegistry'][1737221013] = [
    'nodeName' => 'additionalFields',
    'priority' => 41,
    'class'    => AdditionalFieldsFormElement::class,
];

// Register upgrade wizard for TYPO3 13 plugin migration
$GLOBALS['TYPO3_CONF_VARS']['SC_OPTIONS']['ext/install']['update']['igRuckzuckeventPluginToCType']
    = PluginToCTypeUpgradeWizard::class;
