<?php
namespace Ig\IgRuckzuckevent\Controller;

use Psr\Http\Message\ServerRequestInterface;
use TYPO3\CMS\Core\Mail\Mailer;
use TYPO3\CMS\Core\Mail\FluidEmail;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Fluid\View\StandaloneView;

class ActionController extends \Internetgalerie\IgDatapoolFe\Controller\ActionController
{
    /**
     * Create a fluid template
     *
     * @param string $name
     * @return \TYPO3\CMS\Fluid\View\StandaloneView
     */
    private function createFluidTemplate($name)
    {
        $extbaseFrameworkConfiguration = $this->configurationManager->getConfiguration(
            \TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface::CONFIGURATION_TYPE_FRAMEWORK
        );
        $view = GeneralUtility::makeInstance(StandaloneView::class);
        //$view->setControllerContext($this->controllerContext);
        $view->setLayoutRootPaths($extbaseFrameworkConfiguration['view']['layoutRootPaths']);
        $view->setTemplateRootPaths($extbaseFrameworkConfiguration['view']['templateRootPaths']);
        $view->setPartialRootPaths($extbaseFrameworkConfiguration['view']['partialRootPaths']);
        $view->setTemplate($name);
        return $view;
    }

    protected function sendHtmlMail(string $subject, array $from, array $to, string $template, array $variables = []): void
    {
        if($this->settings['useFluidEmail']) {
            $email = $this->getFluidEmail($subject, $from, $to, $template, $variables);
            $this->sendFluidEmail($email);
        } else {
            $mailView = $this->createFluidTemplate($template);
            $mailView->assignMultiple($variables);
            //die($mailView->render());
            // Create mail object and send mail to email address the user who registered to the event entered
            $mail = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\\CMS\\Core\\Mail\\MailMessage');
            $mail->setSubject($subject)
            ->setFrom($from)
            ->setTo($to)
            ->setBody($mailView->render(), 'text/html')
            ->send();
        }
    }

    protected function getFluidEmail(string $subject, array $from, array $to, string $template, array $variables = []): FluidEmail
    {
        $email = GeneralUtility::makeInstance(FluidEmail::class)
                ->subject($subject)
                ->from(...$from)
                ->to(...$to)
                ->setTemplate($template)
                ->format('html')
                ->assign('settings', $this->settings)
                ->assignMultiple($variables);
        if ($GLOBALS['TYPO3_REQUEST'] instanceof ServerRequestInterface) {
            $email->setRequest($GLOBALS['TYPO3_REQUEST']);
        }
        return $email;
    }


    protected function sendFluidEmail(FluidEmail $email): void
    {
        GeneralUtility::makeInstance(Mailer::class)->send($email);
    }

}
