<?php
namespace Ig\IgRuckzuckevent\Controller;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Utility\DebuggerUtility;
use Ig\IgRuckzuckevent\Domain\Model\Category;
use Internetgalerie\IgDynval\Controller\DynamicValidationActionController;
use Psr\Http\Message\ResponseInterface;

/**
 * The EventController handles all actions directly related to Events.
 */
class CategoryController extends ActionController
{
    use DynamicValidationActionController;

    /**
     * The repository for categories
     *
     * @var \Ig\IgRuckzuckevent\Domain\Repository\CategoryRepository
     */
    protected $categoryRepository = null;

    /**
     * @param \Ig\IgRuckzuckevent\Domain\Repository\CategoryRepository $categoryRepository
     */
    public function injectCategoryRepository(\Ig\IgRuckzuckevent\Domain\Repository\CategoryRepository $categoryRepository): void
    {
        $this->categoryRepository = $categoryRepository;
    }

    public function initializeView($view): void
    {
        $this->view->assign('controller', 'Category');
        $this->view->assign('pageUid', $GLOBALS['TSFE']->id);
    }

    public function listAction(): ResponseInterface
    {
        $categories = $this->categoryRepository->findAll();
        $this->view->assign('categories', $categories);

        return $this->htmlResponse();
    }

    /**
     * New action
     *
     * @return void
     */
    public function newAction(): ResponseInterface
    {
        $categories = $this->categoryRepository->findAll();
        $this->view->assign('categories', $categories);

        return $this->htmlResponse();
    }

    /**
     * Create action
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Category $newCategory
     * @TYPO3\CMS\Extbase\Annotation\Validate("Internetgalerie\IgDynval\Validation\Validator\DynamicValidator", param="newCategory")
     * @return void
     */
    public function createAction(Category $newCategory): ResponseInterface
    {
        $this->categoryRepository->add($newCategory);
        return $this->redirect('list');
    }

    /**
     * Edit action
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Category $category
     * @return void
     * @TYPO3\CMS\Extbase\Annotation\IgnoreValidation $category
     */
    public function editAction(Category $category): ResponseInterface
    {
        $categories = $this->categoryRepository->findAll();
        $this->view->assign('categories', $categories);
        $this->view->assign('category', $category);

        return $this->htmlResponse();
    }

    /**
     * Update action
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Category $category
     * @TYPO3\CMS\Extbase\Annotation\Validate("Internetgalerie\IgDynval\Validation\Validator\DynamicValidator", param="category")
     * @return void
     */
    public function updateAction(Category $category): ResponseInterface
    {
        $this->categoryRepository->update($category);
        return $this->redirect('list');
    }

    /**
     * Delete action
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Category $category
     * @return void
     */
    public function deleteAction(Category $category): ResponseInterface
    {
        $this->categoryRepository->remove($category);
        return $this->redirect('list');
    }

}
