<?php
namespace Ig\IgRuckzuckevent\Controller;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Utility\DebuggerUtility;
use Ig\IgRuckzuckevent\Domain\Model\Organizer;
use Internetgalerie\IgDynval\Controller\DynamicValidationActionController;
use Psr\Http\Message\ResponseInterface;

class OrganizerController extends ActionController
{
    use DynamicValidationActionController;

    /**
     * The repository for organizers
     *
     * @var \Ig\IgRuckzuckevent\Domain\Repository\OrganizerRepository
     */
    protected $organizerRepository = null;

    /**
     * @param \Ig\IgRuckzuckevent\Domain\Repository\OrganizerRepository $organizerRepository
     */
    public function injectOrganizerRepository(\Ig\IgRuckzuckevent\Domain\Repository\OrganizerRepository $organizerRepository): void
    {
        $this->organizerRepository = $organizerRepository;
    }

    public function initializeView($view): void
    {
        $this->view->assign('controller', 'Organizer');
        $this->view->assign('pageUid', $GLOBALS['TSFE']->id);
    }

    /**
     * Liast all events with possibility to sort and filter them
     *
     * @return void
     */
    public function listAction(): ResponseInterface
    {
        $organizers = $this->organizerRepository->findAll();
        $this->view->assign('organizers', $organizers);

        return $this->htmlResponse();
    }

    /**
     * Liast all events with possibility to sort and filter them
     *
     * @return void
     */
    public function organizerListAction(): ResponseInterface
    {
        $organizers = $this->organizerRepository->findAll();
        $this->view->assign('organizers', $organizers);

        return $this->htmlResponse();
    }

    /**
     * New action
     *
     * @return void
     */
    public function newAction(): ResponseInterface
    {

        return $this->htmlResponse();
    }

    /**
     * Create action
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Organizer $newOrganizer
     * @TYPO3\CMS\Extbase\Annotation\Validate("Internetgalerie\IgDynval\Validation\Validator\DynamicValidator", param="newOrganizer")
     * @return void
     */
    public function createAction(Organizer $newOrganizer): ResponseInterface
    {
        $this->organizerRepository->add($newOrganizer);
        return $this->redirect('list');
    }

    /**
     * Edit action
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Organizer $organizer
     * @return void
     * @TYPO3\CMS\Extbase\Annotation\IgnoreValidation $organizer
     */
    public function editAction(Organizer $organizer): ResponseInterface
    {
        $this->view->assign('organizer', $organizer);

        return $this->htmlResponse();
    }

    /**
     * Update action
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Organizer $organizer
     * @TYPO3\CMS\Extbase\Annotation\Validate("Internetgalerie\IgDynval\Validation\Validator\DynamicValidator", param="organizer")
     * @return void
     */
    public function updateAction(Organizer $organizer): ResponseInterface
    {
        $this->organizerRepository->update($organizer);
        return $this->redirect('list');
    }

    /**
     * Delete action
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Organizer $organizer
     * @return void
     */
    public function deleteAction(Organizer $organizer): ResponseInterface
    {
        $this->organizerRepository->remove($organizer);
        return $this->redirect('list');
    }

}
