<?php
namespace Ig\IgRuckzuckevent\Controller;

use Evoweb\Recaptcha\Services\CaptchaService;
use Ig\IgRuckzuckevent\Domain\Model\Event;
use Ig\IgRuckzuckevent\Utility\CacheUtility;
use Ig\IgRuckzuckevent\Utility\UserUtility;
use Ig\IgRuckzuckevent\Event\BeforeSendUserMailEvent;
use Ig\IgRuckzuckevent\Event\RegistrationEvent;
use Internetgalerie\IgDynval\Controller\DynamicValidationActionController;
use Internetgalerie\IgFrontendUser\Domain\Repository\FrontendUserGroupRepository;
use Psr\EventDispatcher\EventDispatcherInterface;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Mail\FluidEmail;
use TYPO3\CMS\Core\Mail\Mailer;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Http\ForwardResponse;
use TYPO3\CMS\Extbase\Mvc\Controller\Exception\RequiredArgumentMissingException;
use TYPO3\CMS\Extbase\Persistence\Generic\PersistenceManager;
use TYPO3\CMS\Extbase\Utility\DebuggerUtility;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;
use TYPO3\CMS\Fluid\View\StandaloneView;


/**
 * The RegistrationController handles all the actions directly related to Registrations
 */
class RegistrationController extends ActionController
{
    use DynamicValidationActionController;

    /**
     * The repository for registrations
     *
     * @var \Ig\IgRuckzuckevent\Domain\Repository\RegistrationRepository
     */
    protected $registrationRepository = null;

    /**
     * The repository for registrations
     *
     * @var \Ig\IgRuckzuckevent\Domain\Repository\StatusRepository
     */
    protected $statusRepository = null;

    /**
     * The repository for registrations
     *
     * @var \Ig\IgRuckzuckevent\Domain\Repository\AttentionRepository
     */
    protected $attentionRepository = null;

    /**
     * The repository for events
     *
     * @var \Ig\IgRuckzuckevent\Domain\Repository\EventRepository
     */
    protected $eventRepository = null;

    /**
     * The repository for eventgroups
     *
     * @var \Ig\IgRuckzuckevent\Domain\Repository\EventgroupRepository
     */
    protected $eventgroupRepository = null;

    /**
     * feUserRepository
     *
     * @var \Ig\IgRuckzuckevent\Domain\Repository\FeUserRepository
     */
    protected $feUserRepository = null;

    /**
     * feUserGroupRepository
     *
     * @var \Internetgalerie\IgFrontendUser\Domain\Repository\FrontendUserGroupRepository
     */
    protected $feUserGroupRepository = null;

    /**
     * subscriptionOfferRepository
     *
     * @var \Ig\IgRuckzuckevent\Domain\Repository\SubscriptionOfferRepository
     */
    protected $subscriptionOfferRepository = null;

    /**
     * subscriptionRepository
     *
     * @var \Ig\IgRuckzuckevent\Domain\Repository\SubscriptionRepository
     */
    protected $subscriptionRepository = null;

    /**
     * workareaRepository
     *
     * @var \Ig\IgRuckzuckevent\Domain\Repository\WorkareaRepository
     */
    protected $workareaRepository = null;

    /**
     * @param \Ig\IgRuckzuckevent\Domain\Repository\RegistrationRepository $registrationRepository
     */
    public function injectRegistrationRepository(\Ig\IgRuckzuckevent\Domain\Repository\RegistrationRepository $registrationRepository): void
    {
        $this->registrationRepository = $registrationRepository;
    }

    /**
     * Set the value of The repository for registrations
     *
     * @param \Ig\IgRuckzuckevent\Domain\Repository\StatusRepository $statusRepository
     */
    public function injectStatusRepository(\Ig\IgRuckzuckevent\Domain\Repository\StatusRepository $statusRepository): void
    {
        $this->statusRepository = $statusRepository;
    }

    /**
     * @param \Ig\IgRuckzuckevent\Domain\Repository\AttentionRepository $attentionRepository
     */
    public function injectAttentionRepository(\Ig\IgRuckzuckevent\Domain\Repository\AttentionRepository $attentionRepository): void
    {
        $this->attentionRepository = $attentionRepository;
    }

    /**
     * @param \Ig\IgRuckzuckevent\Domain\Repository\EventRepository $eventRepository
     */
    public function injectEventRepository(\Ig\IgRuckzuckevent\Domain\Repository\EventRepository $eventRepository): void
    {
        $this->eventRepository = $eventRepository;
    }

    /**
     * @param \Ig\IgRuckzuckevent\Domain\Repository\EventgroupRepository $eventgroupRepository
     */
    public function injectEventgroupRepository(\Ig\IgRuckzuckevent\Domain\Repository\EventgroupRepository $eventgroupRepository): void
    {
        $this->eventgroupRepository = $eventgroupRepository;
    }

    /**
     * @param \Ig\IgRuckzuckevent\Domain\Repository\FeUserRepository $feUserRepository
     */
    public function injectFeUserRepository(\Ig\IgRuckzuckevent\Domain\Repository\FeUserRepository $feUserRepository): void
    {
        $this->feUserRepository = $feUserRepository;
    }

    /**
     * @param \Internetgalerie\IgFrontendUser\Domain\Repository\FrontendUserGroupRepository $feUserGroupRepository
     */
    public function injectFeUserGroupRepository(FrontendUserGroupRepository $feUserGroupRepository): void
    {
        $this->feUserGroupRepository = $feUserGroupRepository;
    }

    /**
     * @param \Ig\IgRuckzuckevent\Domain\Repository\SubscriptionOfferRepository $subscriptionOfferRepository
     */
    public function injectSubscriptionOfferRepository(\Ig\IgRuckzuckevent\Domain\Repository\SubscriptionOfferRepository $subscriptionOfferRepository): void
    {
        $this->subscriptionOfferRepository = $subscriptionOfferRepository;
    }

    /**
     * @param \Ig\IgRuckzuckevent\Domain\Repository\SubscriptionRepository $subscriptionRepository
     */
    public function injectSubscriptionRepository(\Ig\IgRuckzuckevent\Domain\Repository\SubscriptionRepository $subscriptionRepository): void
    {
        $this->subscriptionRepository = $subscriptionRepository;
    }

    /**
     * @param \Ig\IgRuckzuckevent\Domain\Repository\WorkareaRepository $workareaRepository
     */
    public function injectWorkareaRepository(\Ig\IgRuckzuckevent\Domain\Repository\WorkareaRepository $workareaRepository): void
    {
        $this->workareaRepository = $workareaRepository;
    }

    public function __construct(protected CaptchaService $captchaService)
    {
        
    }


    public function initializeView($view): void
    {
        $this->view->assign('controller', 'Registration');
        $this->view->assign('pageUid', $GLOBALS['TSFE']->id);

        //parent::initializeView($view);
    }


    /**
     * Initializes the current action
     *
     * @return void
     */
    public function initializeAction(): void
    {
        parent::initializeAction();
        if (isset($this->arguments['registration']) || isset($this->arguments['newRegistration'])) {
            if (isset($this->arguments['registration'])) {
                $registration = $this->arguments['registration'];
            } else {
                $registration = $this->arguments['newRegistration'];
            }
            $propertyMappingConfiguration = $registration->getPropertyMappingConfiguration();

            // Set date format of date fields
            foreach (['validFrom'] as $dateField) {
                $propertyMappingConfiguration->forProperty($dateField)->setTypeConverterOption(
                    'TYPO3\\CMS\\Extbase\\Property\\TypeConverter\\DateTimeConverter',
                    \TYPO3\CMS\Extbase\Property\TypeConverter\DateTimeConverter::CONFIGURATION_DATE_FORMAT,
                    'd.m.Y'
                );
            }
        }
    }


    /**
     * action new
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Event|null $event
     * @return void
     * @TYPO3\CMS\Extbase\Annotation\IgnoreValidation("event")
     */
    public function newAction(?\Ig\IgRuckzuckevent\Domain\Model\Event $event = null,  array $default = []): ResponseInterface
    {
        if (is_null($event) && isset($this->settings['flexform']['event']) && (int)$this->settings['flexform']['event'] > 0) {
            /** @var Event */
            $event = $this->eventRepository->findByUid((int)$this->settings['flexform']['event']);
        }
        if (is_null($event)) {
            throw new RequiredArgumentMissingException('Required argument "event" is not set for Ig\IgRuckzuckevent\Controller\RegistrationController->new.');
        }

        $now = new \DateTime();
        if($event->getDateTimeFrom() < $now) {
            return $this->htmlResponse('');
        }
        $workspaces = [];
        $i = 0;
        foreach ($GLOBALS['TCA']['tx_igruckzuckevent_domain_model_registration']['columns']['workspace']['config']['items'] as $item) {
            if ($i++ > 0) {
                $workspaces[$item['value']] = LocalizationUtility::translate($item['label'], 'IgRuckzuckevent');
            }
        }
        $workareas = $this->workareaRepository->findAll();
        $statusses = $this->statusRepository->findAll();
        $attentions = $this->attentionRepository->findAll();

        $context = GeneralUtility::makeInstance(Context::class);
        $languageUid = $context->getPropertyFromAspect('language', 'id');

        $this->view->assign('default', $default);
        $this->view->assign('event', $event);
        $this->view->assign('statusses', $statusses);
        $this->view->assign('attentions', $attentions);
        $this->view->assign('workspaces', $workspaces);
        $this->view->assign('workareas', $workareas);
        $this->view->assign('sys_language_uid', $languageUid);
        $this->view->assign('captchaConfiguration', $this->captchaService->getConfiguration());

        return $this->htmlResponse();
    }


    public function initializeCreateSimpleAction(): void
    {
        if($this->arguments->hasArgument('newRegistration')) {
            // In the model we will serialize the array we got from the form, not the propertymapper shall do this
            $this->arguments->getArgument('newRegistration')->getPropertyMappingConfiguration()->setTargetTypeForSubProperty('additionalFields', 'array');
        }
    }
    /**
     * Action that gets called when submitting the event registration form
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Registration $newRegistration
     * @return void
     * @TYPO3\CMS\Extbase\Annotation\Validate("Internetgalerie\IgDynval\Validation\Validator\DynamicValidator", param="newRegistration")
     */
    public function createSimpleAction(\Ig\IgRuckzuckevent\Domain\Model\Registration $newRegistration, array $default = []): ResponseInterface
    {
        $event = $newRegistration->getEvent();
        // captcha test > forward on empty at the moment
        $status = $this->captchaService->validateReCaptcha($this->request->getParsedBody()['g-recaptcha-response'] ?? '');
        if ($status == false || $status['error'] !== '') {
            return (new ForwardResponse('new'))
                ->withControllerName('Registration')
                ->withArguments(['event' => $newRegistration->getEvent()->getUid()]);
        }

        if(!$event->getRegistrationsPossible() || (($event->getMinRegistrations() > 0 || $event->getMaxRegistrations() > 0) && $event->getFreePlaces() < $newRegistration->getRegistrationCount())) {
            return (new ForwardResponse('new'))
                ->withControllerName('Registration')
                ->withArguments(['event' => $newRegistration->getEvent()->getUid()]);
        }
        $this->registrationRepository->add($newRegistration);
        $persistenceManager = GeneralUtility::makeInstance(PersistenceManager::class);
        $persistenceManager->persistAll();
        $cacheUtility = GeneralUtility::makeInstance(CacheUtility::class);
        $cacheUtility->flushByEventId($event->getUid());
        $context = GeneralUtility::makeInstance(Context::class);
        $languageUid = $context->getPropertyFromAspect('language', 'id');

        $registrationData = GeneralUtility::makeInstance(EventDispatcherInterface::class)->dispatch(
            new RegistrationEvent($newRegistration, $this->request, $default)
        )->getData();

        // Setup fluid template for the confirmation mail
        $variables = [
            'registration' => $newRegistration,
            'langUid' => $languageUid,
            'registrationData' => $registrationData
        ];

        // Send User Mail
        if ($newRegistration->getEmail()) {
            if($this->settings['useFluidEmail']) {
                $email = $this->getFluidEmail(
                    LocalizationUtility::translate('email.user.subject', 'IgRuckzuckevent'),
                    [$this->settings['mailFrom']],
                    [$newRegistration->getEmail()],
                    $this->settings['useFluidEmail'] ? 'IgRuckzuckevent/Registration/Create/User' : 'Mail/User.html',
                    $variables
                );
                $email = GeneralUtility::makeInstance(EventDispatcherInterface::class)->dispatch(
                    new BeforeSendUserMailEvent($email, $registrationData)
                )->getMail();
                $this->sendFluidEmail($email);
            } else {
                // @todo delete non fluid mail or bug - events are not dispatched
                $this->sendHtmlMail(
                    LocalizationUtility::translate('email.user.subject', 'IgRuckzuckevent'),
                    [$this->settings['mailFrom']],
                    [$newRegistration->getEmail()],
                    $this->settings['useFluidEmail'] ? 'IgRuckzuckevent/Registration/Create/User' : 'Mail/User.html',
                    $variables
                );
            }
        }
        // Send admin mail
        if ($this->settings['mailTo'] || $event->getRegistrationEmail() || $event->getOrganizer() && $event->getOrganizer()->getEmail()) {
            $mailTo = $this->settings['mailTo'];
            if($event->getRegistrationEmail()) {
                $mailTo = $event->getRegistrationEmail();
            }
            if ($event->getOrganizer() && $event->getOrganizer()->getEmail()) {
                $mailTo = $event->getOrganizer()->getEmail();
            }
            $this->sendHtmlMail(
                LocalizationUtility::translate('email.admin.subject', 'IgRuckzuckevent'),
                [$this->settings['mailFrom']],
                explode(',', $mailTo),
                $this->settings['useFluidEmail'] ? 'IgRuckzuckevent/Registration/Create/Admin' : 'Mail/Admin.html',
                $variables
            );
        }
        // Redirect to thank you page
        return $this->redirect('thankYou', 'Registration', 'IgRuckzuckevent', ['registration' => $newRegistration], $this->settings['thankYouPageUid']);
    }

    /**
     * Shows thank you page
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Registration $registration
     * @return void
     * @TYPO3\CMS\Extbase\Annotation\IgnoreValidation("registration")
     */
    public function thankYouAction(\Ig\IgRuckzuckevent\Domain\Model\Registration $registration): ResponseInterface
    {
        $this->view->assign('registration', $registration);

        return $this->htmlResponse();
    }



    /**
     * action export
     *
     * @return void
     */
    public function exportAction(): ResponseInterface
    {

        return $this->htmlResponse();
    }


    /**
     * Physio Team
     **/

    /**
     * Action that gets called when submitting the event registration form when logged in
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Registration $newRegistration
     * @param array $dates
     * @param boolean $agb
     * @param string $captcha
     * @param \Ig\IgRuckzuckevent\Domain\Model\Subscription $subscription
     * @return void
     * @TYPO3\CMS\Extbase\Annotation\Validate("Internetgalerie\IgDynval\Validation\Validator\DynamicValidator", param="newRegistration")
     * @TYPO3\CMS\Extbase\Annotation\Validate("\Ig\IgRuckzuckevent\Domain\Validator\DatesValidator", param="dates")
     * @TYPO3\CMS\Extbase\Annotation\Validate("NotEmpty", param="subscription")
     * @TYPO3\CMS\Extbase\Annotation\Validate("\Ig\IgRuckzuckevent\Domain\Validator\SubscriptionCountValidator", param="subscription")
     * @TYPO3\CMS\Extbase\Annotation\Validate("\Ig\IgRuckzuckevent\Domain\Validator\AgbValidator", param="agb")
     */
    public function createAction(\Ig\IgRuckzuckevent\Domain\Model\Registration $newRegistration, array $dates, bool $agb, \Ig\IgRuckzuckevent\Domain\Model\Subscription $subscription = null, $captcha = ''): ResponseInterface
    {
        $context = GeneralUtility::makeInstance(Context::class);
        $userId = $context->getPropertyFromAspect('frontend.user', 'id');
        $isLoggedIn = $context->getPropertyFromAspect('frontend.user', 'isLoggedIn');
        $message = '';
        if ($isLoggedIn && (UserUtility::isAdminLoggedIn() || $newRegistration->getFeUser()->getUid() == $userId)) {
            if ($this->request->hasArgument('managementUser') && UserUtility::isAdminLoggedIn()) {
                $user = $this->feUserRepository->findByUid($this->request->getArgument('managementUser'));
            } else {
                $user = $this->feUserRepository->findByUid($userId);
            }

            if (UserUtility::isAdminLoggedIn()) {
                $newRegistration->setPaymentMethod('office');
            } else {
                $newRegistration->setPaymentMethod($subscription->getSubscriptionOffer()->getName());
            }
            $newRegistration->setFeUser($user);
            $newRegistration->setSubscription($subscription);

            $cacheUtility = GeneralUtility::makeInstance(CacheUtility::class);
            $dateObjects = [];
            $dateErrors = [];
            foreach ($dates as $eventUid) {
                if ($subscription->getDaysLeft() > 0) {
                    $event = $this->eventRepository->findByUid($eventUid);
                    // If no registrations are possible, the deadline is reached or the event is booked up throw a specific error error
                    $skipSetEvent = false;
                    if (!$event -> getRegistrationsPossible()) {
                        $dateErrors[] = 'Keine Anmeldungen für den Kurs am ' . $event->getDateFrom()->format('d.m.Y') . ' möglich';
                        $skipSetEvent = true;
                    } elseif ($event -> getDeadlineReached()) {
                        $dateErrors[] = 'Der Kurs am ' . $event->getDateFrom()->format('d.m.Y') . ' ist bereits vorbei';
                        $skipSetEvent = true;
                    } elseif ($event -> getState() == 'bookedUp') {
                        //var_dump($registration);exit(0);
                        $dateErrors[] = 'Der Kurs am ' . $event->getDateFrom()->format('d.m.Y') . ' ist ausgebucht';
                        $skipSetEvent = true;
                    }

                    if (!$skipSetEvent) {
                        $newRegistration->setEvent($event);
                        $this->registrationRepository->add(clone $newRegistration);
                        $dateObjects[] = $event;
                        $subscription->setDaysLeft($subscription->getDaysLeft() - 1);
                        $cacheUtility->flushByEventId($event->getUid());
                    }
                }
            }

            if (!empty($dateErrors)) {
                $request = $this->request;

                $request->setArgument('dateErrors', $dateErrors);
                return (new ForwardResponse('show'))->withControllerName('Calendar')->withArguments($request->getArguments());
            }

            // Setup fluid template for the confirmation mail
            /*$mailView = $this -> createFluidTemplate('Registration/Mail.html');
            $mailView -> assignMultiple([
                'registration' => $newRegistration,
                'dates' => $dateObjects
            ]);*/

            if (\TYPO3\CMS\Core\Utility\GeneralUtility::validEmail($user -> getEmail())) {
                // Create mail object and send mail to email address the user who registered to the event entered
                $mail = GeneralUtility::makeInstance(FluidEmail::class);
                $mail->from($this->settings['debugMail'] ?: $this->settings['mailFrom'])
                    ->to($this->settings['debugMail'] ?: $user->getEmail())
                    ->subject('Physio-Team Naderi: Sie haben sich an einem Kurs angemeldet')
                    ->format('html')
                    ->setTemplate('IgRuckzuckevent/Registration/Calendar/New/User')
                    ->assignMultiple([
                        'registration' => $newRegistration,
                        'dates' => $dateObjects
                    ]);

                $mail->setRequest($this->request);
                GeneralUtility::makeInstance(Mailer::class)->send($mail);


                /*$mail = GeneralUtility::makeInstance('TYPO3\\CMS\\Core\\Mail\\MailMessage');
                $mail -> setSubject('Physio-Team Naderi: Sie haben sich an einem Kurs angemeldet')
                -> setFrom([$this->settings['debugMail'] ? : $this -> settings['mailFrom']])
                -> setTo([$this->settings['debugMail'] ? : $user -> getEmail()])
                -> setBody($mailView -> render(), 'text/html')
                -> send();*/
            }

            // Admin mail
            $mail = GeneralUtility::makeInstance(FluidEmail::class);
            $mail->from($this->settings['debugMail'] ?: $this->settings['mailFrom'])
                ->to($this->settings['debugMail'] ?: $this -> settings['mailFrom'])
                ->subject('Physio-Team Naderi: Neue Anmeldung an einen Kurs')
                ->format('html')
                ->setTemplate('IgRuckzuckevent/Registration/Calendar/New/Admin')
                ->assignMultiple([
                    'registration' => $newRegistration,
                    'dates' => $dateObjects
                ]);

            $mail->setRequest($this->request);
            GeneralUtility::makeInstance(Mailer::class)->send($mail);

            /*$adminMailView = $this -> createFluidTemplate('Registration/AdminMail.html');
            $adminMailView -> assignMultiple([
                'registration' => $newRegistration,
                'dates' => $dateObjects
            ]);

            $adminMail = GeneralUtility::makeInstance('TYPO3\\CMS\\Core\\Mail\\MailMessage');
            $adminMail -> setSubject('Physio-Team Naderi: Neue Anmeldung an einen Kurs')
            -> setFrom([$this->settings['debugMail'] ? : $this -> settings['mailFrom']])
            -> setTo([$this->settings['debugMail'] ? : $this -> settings['mailFrom']])
            -> setBody($adminMailView -> render(), 'text/html')
            -> send();*/
            

            $message = 'success';
        }

        if (UserUtility::isAdminLoggedIn()) {
            //$pageUid = $this->settings['myflexformsettingpart'];
            $uriBuilder = $this->uriBuilder;
            $uri = $uriBuilder->setTargetPageUid(168)->setArguments(['tx_igruckzuckevent_managementuser' => ['user' => $user]])->build();
            return $this->redirectToURI($uri, $delay=0, $statusCode=303);
        } else {
            return $this -> redirect('list', 'Calendar', 'IgRuckzuckevent', ['message' => $message]);
        }
        exit();
    }


    public function searchExportAction(): ResponseInterface
    {
        $eventGroups=$this->eventgroupRepository->findAll();
        $groupArray = [];

        foreach ($eventGroups as $g) {
            $title = $g->getTitle();

            if ($title) {
                $groupArray[$g->getUid()] = $g->getTitle();
            }
        }

        $this->view->assign('eventGroups', array_unique($groupArray));

        return $this->htmlResponse();
    }

    public function exportXlsAction(): ResponseInterface
    {
        if ($this->request->hasArgument('search')) {
            $eventgroup = $this->eventgroupRepository->findByUid($this->request->getArgument('search')['event']);
            $events = $this->eventRepository->findPassedByTitle($eventgroup->getTitle())->toArray();

            //$phpExcelService = GeneralUtility::makeInstanceService('phpexcel');
            $phpExcel = new \PhpOffice\PhpSpreadsheet\Spreadsheet();
            $phpExcel->setActiveSheetIndex(0);
            $row = 1;

            $phpExcel->getActiveSheet()->SetCellValue('A' . $row, $eventgroup->getTitle());
            $phpExcel->getActiveSheet()->getStyle('A' . $row)->getFont()->setBold(true);

            $row++;

            // Second row: Output attribute titles
            $phpExcel->getActiveSheet()->SetCellValue('A' . $row, 'Datum');
            $phpExcel->getActiveSheet()->SetCellValue('B' . $row, 'Zeit von');
            $phpExcel->getActiveSheet()->SetCellValue('C' . $row, 'Zeit bis');
            $phpExcel->getActiveSheet()->SetCellValue('D' . $row, 'Vorname');
            $phpExcel->getActiveSheet()->SetCellValue('E' . $row, 'Name');
            $phpExcel->getActiveSheet()->SetCellValue('F' . $row, 'E-Mail-Adresse');
            $phpExcel->getActiveSheet()->SetCellValue('G' . $row, 'Telefon');

            // Set second row bold
            $phpExcel->getActiveSheet()->getStyle('A' . $row . ':G' . $row)->getFont()->setBold(true);

            $row++;

            usort($events, function ($a, $b) {
                return $a->getDateTimeFrom() > $b->getDateTimeFrom();
            });
            foreach ($events as $event) {
                // We are beginning at the 3rd row (Excel rows count from 1)
                foreach ($event->getRegistrations() as $registration) {
                    if ($registration->getFeUser() || ($registration->getFirstName() && $registration->getName() && $registration->getEmail())) {
                        $phpExcel->getActiveSheet()->SetCellValue('A' . $row, html_entity_decode($event->getDateFrom()->format('d.m.Y')));
                        $phpExcel->getActiveSheet()->SetCellValue('B' . $row, html_entity_decode($event->getDateTimeFrom()->format('H:i')));
                        $phpExcel->getActiveSheet()->SetCellValue('C' . $row, html_entity_decode($event->getDateTimeTo()->format('H:i')));

                        if ($registration->getFeUser()) {
                            $phpExcel->getActiveSheet()->SetCellValue('D' . $row, $registration->getFeUser()->getFirstName());
                            $phpExcel->getActiveSheet()->SetCellValue('E' . $row, $registration->getFeUser()->getLastName());
                            $phpExcel->getActiveSheet()->SetCellValue('F' . $row, $registration->getFeUser()->getEmail());
                            $phpExcel->getActiveSheet()->SetCellValueExplicit('G' . $row, $registration->getFeUser()->getTelephone(), \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING);
                        } else {
                            $phpExcel->getActiveSheet()->SetCellValue('D' . $row, $registration->getFirstName());
                            $phpExcel->getActiveSheet()->SetCellValue('E' . $row, $registration->getName());
                            $phpExcel->getActiveSheet()->SetCellValue('F' . $row, $registration->getEmail());
                            $phpExcel->getActiveSheet()->SetCellValueExplicit('G' . $row, $registration->getPhone(), \PhpOffice\PhpSpreadsheet\Cell\DataType::TYPE_STRING);
                        }
                        $row++;
                    }
                }
            }

            // Set column width automatically according to their content
            foreach (range('A', 'G') as $column) {
                $phpExcel->getActiveSheet()->getColumnDimension($column)->setAutoSize(true);
            }

            // Temporary fielname
            $fileName = 'typo3temp/events-' . $eventgroup->getUid() . '-' . time() . '.xlsx';

            // Create an Excel Writer
            $excelWriter = new \PhpOffice\PhpSpreadsheet\Writer\Xlsx($phpExcel); // Create an Excel Writer
            // Save to temporary file
            $excelWriter->save($fileName);

            // Set headers
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="' . str_replace('typo3temp/', '', $fileName) . '"');
            header('Cache-Control: max-age=0');
            // If you're serving to IE 9, then the following may be needed
            header('Cache-Control: max-age=1');
            // If you're serving to IE over SSL, then the following may be needed
            header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
            // Date in the past
            header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
            // always modified
            header('Cache-Control: cache, must-revalidate');
            // HTTP/1.1
            header('Pragma: public');
            // HTTP/1.0
            header('Content-Length: ' . filesize($fileName));
            //header('Pragma: no-cache');

            echo file_get_contents($fileName);
            // Output file

            unlink($fileName);
            // Delete temporary file

            exit();

            return $this->htmlResponse();
        }
        return $this->redirect('searchExport');
    }


    /**
     * Deletes a registration
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Registration $registration
     * @param bool $byEvent
     * @return void
     */
    public function deleteAction(\Ig\IgRuckzuckevent\Domain\Model\Registration $registration, $byEvent = false): ResponseInterface
    {
        $user = $registration->getFeUser();
        $event = $registration->getEvent();
        $canDelete = $registration->getCanDelete();

        $context = GeneralUtility::makeInstance(Context::class);
        $userId = $context->getPropertyFromAspect('frontend.user', 'id');
        $isLoggedIn = $context->getPropertyFromAspect('frontend.user', 'isLoggedIn');

        if ($isLoggedIn && (UserUtility::isAdminLoggedIn() || ($user->getUid() == $userId && $canDelete))) {
            $subscription = GeneralUtility::makeInstance('Ig\\IgRuckzuckevent\\Domain\\Model\\Subscription');

            $product = $this->subscriptionOfferRepository->findByUid(1);

            if ($user) {
                $subscription->setSubscriptionOffer($product);
                $subscription->setFeUser($user);

                $startDateObject = new \DateTime();

                $inThreeMonths = clone $startDateObject;
                $inThreeMonths->modify('+' . $product->getDuration() . ' month');

                $subscription->setStartDate($startDateObject);
                $subscription->setExpirationDate($inThreeMonths);
                $subscription->setDaysLeft($product->getDays());

                $user->addSubscription($subscription);

                $this->subscriptionRepository->add($subscription);
            }
            $this->registrationRepository->remove($registration);
        } else {
            $this->addFlashMessage('Anmeldungen können nur bis 24 Stunden vor Kursbeginn gelöscht werden');
        }

        if (UserUtility::isAdminLoggedIn()) {
            if ($byEvent) {
                return $this -> redirect('listByEvent', 'Registration', 'IgRuckzuckevent', ['event' => $event]);
            } else {
                return $this -> redirect('list', 'Registration', 'IgRuckzuckevent', ['user' => $user]);
            }
        } else {
            return $this -> redirect('list', 'Registration', 'IgRuckzuckevent');
        }
    }

    /**
     * Lists the registrations of a user. If no user is provided the logged in user is taken. If a user is provided, admin access is required.
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Event $event
     * @return void
     */
    public function listByEventAction(\Ig\IgRuckzuckevent\Domain\Model\Event $event): ResponseInterface
    {
        if (UserUtility::isAdminLoggedIn()) {
            $this->view->assign('event', $event);
        }

        return $this->htmlResponse();
    }

    /**
     * Lists the registrations of a user. If no user is provided the logged in user is taken. If a user is provided, admin access is required.
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\FeUser $user
     * @return void
     */
    public function listAction(\Ig\IgRuckzuckevent\Domain\Model\FeUser $user = null): ResponseInterface
    {
        $context = GeneralUtility::makeInstance(Context::class);
        $userId = $context->getPropertyFromAspect('frontend.user', 'id');
        $isLoggedIn = $context->getPropertyFromAspect('frontend.user', 'isLoggedIn');
        if (!$user && $userId) {
            $user = $this->feUserRepository->findByUid($userId);
        }

        if ($isLoggedIn && (UserUtility::isAdminLoggedIn() || $user->getUid() == $userId)) {
            $this->view->assign('user', $user);
        }

        return $this->htmlResponse();
    }

    /**
     * Action that gets called when submitting the event registration form when not logged in
     *
     * @param \Ig\IgRuckzuckevent\Domain\Repository\Event $event
     * @param array $dates
     * @param string $mode
     * @return void
     */
    public function loginFirstAction(\Ig\IgRuckzuckevent\Domain\Model\Event $event, array $dates, $mode = 'login'): ResponseInterface
    {
        $GLOBALS['TSFE']->fe_user->setAndSaveSessionData('tx_igruckzuckevent_dates', $dates);

        if ($mode == 'register') {
            return $this->redirect('new', 'User', 'IgRuckzuckevent', ['referer' => $this->generateReferer($event)]);
        } else {
            $redirect = $this->uriBuilder->reset()
            ->setCreateAbsoluteUri(true)
            ->setArguments([
                'return_url' => $this->generateReferer($event)
            ])
            ->setTargetPageUid($this->settings['pageUidLogin'])
            ->build();

            return $this->redirectToURI($redirect);
        }
    }

    /**
     * Action that gets called when hitting the subscription-button in the event registration form
     *
     * @param \Ig\IgRuckzuckevent\Domain\Repository\Event $event
     * @param \Ig\IgRuckzuckevent\Domain\Model\FeUser $user
     * @param array $dates
     * @return void
     */
    public function subscribeAction(\Ig\IgRuckzuckevent\Domain\Model\Event $event = null, \Ig\IgRuckzuckevent\Domain\Model\FeUser $user = null, array $dates = []): ResponseInterface
    {
        $context = GeneralUtility::makeInstance(Context::class);
        $userId = $context->getPropertyFromAspect('frontend.user', 'id');
        $isLoggedIn = $context->getPropertyFromAspect('frontend.user', 'isLoggedIn');
        if (!$user && $userId) {
            $user = $this->feUserRepository->findByUid($userId);
        }

        if ($isLoggedIn && (UserUtility::isAdminLoggedIn() || $user->getUid() == $userId)) {
            $GLOBALS['TSFE']->fe_user->setAndSaveSessionData('tx_igruckzuckevent_dates', $dates);

            $this->view->assign('user', $user);
            $this->view->assign('referer', $this->generateReferer($event));
            $this->view->assign('subscriptionOffers', $this->subscriptionOfferRepository->findAll());
        }

        return $this->htmlResponse();
    }



    /**
     * Create a fluid template
     *
     * @param string $name
     *
     * @return \TYPO3\CMS\Fluid\View\StandaloneView
     */
    private function createFluidTemplate($name)
    {
        $extbaseFrameworkConfiguration = $this -> configurationManager -> getConfiguration(
            \TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface::CONFIGURATION_TYPE_FRAMEWORK
        );

        $view = GeneralUtility::makeInstance(StandaloneView::class);
        $view -> setLayoutRootPaths($extbaseFrameworkConfiguration['view']['layoutRootPaths']);
        $view -> setTemplateRootPaths($extbaseFrameworkConfiguration['view']['templateRootPaths']);
        $view -> setPartialRootPaths($extbaseFrameworkConfiguration['view']['partialRootPaths']);
        $view -> setTemplate($name);

        return $view;
    }


    /**
     * Generates the referer to the show action
     *
     * @param \Ig\IgRuckzuckevent\Domain\Repository\Event $event
     * @return string
     */
    private function generateReferer($event)
    {
        if ($event) {
            $this->uriBuilder->reset()->setCreateAbsoluteUri(true);
            $this->uriBuilder->setArguments([
                'tx_igruckzuckevent_events' => [
                    'controller' => 'Calendar',
                    'action' => 'show',
                    'event' => $event->getUid()
                ]
            ]);
            return $this->uriBuilder->build();
        }

        return null;
    }

}
