<?php
namespace Ig\IgRuckzuckevent\Controller;

use GeorgRinger\NumberedPagination\NumberedPagination;
use Ig\IgRuckzuckevent\PageTitle\EventPageTitleProvider;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Pagination\QueryResultPaginator;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;

/***
 *
 * This file is part of the "Ruck Zuck Event" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2017 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/

/**
 * The RestController offers a RESTful API for retrieving events.
 */
class RestController extends \TYPO3\CMS\Extbase\Mvc\Controller\ActionController
{
    /**
     * The repository for events
     *
     * @var \Ig\IgRuckzuckevent\Domain\Repository\EventRepository
     */
    protected $eventRepository = null;

    /**
     * The repository for eventgroups
     *
     * @var \Ig\IgRuckzuckevent\Domain\Repository\EventgroupRepository
     */
    protected $eventgroupRepository = null;

    /**
     * The repository for categories
     *
     * @var \Ig\IgRuckzuckevent\Domain\Repository\CategoryRepository
     */
    protected $categoryRepository = null;

    /**
     * The repository for sponsors
     *
     * @var \Ig\IgRuckzuckevent\Domain\Repository\SponsorRepository
     */
    protected $sponsorRepository = null;

    /**
     * The repository for organizers
     *
     * @var \Ig\IgRuckzuckevent\Domain\Repository\OrganizerRepository
     */
    protected $organizerRepository = null;

    /**
     * The repository for qualifications
     *
     * @var \Ig\IgRuckzuckevent\Domain\Repository\QualificationRepository
     */
    protected $qualificationRepository = null;

    /**
     * Upload file service for handling uploaded files
     *
     */
    protected $uploadFileService = null;

    /**
     * @param \Ig\IgRuckzuckevent\Domain\Repository\EventRepository $eventRepository
     */
    public function injectEventRepository(\Ig\IgRuckzuckevent\Domain\Repository\EventRepository $eventRepository)
    {
        $this->eventRepository = $eventRepository;
    }

    /**
     * @param \Ig\IgRuckzuckevent\Domain\Repository\EventgroupRepository $eventgroupRepository
     */
    public function injectEventgroupRepository(\Ig\IgRuckzuckevent\Domain\Repository\EventgroupRepository $eventgroupRepository)
    {
        $this->eventgroupRepository = $eventgroupRepository;
    }

    /**
     * @param \Ig\IgRuckzuckevent\Domain\Repository\CategoryRepository $categoryRepository
     */
    public function injectCategoryRepository(\Ig\IgRuckzuckevent\Domain\Repository\CategoryRepository $categoryRepository)
    {
        $this->categoryRepository = $categoryRepository;
    }

    /**
     * @param \Ig\IgRuckzuckevent\Domain\Repository\SponsorRepository $sponsorRepository
     */
    public function injectSponsorRepository(\Ig\IgRuckzuckevent\Domain\Repository\SponsorRepository $sponsorRepository)
    {
        $this->sponsorRepository = $sponsorRepository;
    }

    /**
     * @param \Ig\IgRuckzuckevent\Domain\Repository\OrganizerRepository $organizerRepository
     */
    public function injectOrganizerRepository(\Ig\IgRuckzuckevent\Domain\Repository\OrganizerRepository $organizerRepository)
    {
        $this->organizerRepository = $organizerRepository;
    }

    /**
     * @param \Ig\IgRuckzuckevent\Domain\Repository\QualificationRepository $qualificationRepository
     */
    public function injectQualificationRepository(\Ig\IgRuckzuckevent\Domain\Repository\QualificationRepository $qualificationRepository)
    {
        $this->qualificationRepository = $qualificationRepository;
    }

    public function eventListAction(): ResponseInterface
    {
        //$currentPage = $this->request->hasArgument('currentPage') ? (int) $this->request->getArgument('currentPage') : 1;

        $events = $this->eventRepository->findBySearchAndSorting($this->getSearch(), $this->getSorting());

        //$paginator = new QueryResultPaginator($events, $currentPage, 20);
        //$pagination = new NumberedPagination($paginator, 10); // zweiter Argument: maximal Anzahl Links

        $site = $GLOBALS['TYPO3_REQUEST']->getAttribute('site');

        $json = [];
        foreach($events as $item) {
            $row = $item->getJson();
            $row['detailLink'] = $this->uriBuilder
                ->reset()
                ->setCreateAbsoluteUri(true)
                ->setTargetPageUid($this->settings['detailPageUid'])
                ->uriFor('show', ['event' => $item->getUid()], 'Event', 'IgRuckzuckevent', 'EventDetail');
            $row['registrationLink'] = $this->uriBuilder
                ->reset()
                ->setCreateAbsoluteUri(true)
                ->setTargetPageUid($this->settings['registrationPageUid'])
                ->uriFor('new', ['event' => $item->getUid()], 'Registration', 'IgRuckzuckevent', 'Registration');
            $json[] = $row;
        }

        return $this->jsonResponse(json_encode($json));
    }

    public function eventShowAction(\Ig\IgRuckzuckevent\Domain\Model\Event $event): ResponseInterface
    {
        $json = $event->getJson();
        $json['detailLink'] = $this->uriBuilder
            ->reset()
            ->setCreateAbsoluteUri(true)
            ->setTargetPageUid($this->settings['detailPageUid'])
            ->uriFor('show', ['event' => $event->getUid()], 'Event', 'IgRuckzuckevent', 'EventDetail');
        $json['registrationLink'] = $this->uriBuilder
            ->reset()
            ->setCreateAbsoluteUri(true)
            ->setTargetPageUid($this->settings['registrationPageUid'])
            ->uriFor('new', ['event' => $event->getUid()], 'Registration', 'IgRuckzuckevent', 'Registration');

        return $this->jsonResponse(json_encode($json));
    }

    /**
     * Get the search array
     *
     * @return array
     */
    private function getSearch()
    {
        $search = [];
        if ($this->request) {
            $arguments = $this->request->getArguments();
        } elseif (GeneralUtility::_GP('tx_igruckzuckevent_events') && GeneralUtility::_GP('tx_igruckzuckevent_events')['search']) {
            $arguments = GeneralUtility::_GP('tx_igruckzuckevent_events')['search'];
        } elseif (GeneralUtility::_GP('tx_igruckzuckevent_eventsarchive') && GeneralUtility::_GP('tx_igruckzuckevent_eventsarchive')['search']) {
            $arguments = [];
        }
        if (isset($arguments['search'])) {
            $search = $arguments['search'];
        }
        $this->view->assign('search', $search);
        return $search;
    }

    /**
     * Get the sorting array for the repository
     *
     * @return array
     */
    private function getSorting()
    {
        $sorting = [];
        if ($this->request) {
            $arguments = $this->request->getArguments();
        } else {
            $arguments = [];
        }
        if (isset($arguments['sorting'])) {
            $sorting = $arguments['sorting'];
        } elseif (GeneralUtility::_GP('tx_igruckzuckevent_events') && GeneralUtility::_GP('tx_igruckzuckevent_events')['sorting']) {
            $arguments = GeneralUtility::_GP('tx_igruckzuckevent_events')['sorting'];
        } else {
            // If no sorting was requested, use default sorting
            $sorting = [];
            $sorting['field'] = 'dateFrom';
            $sorting['direction']['dateFrom'] = 'ASC';
            $sorting['direction']['title'] = 'ASC';
        }
        // This is the sorting array given to the repository
        $sortingArr = [$sorting['field'] => $sorting['direction'][$sorting['field']]];
        if ($sorting['field'] == 'dateFrom') {
            $sortingArr['timeFrom'] = $sorting['direction'][$sorting['field']];
        }
        // If the current sorting direction of the current sorting field is ASC, switch it  to DESC, but all others stay at ASC
        // Else switch all sorting directions to ASC
        $currentSorting = $sorting;
        if ($sorting['direction'][$sorting['field']] == 'ASC') {
            foreach ($sorting['direction'] as &$sortingDirection) {
                $sortingDirection = 'ASC';
            }
            $sorting['direction'][$sorting['field']] = 'DESC';
        } else {
            foreach ($sorting['direction'] as &$sortingDirection) {
                $sortingDirection = 'ASC';
            }
        }
        $this->view->assign('currentSorting', $currentSorting);
        $this->view->assign('sorting', $sorting);
        return $sortingArr;
    }

}
