<?php
namespace Ig\IgRuckzuckevent\Controller;

use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Utility\DebuggerUtility;
use Ig\IgRuckzuckevent\Domain\Model\Sponsor;
use Internetgalerie\IgDynval\Controller\DynamicValidationActionController;
use Psr\Http\Message\ResponseInterface;

/***
 *
 * This file is part of the "Ruck Zuck Event" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2017 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/

/**
 * The EventController handles all actions directly related to Events.
 */
class SponsorController extends ActionController
{
    use DynamicValidationActionController;

    /**
     * The repository for sponsors
     *
     * @var \Ig\IgRuckzuckevent\Domain\Repository\SponsorRepository
     */
    protected $sponsorRepository = null;

    /**
     * @param \Ig\IgRuckzuckevent\Domain\Repository\SponsorRepository $sponsorRepository
     */
    public function injectSponsorRepository(\Ig\IgRuckzuckevent\Domain\Repository\SponsorRepository $sponsorRepository): void
    {
        $this->sponsorRepository = $sponsorRepository;
    }

    public function initializeView($view): void
    {
        $this->view->assign('controller', 'Sponsor');
        $this->view->assign('pageUid', $GLOBALS['TSFE']->id);
    }

    public function listAction(): ResponseInterface
    {
        $sponsors = $this->sponsorRepository->findAll();
        $this->view->assign('sponsors', $sponsors);

        return $this->htmlResponse();
    }

    /**
     * New action
     *
     * @return void
     */
    public function newAction(): ResponseInterface
    {

        return $this->htmlResponse();
    }

    /**
     * Create action
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Sponsor $newSponsor
     * @TYPO3\CMS\Extbase\Annotation\Validate("Internetgalerie\IgDynval\Validation\Validator\DynamicValidator", param="newSponsor")
     * @return void
     */
    public function createAction(Sponsor $newSponsor): ResponseInterface
    {
        $this->sponsorRepository->add($newSponsor);
        return $this->redirect('list');
    }

    /**
     * Edit action
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Sponsor $sponsor
     * @return void
     * @TYPO3\CMS\Extbase\Annotation\IgnoreValidation $sponsor
     */
    public function editAction(Sponsor $sponsor): ResponseInterface
    {
        $this->view->assign('sponsor', $sponsor);

        return $this->htmlResponse();
    }

    /**
     * Update action
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Sponsor $sponsor
     * @TYPO3\CMS\Extbase\Annotation\Validate("Internetgalerie\IgDynval\Validation\Validator\DynamicValidator", param="sponsor")
     * @return void
     */
    public function updateAction(Sponsor $sponsor): ResponseInterface
    {
        $this->sponsorRepository->update($sponsor);
        return $this->redirect('list');
    }

    /**
     * Delete action
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Sponsor $sponsor
     * @return void
     * @TYPO3\CMS\Extbase\Annotation\IgnoreValidation $sponsor
     */
    public function deleteAction(Sponsor $sponsor): ResponseInterface
    {
        $this->sponsorRepository->remove($sponsor);
        return $this->redirect('list');
    }

}
