<?php
namespace Ig\IgRuckzuckevent\Domain\Model;

use Ig\IgRuckzuckevent\Utility\JsonUtility;

/***
 *
 * This file is part of the "Ruck Zuck Event" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2018 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/

/**
 * Attention
 */
class Attention extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{
    /**
     * attention
     *
     * @var string
     * @TYPO3\CMS\Extbase\Annotation\Validate("NotEmpty")
     */
    protected $attention = '';

    /**
     * Returns the attention
     *
     * @return string $attention
     */
    public function getAttention()
    {
        return $this->attention;
    }

    /**
     * Sets the attention
     *
     * @param string $attention
     * @return void
     */
    public function setAttention($attention)
    {
        $this->attention = $attention;
    }

    public function getJson()
    {
        return JsonUtility::getJsonForProperties($this->_getProperties());
    }
}
