<?php
namespace Ig\IgRuckzuckevent\Domain\Model;

use Ig\IgRuckzuckevent\Domain\Repository\RegistrationRepository;
use Ig\IgRuckzuckevent\Domain\Repository\SubscriptionRepository;
use Ig\IgRuckzuckevent\Utility\JsonUtility;
use Internetgalerie\IgFrontendUser\Domain\Model\FrontendUser;
use TYPO3\CMS\Core\Utility\GeneralUtility;

/***
 *
 * This file is part of the "Ruck Zuck Event" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2017 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/

/**
 * The FeUser model represents the frontend user
 */
class FeUser extends FrontendUser
{
    /**
     * @var string $username
     */
    protected $username = '';
    
    /**
     * @var string $username
     */
    protected $password = '';

    /**
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgRuckzuckevent\Domain\Model\Subscription> $subscriptions
     * @TYPO3\CMS\Extbase\Annotation\ORM\Cascade remove
     */
    protected $subscriptions = null;

    /**
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgRuckzuckevent\Domain\Model\Registration> $registrations
     * @TYPO3\CMS\Extbase\Annotation\ORM\Cascade remove
     */
    protected $registrations = null;

    /**
     * disable
     *
     * @var boolean
     */
    protected $disable = true;

    /**
     * deleted
     *
     * @var boolean
     */
    protected $deleted = false;

    /**
     * hash
     *
     * @var string
     */
    protected $hash = '';

    /**
     * Constructor
     */
    public function __construct()
    {
        //Do not remove the next line: It would break the functionality
        $this -> initStorageObjects();
        parent::__construct();
    }

    /**
     * Initializes all ObjectStorage properties
     *
     * @return void
     */
    protected function initStorageObjects()
    {
        $this -> registrations = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
        $this -> subscriptions = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
    }

    /**
     * Returns the subscriptions
     *
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgRuckzuckevent\Domain\Model\Subscription> $subscriptions
     */
    public function getSubscriptions()
    {
        return $this->subscriptions;
    }

    public function getActiveSubscriptions()
    {
        $subscriptionRepository = GeneralUtility::makeInstance(SubscriptionRepository::class);
        return $subscriptionRepository->findActiveSubscriptions($this);
    }

    /**
     * Sets the subscriptions
     *
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgRuckzuckevent\Domain\Model\Subscription> $subscriptions
     *
     * @return void
     */
    public function setSubscriptions(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $subscriptions)
    {
        $this->subscriptions = $subscriptions;
    }

    /**
     * Adds an subscription
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Subscription $subscription
     * @return void
     */
    public function addSubscription(\Ig\IgRuckzuckevent\Domain\Model\Subscription $subscription)
    {
        $this -> subscriptions -> attach($subscription);
    }

    /**
     * Removes an subscription
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Subscription $subscription
     * @return void
     */
    public function removeSubscription(\Ig\IgRuckzuckevent\Domain\Model\Subscription $subscription)
    {
        $this -> subscriptions -> detach($subscription);
    }

    /**
     * Returns the registrations
     *
     * @return array $registrations
     */
    public function getRegistrations()
    {
        return $this->registrations;
    }

    public function getRegistrationsSorted()
    {
        $registrations = $this->getRegistrations()->toArray();

        usort($registrations, function ($a, $b) {
            return $a->getEvent()->getDateTimeFrom() > $b->getEvent()->getDateTimeFrom();
        });

        return $registrations;
    }

    /**
     * Returns the registrations
     *
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgRuckzuckevent\Domain\Model\Registration> $registrations
     */
    public function getNextRegistrations()
    {
        $registrationRepository = GeneralUtility::makeInstance(RegistrationRepository::class);
        return $registrationRepository->findNextRegistrations($this);
    }

    /**
     * Returns the registrations
     *
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgRuckzuckevent\Domain\Model\Registration> $registrations
     */
    public function getPassedRegistrations()
    {
        $registrationRepository = GeneralUtility::makeInstance(RegistrationRepository::class);
        return $registrationRepository->findPassedRegistrations($this);
    }


    /**
     * Sets the registrations
     *
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgRuckzuckevent\Domain\Model\Registration> $registrations
     *
     * @return void
     */
    public function setRegistrations(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $registrations)
    {
        $this->registrations = $registrations;
    }

    /**
     * Adds an registration
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Registration $registration
     * @return void
     */
    public function addRegistration(\Ig\IgRuckzuckevent\Domain\Model\Registration $registration)
    {
        $this -> registrations -> attach($registration);
    }

    /**
     * Removes an registration
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Registration $registration
     * @return void
     */
    public function removeRegistration(\Ig\IgRuckzuckevent\Domain\Model\Registration $registration)
    {
        $this -> registrations -> detach($registration);
    }

    /**
     * Returns the disable
     *
     * @return bool $disable
     */
    public function getDisable()
    {
        return $this->disable;
    }

    /**
     * Sets the disable
     *
     * @param boolean $disable
     * @return void
     */
    public function setDisable($disable)
    {
        $this->disable = $disable;
    }

    /**
     * Returns the deleted
     *
     * @return bool $deleted
     */
    public function getDeleted()
    {
        return $this->deleted;
    }

    /**
     * Sets the deleted
     *
     * @param boolean $deleted
     * @return void
     */
    public function setDeleted($deleted)
    {
        $this->deleted = $deleted;
    }

    /**
     * Returns the hash
     *
     * @return bool $hash
     */
    public function getHash()
    {
        return $this->hash;
    }

    /**
     * Sets the hash
     *
     * @param boolean $hash
     * @return void
     */
    public function setHash($hash)
    {
        $this->hash = $hash;
    }

    /**
     * Returns the amount of subscriptions left
     *
     * @return integer $subscriptionTotal
     */
    public function getSubscriptionTotal()
    {
        $subscriptionTotal = 0;

        foreach ($this->subscriptions as $subscription) {
            $subscriptionTotal += $subscription->getDaysLeft();
        }

        return $subscriptionTotal;
    }

    public function getJson()
    {
        return JsonUtility::getJsonForProperties($this->_getProperties());
    }

}
