<?php
namespace Ig\IgRuckzuckevent\Domain\Model;

use Ig\IgRuckzuckevent\Utility\JsonUtility;

/***
 *
 * This file is part of the "Ruck Zuck Event" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2018 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/

/**
 * Feedback
 */
class Feedback extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{
    /**
     * feedback
     *
     * @var string
     * @TYPO3\CMS\Extbase\Annotation\Validate("NotEmpty")
     */
    protected $feedback = '';

    /**
     * Returns the feedback
     *
     * @return string $feedback
     */
    public function getFeedback()
    {
        return $this->feedback;
    }

    /**
     * Sets the feedback
     *
     * @param string $feedback
     * @return void
     */
    public function setFeedback($feedback)
    {
        $this->feedback = $feedback;
    }

    public function getJson()
    {
        return JsonUtility::getJsonForProperties($this->_getProperties());
    }
}
