<?php
namespace Ig\IgRuckzuckevent\Domain\Model;

/***
 *
 * This file is part of the "Ruck Zuck Event" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2017
 *
 ***/

/**
 * The FileReference model class extends the TYPO3 FileReference model which has no method to set the file.
 * For this reason we need to extend it and at the method so we have the possibility to set the file of the file reference.
 */
class FileReference extends \TYPO3\CMS\Extbase\Domain\Model\FileReference
{
    /**
     * Set the original file the reference is referencing
     *
     * @param \TYPO3\CMS\Core\Resource\File $file The file the reference is referencing
     */
    
    public function setFile(\TYPO3\CMS\Core\Resource\File $file)
    {
        $this -> originalFileIdentifier = (int)$file -> getUid();
    }
    
}
