<?php
namespace Ig\IgRuckzuckevent\Domain\Model;

use Ig\IgRuckzuckevent\Utility\JsonUtility;

/***
 *
 * This file is part of the "Ruck Zuck Event" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2019 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/
/**
 * FormField
 */
class FormField extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{
    /**
     * sorting
     *
     * @var integer
     */
    protected int $sorting = 0;
 
    /**
     * name
     *
     * @var string
     */
    protected $name = '';

    /**
     * title
     *
     * @var string
     */
    protected $title = '';

    /**
     * type
     *
     * @var string
     */
    protected $type = 0;

    /**
     * required
     *
     * @var bool
     */
    protected $required = false;

    /**
     * options
     *
     * @var string
     */
    protected $options = '';
    /**
     * Returns the sorting
     */
    public function getSorting(): int
    {
        return $this->sorting;
    }
 
    /**
     * Sets the sorting
     */
    public function setSorting(?int $sorting): void
    {
        $this->sorting = $sorting;
    }
    
    /**
     * description
     *
     * @var string
     */
    protected $description = '';

    /**
     * Returns the name
     *
     * @return string $name
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     *
     * @param string $name
     * @return void
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * Returns the title
     *
     * @return string $title
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Sets the title
     *
     * @param string $title
     * @return void
     */
    public function setTitle($title)
    {
        $this->title = $title;
    }

    /**
     * Returns the type
     *
     * @return string $type
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Sets the type
     *
     * @param string $type
     * @return void
     */
    public function setType($type)
    {
        $this->type = $type;
    }

    /**
     * Returns the required
     *
     * @return bool $required
     */
    public function getRequired()
    {
        return $this->required;
    }

    /**
     * Sets the required
     *
     * @param bool $required
     * @return void
     */
    public function setRequired($required)
    {
        $this->required = $required;
    }

    /**
     * Returns the boolean state of required
     *
     * @return bool
     */
    public function isRequired()
    {
        return $this->required;
    }

    /**
     * Returns the options
     *
     * @return array $options
     */
    public function getOptionsArray(): array
    {
        return explode("\n", $this->options);
    }
    public function getOptions(): string
    {
        return $this->options;
    }

    /**
     * Sets the options
     */
    public function setOptions(string $options): void
    {
        $this->options = $options;
    }
    public function setOptionsArray(array $options): void
    {
        $this->options = implode("\n", $options);
    }

    /**
     * Returns the description
     *
     * @return string $description
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Sets the description
     *
     * @param string $description
     * @return void
     */
    public function setDescription($description)
    {
        $this->description = $description;
    }

    public function getJson()
    {
        return JsonUtility::getJsonForProperties($this->_getProperties());
    }
}
