<?php

namespace Ig\IgRuckzuckevent\Domain\Model;

use Ig\IgRuckzuckevent\Utility\JsonUtility;
use Ig\IgRuckzuckevent\Utility\UserUtility;


/**
 * The Registration model represents entities of the table tx_igruckzuckevent_domain_model_registration.
 */
class Person extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{
    /**
     * The gender of the registrant
     */
    protected string $gender = '';

    /**
     * The name of the registratant
     */
    protected string $lastName = '';

    /**
     * First name of the registrant
     */
    protected string $firstName = '';

    protected string $email = '';

    /**
     * The event the registration is for
     *
     * @var \Ig\IgRuckzuckevent\Domain\Model\Registration
     */
    protected $registration = null;

    public function getGender(): string
    {
        return $this->gender;
    }

    public function setGender(string $gender): void
    {
        $this->gender = $gender;
    }

    public function getLastName(): string
    {
        return $this->lastName;
    }

    public function setLastName(string $lastName): void
    {
        $this->lastName = $lastName;
    }

    public function getFirstName(): string
    {
        return $this->firstName;
    }

    public function setFirstName(string $firstName): void
    {
        $this->firstName = $firstName;
    }


    public function getEmail(): string
    {
        return $this->email;
    }

    public function setEmail(string $email): void
    {
        $this->email = $email;
    }

    /**
     * Returns the registration
     *
     * @return \Ig\IgRuckzuckevent\Domain\Model\Registration $registration
     */
    public function getRegistration()
    {
        return $this->registration;
    }

    /**
     * Sets the registration
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Registration $registration
     * @return void
     */
    public function setRegistration(\Ig\IgRuckzuckevent\Domain\Model\Registration $registration)
    {
        $this->registration = $registration;
    }
}
