<?php
namespace Ig\IgRuckzuckevent\Domain\Model;

use Ig\IgRuckzuckevent\Utility\JsonUtility;

/***
 *
 * This file is part of the "IG Payment" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2017 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/

/**
 * Product
 */
class Subscription extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{
    /**
     * crdate
     *
     * @var int
     */
    protected $crdate;

    /**
     * daysLeft
     *
     * @var int
     */
    protected $daysLeft = 0;

    /**
     * The start date
     *
     * @var \DateTime
     */
    protected $startDate = null;

    /**
     * The expiration date
     *
     * @var \DateTime
     */
    protected $expirationDate = null;

    /**
     * subscriptionOffer
     *
     * @var \Ig\IgRuckzuckevent\Domain\Model\SubscriptionOffer
     */
    protected $subscriptionOffer = null;

    /**
     * feUser
     *
     * @var \Ig\IgRuckzuckevent\Domain\Model\FeUser
     */
    protected $feUser = null;

    /**
     * @var string
     */
    protected $paymentMethod = '';

    /**
     * @var string
     */
    protected $transactionId = '';
    /**
     * @var string
     */
    protected $transactionAmount = '';
    /**
     * @var string
     */
    protected $transactionCurrency = '';

    /**
     * Returns the crdate
     *
     * @return int $crdate
     */
    public function getCrdate()
    {
        return $this->crdate;
    }

    /**
     * Sets the crdate
     *
     * @param int $crdate
     *
     * @return void
     */
    public function setCrdate($crdate)
    {
        $this->crdate = $crdate;
    }


    /**
     * Returns the daysLeft
     *
     * @return int $daysLeft
     */
    public function getDaysLeft()
    {
        return $this->daysLeft;
    }
    public function getGuthabenOffen()
    {
        return $this->getDaysLeft();
    }

    /**
     * Sets the daysLeft
     *
     * @param int $daysLeft
     *
     * @return void
     */
    public function setDaysLeft($daysLeft)
    {
        $this->daysLeft = $daysLeft;
    }

    /**
     * Returns the startDate
     *
     * @return \DateTime $startDate
     */
    public function getStartDate()
    {
        return $this->startDate;
    }

    /**
     * Sets the startDate
     *
     * @param \DateTime $startDate
     *
     * @return void
     */
    public function setStartDate($startDate)
    {
        $this->startDate = $startDate;
    }

    /**
     * Returns the expirationDate
     *
     * @return \DateTime $expirationDate
     */
    public function getExpirationDate()
    {
        return $this->expirationDate;
    }

    /**
     * Sets the expirationDate
     *
     * @param \DateTime $expirationDate
     *
     * @return void
     */
    public function setExpirationDate($expirationDate)
    {
        $this->expirationDate = $expirationDate;
    }

    /**
     * Returns the subscriptionOffer
     *
     * @return \Ig\IgRuckzuckevent\Domain\Model\SubscriptionOffer $subscriptionOffer
     */
    public function getSubscriptionOffer()
    {
        return $this->subscriptionOffer;
    }

    /**
     * Sets the subscriptionOffer
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\SubscriptionOffer $subscriptionOffer
     *
     * @return void
     */
    public function setSubscriptionOffer(\Ig\IgRuckzuckevent\Domain\Model\SubscriptionOffer $subscriptionOffer)
    {
        $this->subscriptionOffer = $subscriptionOffer;
    }

    /**
     * Returns the feUser
     *
     * @return \Ig\IgRuckzuckevent\Domain\Model\FeUser $feUser
     */
    public function getFeUser()
    {
        return $this->feUser;
    }

    /**
     * Sets the feUser
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\FeUser $feUser
     *
     * @return void
     */
    public function setFeUser(\Ig\IgRuckzuckevent\Domain\Model\FeUser $feUser)
    {
        $this->feUser = $feUser;
    }

    /**
     * @return string $paymentMethod
     */
    public function getPaymentMethod()
    {
        return $this->paymentMethod;
    }

    /**
     * @param string $paymentMethod
     * @return void
     */
    public function setPaymentMethod($paymentMethod)
    {
        $this->paymentMethod = $paymentMethod;
    }

    /**
     * @return string $transactionId
     */
    public function getTransactionId()
    {
        return $this->transactionId;
    }

    /**
     * @param string $transactionId
     * @return void
     */
    public function setTransactionId($transactionId)
    {
        $this->transactionId = $transactionId;
    }


    /**
     * @return string $transactionAmount
     */
    public function getTransactionAmount()
    {
        return $this->transactionAmount;
    }

    /**
     * @param string $transactionAmount
     * @return void
     */
    public function setTransactionAmount($transactionAmount)
    {
        $this->transactionAmount = $transactionAmount;
    }


    /**
     * @return string $transactionCurrency
     */
    public function getTransactionCurrency()
    {
        return $this->transactionCurrency;
    }

    /**
     * @param string $transactionCurrency
     * @return void
     */
    public function setTransactionCurrency($transactionCurrency)
    {
        $this->transactionCurrency = $transactionCurrency;
    }
    public function getActive()
    {
        $now = new \DateTime();
        return $this->daysLeft>0 && $this->expirationDate>=$now;
    }

    public function getJson()
    {
        return JsonUtility::getJsonForProperties($this->_getProperties());
    }
}
