<?php
namespace Ig\IgRuckzuckevent\Domain\Model;

use Ig\IgRuckzuckevent\Utility\JsonUtility;

/***
 *
 * This file is part of the "IG Payment" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2017 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/

/**
 * Product
 */
class SubscriptionOffer extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{
    /**
     * name
     *
     * @var string
     */
    protected $name = '';

    /**
     * description
     *
     * @var string
     */
    protected $description = '';

    /**
     * price
     *
     * @var string
     */
    protected $price = '';

    /**
     * days
     *
     * @var int
     */
    protected $days = 0;

    /**
     * duration
     *
     * @var int
     */
    protected $duration = 0;

    /**
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgRuckzuckevent\Domain\Model\Subscription> $subscriptions
     * @TYPO3\CMS\Extbase\Annotation\ORM\Cascade remove
     */
    protected $subscriptions = 0;

    /**
     * Constructor
     */
    public function __construct()
    {
        //Do not remove the next line: It would break the functionality
        $this -> initStorageObjects();
    }

    /**
     * Initializes all ObjectStorage properties
     *
     * @return void
     */
    protected function initStorageObjects()
    {
        $this -> subscriptions = new \TYPO3\CMS\Extbase\Persistence\ObjectStorage();
    }

    /**
     * Returns the days
     *
     * @return int $days
     */
    public function getDays()
    {
        return $this->days;
    }
    public function getGuthabenTotal()
    {
        return $this->days;
    }

    /**
     * Sets the days
     *
     * @param int $days
     *
     * @return void
     */
    public function setDays($days)
    {
        $this->days = $days;
    }

    /**
     * Returns the duration
     *
     * @return int $duration
     */
    public function getDuration()
    {
        return $this->duration;
    }

    /**
     * Sets the duration
     *
     * @param int $duration
     *
     * @return void
     */
    public function setDuration($duration)
    {
        $this->duration = $duration;
    }

    /**
     * Returns the subscriptions
     *
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgRuckzuckevent\Domain\Model\Subscription> $subscriptions
     */
    public function getSubscriptions()
    {
        return $this->subscriptions;
    }

    /**
     * Sets the subscriptions
     *
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Ig\IgRuckzuckevent\Domain\Model\Subscription> $subscriptions
     *
     * @return void
     */
    public function setSubscriptions(\TYPO3\CMS\Extbase\Persistence\ObjectStorage $subscriptions)
    {
        $this->subscriptions = $subscriptions;
    }

    /**
     * Adds an subscription
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Subscription $image
     * @return void
     */
    public function addSubscription(\Ig\IgRuckzuckevent\Domain\Model\Subscription $subscription)
    {
        $this -> subscriptions -> attach($subscription);
    }

    /**
     * Removes an subscription
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Subscription $subscription
     * @return void
     */
    public function removeSubscription(\Ig\IgRuckzuckevent\Domain\Model\Subscription $subscription)
    {
        $this -> subscriptions -> detach($subscription);
    }

    /**
     * Returns the name
     *
     * @return string $name
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     *
     * @param string $name
     * @return void
     */
    public function setName($name)
    {
        $this->name = $name;
    }

    /**
     * Returns the description
     *
     * @return string $description
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Sets the description
     *
     * @param string $description
     * @return void
     */
    public function setDescription($description)
    {
        $this->description = $description;
    }

    /**
     * Returns the price
     *
     * @return string $price
     */
    public function getPrice()
    {
        return $this->price;
    }

    /**
     * Sets the price
     *
     * @param string $price
     * @return void
     */
    public function setPrice($price)
    {
        $this->price = $price;
    }

    public function getJson()
    {
        return JsonUtility::getJsonForProperties($this->_getProperties());
    }
}
