<?php
namespace Ig\IgRuckzuckevent\Domain\Repository;

use Ig\IgRuckzuckevent\Utility\UserUtility;

/**
 * The repository for Events
 */
class EventRepository extends \TYPO3\CMS\Extbase\Persistence\Repository
{
    /**
     * @var array
     */
    protected $defaultOrderings = [
        'dateFrom' => \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_ASCENDING
    ];

    /**
     * @var bool
     */
    protected $showOnlyActiveEntries = true;

    public function setShowOnlyActiveEntries($showOnlyActiveEntries)
    {
        $this->showOnlyActiveEntries = $showOnlyActiveEntries;
    }
    public function getShowOnlyActiveEntries()
    {
        return $this->showOnlyActiveEntries;
    }

    public function setStoragePid($pid)
    {
        $querySettings = $this->createQuery()->getQuerySettings();

        $querySettings->setStoragePageIds([$pid]);

        $this->setDefaultQuerySettings($querySettings);
    }

    /**
     * return events with given search
     */
    public function findBySearchAndSorting(array $search = [], array $sorting = ['dateFrom' => 'ASC', 'timeFrom' => 'ASC'], int $limit = 0)
    {
        $query = $this->createQuery();
        $constraints = [];


        $ignoreToday = $search['ignoreToday'] ?? false;
        $withoutDate = $search['withoutDate'] ?? false;
        
        if (!$ignoreToday && !$withoutDate) {
            // For default, only get the events that are oncoming
            $dateTime = new \DateTime();
            $constraints[] = $query->greaterThanOrEqual('dateFrom', $dateTime->format('Y-m-d'));
        }
        
        if ($ignoreToday && !$withoutDate) {
            $dateTime = new \DateTime();
            $constraints[] = $query->lessThan('dateFrom', $dateTime->format('Y-m-dT00:00:00'));
            $constraints[] = $query->logicalNot($query->equals('dateFrom', null));
            //$constraints[] = $query->logicalNot($query->equals('dateFrom', ''));
        }
        if ($withoutDate) {
            $constraints[] = $query->equals('dateFrom', null);
        }


        // Handle search if not empty
        // Search by the date from entered in the search form
        if ($search['dateFrom'] ?? false) {
            $dateFrom = null;
            if(is_array($search['dateFrom']) && isset($search['dateFrom']['date']) && $search['dateFrom']['date'] != '') {
                $dateFrom = new \DateTime($search['dateFrom']['date']);
            } else if(!is_array($search['dateFrom']) && $search['dateFrom'] != '') {
                $dateFrom = new \DateTime($search['dateFrom']);
            }
            if($dateFrom) {
                $constraints[] = $query->greaterThanOrEqual('dateFrom', $dateFrom->format('Y-m-d'));
            }
            //$constraints[] = $query->greaterThanOrEqual('dateFrom', $dateFrom->format('Y-m-dT00:00:00'));//TODO Datetime
        }
    /*
        else if (!$ignoreToday && !$withoutDate) {
            // For default, only get upcoming events
            $dateTime = new \DateTime();
            $constraints[] = $query->greaterThanOrEqual('dateFrom', $dateTime->format('Y-m-d'));
        }
    */
            // Search by the date to entered in the search form
        if ($search['dateTo'] ?? false) {
            $dateTo = null;
            if (is_array($search['dateTo']) && isset($search['dateTo']['date']) && $search['dateTo']['date'] != '') {
                $dateTo = new \DateTime($search['dateTo']['date']);
            } else if (!is_array($search['dateTo']) && $search['dateTo'] != '') {
                $dateTo = new \DateTime($search['dateTo']);
            }
            if($dateTo) {
                $constraints[] = $query->lessThanOrEqual('dateFrom', $dateTo->format('Y-m-d'));
            }
            //$constraints[] = $query->lessThanOrEqual('dateFrom', $dateTo->format('Y-m-dT00:00:00'));//TODO Datetime
        }
        if ($search['eventgroup'] ?? false) {
            $constraints[] = $query->equals('eventgroup', $search['eventgroup']);
        }
        // Search by searchword entered in the search form
        if ($search['searchword'] ?? false) {
            $constraints[] = $query->logicalOr(
                $query->like('title', '%' . $search['searchword'] . '%'),
                $query->like('subtitle', '%' . $search['searchword'] . '%'),
                $query->like('description', '%' . $search['searchword'] . '%'),
                $query->like('targetgroup', '%' . $search['searchword'] . '%'),
                $query->like('targets', '%' . $search['searchword'] . '%'),
                $query->like('contents', '%' . $search['searchword'] . '%'),
                $query->like('workingmethods', '%' . $search['searchword'] . '%'),
                $query->like('course_organizer', '%' . $search['searchword'] . '%'),
                $query->like('datetimelabel', '%' . $search['searchword'] . '%'),
                $query->like('duration', '%' . $search['searchword'] . '%'),
                $query->like('place', '%' . $search['searchword'] . '%'),
                $query->like('costs', '%' . $search['searchword'] . '%'),
                $query->like('note', '%' . $search['searchword'] . '%'),
                $query->like('competences', '%' . $search['searchword'] . '%'),
                $query->like('cours_no', '%' . $search['searchword'] . '%'),
                $query->like('teaser', '%' . $search['searchword'] . '%'),
                $query->like('description', '%' . $search['searchword'] . '%'),
                $query->like('categories.name', '%' . $search['searchword'] . '%'),
                $query->like('qualifications.name', '%' . $search['searchword'] . '%'),
            );
        }
        if ($search['qualification'] ?? false) {
            $constraints[] = $query->contains('qualifications', $search['qualification']);
        }
        if ($search['tag'] ?? false) {
            $constraints[] = $query->equals($search['tag'], 1);
        }
        // Search by diplomiert
        if ($search['diplomiert'] ?? false) {
            $constraints[] = $query->equals('diplomiert', 1);
        }
        // Search by hebamme
        if ($search['hebamme'] ?? false) {
            $constraints[] = $query->equals('hebamme', 1);
        }
        // Search by dni
        if ($search['dni'] ?? false) {
            $constraints[] = $query->equals('dni', 1);
        }
        // Search by fage
        if ($search['fage'] ?? false) {
            $constraints[] = $query->equals('fage', 1);
        }
        // Search by fabe
        if ($search['fabe'] ?? false) {
            $constraints[] = $query->equals('fabe', 1);
        }
        // Search by ags
        if ($search['ags'] ?? false) {
            $constraints[] = $query->equals('ags', 1);
        }
        // Search by assistent
        if ($search['assistent'] ?? false) {
            $constraints[] = $query->equals('assistent', 1);
        }
        // Search by otherJobMed
        if ($search['otherJobMed'] ?? false) {
            $constraints[] = $query->equals('otherJobMed', 1);
        }
            // Search by otherJob
        if ($search['otherJob'] ?? false) {
            $constraints[] = $query->equals('otherJob', 1);
        }
        // Search by category
        if ($search['category'] ?? false) {
            $constraints[] = $query->contains('categories', $search['category']);
        }




        if($this->showOnlyActiveEntries) {
            $constraints[] = $query->equals('active', true);
        }

        if (!empty($constraints)) {
            $query->matching($query->logicalAnd(...$constraints));
        }
        $query->setOrderings($sorting);

        if ($limit > 0) {
            $query->setLimit($limit);
        }

        return $query->execute();
    }

    /*
     * Function for Physio Team
     */
    public function findCurrentEvent(\Ig\IgRuckzuckevent\Domain\Model\Eventgroup $eventgroup)
    {
        $query = $this->createQuery();

        if (UserUtility::isAdminLoggedIn()) {
            $inOneHour = new \DateTime();
            $inOneHour->modify('-2 month');
        } else {
            $inOneHour = new \DateTime();
            $inOneHour->modify('+1 hour');
        }
        $inTwoMonths = new \DateTime();
        $inTwoMonths->modify('+2 month');

        $constraints = [];
        $constraints[] = $query->equals('eventgroup', $eventgroup);
        if($this->showOnlyActiveEntries) {
            $constraints[] = $query->equals('active', true);
        }

        $constraints[] = $query->logicalAnd(
            $query->lessThanOrEqual('dateFrom', $inTwoMonths->format('Y-m-d')),
            $query->logicalOr(
                                $query->greaterThan('dateFrom', $inOneHour->format('Y-m-d')),
                                $query->logicalAnd(
                                    $query->equals('dateFrom', $inOneHour->format('Y-m-d')),
                                    $query->greaterThanOrEqual('timeFrom', ($inOneHour->getTimestamp() % 86400))
                                )
                            )
        );

        $query->matching($query->logicalAnd(...$constraints));
        /*
        if(  $eventgroup->getUid()==18) {
          $q=$query->execute();
          echo('Resultate=='.count($q));
          $f=$q->getFirst();
          echo('a='.count($q));
          exit(0);
        }
        */
        return $query->execute()->getFirst();
    }


    public function findForShow(\Ig\IgRuckzuckevent\Domain\Model\Event $event)
    {
        $query = $this->createQuery();


        if (UserUtility::isAdminLoggedIn()) {
            $inOneHour = new \DateTime();
            $inOneHour->modify('-2 month');
        } else {
            $inOneHour = new \DateTime();
            $inOneHour->modify('+1 hour');
        }
        $inTwoMonths = new \DateTime();
        $inTwoMonths->modify('+2 month');

        $constraints = [];
        $constraints[] = $query->equals('title', $event->getTitle());
        //$constraints[] = $query->equals('subtitle', $event->getSubtitle());
        $constraints[] = $query->logicalAnd(
            $query->lessThanOrEqual('dateFrom', $inTwoMonths->format('Y-m-d')),
            $query->logicalOr(
                                $query->greaterThan('dateFrom', $inOneHour->format('Y-m-d')),
                                $query->logicalAnd(
                                    $query->equals('dateFrom', $inOneHour->format('Y-m-d')),
                                    $query->greaterThanOrEqual('timeFrom', ($inOneHour->getTimestamp() % 86400))
                                )
                            )
        );

        $query->matching($query->logicalAnd(...$constraints));

        return $query->execute();
    }


    public function findForReminder()
    {
        $query = $this->createQuery();

        $tomorrow = new \DateTime();
        $tomorrow->modify('+1 day');

        $query->matching($query->lessThanOrEqual('dateFrom', $tomorrow->format('Y-m-d')));

        return $query->execute();
    }

    public function findPassedByTitle($title)
    {
        $query = $this->createQuery();

        $today = new \DateTime();
        $aYearAgo = clone $today;
        $aYearAgo->modify('-1 year');

        $constraints = [];

        $constraints[] = $query->like('title', '%' . $title . '%');
        $constraints[] = $query->greaterThanOrEqual('dateFrom', $aYearAgo->format('Y-m-d'));
        $constraints[] = $query->lessThanOrEqual('dateFrom', $today->format('Y-m-d'));

        $query->matching($query->logicalAnd(...$constraints));

        return $query->execute();
    }




    public function countEventInNextYear(\Ig\IgRuckzuckevent\Domain\Model\Eventgroup $eventgroup)
    {
        $now = new \DateTime();
        $nowPlusYear = new \DateTime();
        $nowPlusYear->modify('+1 year');

        $query = $this->createQuery();

        $query->matching(
          $query->logicalAnd(
                   $query->equals('eventgroup', $eventgroup),
                   $query->greaterThanOrEqual('dateFrom', $now->format('Y-m-d')),
                   $query->lessThanOrEqual('dateFrom', $nowPlusYear->format('Y-m-d'))
               )
      );


        return $query->count();
    }
    public function findEventInNextYear(\Ig\IgRuckzuckevent\Domain\Model\Eventgroup $eventgroup)
    {
        $now = new \DateTime();
        $nowPlusYear = new \DateTime();
        $nowPlusYear->modify('+1 year');

        $query = $this->createQuery();

        $query->matching(
          $query->logicalAnd(
                   $query->equals('eventgroup', $eventgroup),
                   $query->greaterThanOrEqual('dateFrom', $now->format('Y-m-d')),
                   $query->lessThanOrEqual('dateFrom', $nowPlusYear->format('Y-m-d'))
               )
      );


        return $query->execute();
    }
}
