<?php
namespace Ig\IgRuckzuckevent\Domain\Repository;

use Doctrine\DBAL\ParameterType;
use Ig\IgRuckzuckevent\Domain\Model\Person;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\Mapper\DataMapper;

/**
 * The repository for Registrations
 */
class RegistrationRepository extends \TYPO3\CMS\Extbase\Persistence\Repository
{
    /**
     * @var array
     */
    protected $defaultOrderings = [
        'crdate' => \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_DESCENDING
    ];

    public function initializeObject()
    {
        $querySettings = $this->createQuery()->getQuerySettings();

        //$querySettings->setLanguageUid(0);
        $querySettings->setRespectSysLanguage(false);
        $querySettings->setRespectStoragePage(false);

        $this->setDefaultQuerySettings($querySettings);
    }

    public function getTableName(): string
    {
        $dataMapper = GeneralUtility::makeInstance(DataMapper::class);
        return $dataMapper->getDataMap($this->objectType)->getTableName();
    }
    public function getTableNamePerson(): string
    {
        $dataMapper = GeneralUtility::makeInstance(DataMapper::class);
        return $dataMapper->getDataMap(Person::class)->getTableName();
    }
    
    public function setStoragePid($pid)
    {
        $querySettings = $this->createQuery()->getQuerySettings();

        $querySettings->setStoragePageIds([$pid]);

        $this->setDefaultQuerySettings($querySettings);
    }

    public function findByEventAndFilter($event, array $filter = [])
    {
        $query = $this->createQuery();

        $constraints = [];
        $constraints[] = $query->equals('event', $event);

        if ($filter['searchword'] ?? null) {
            $constraints[] = $query->logicalOr(
                $query->like('name', '%' . $filter['searchword'] . '%'),
                $query->like('firstName', '%' . $filter['searchword'] . '%'),
                $query->like('street', '%' . $filter['searchword'] . '%'),
                $query->like('zip', '%' . $filter['searchword'] . '%'),
                $query->like('city', '%' . $filter['searchword'] . '%'),
                $query->like('email', '%' . $filter['searchword'] . '%')
            );
        }

        $query->matching($query->logicalAnd(...$constraints));

        return $query->execute();
    }

    public function countRegistrationsByEvent($eventId)
    {
        $tablenameRegistration = $this->getTableName();
        $tablenamePerson = $this->getTableNamePerson();
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)
                      ->getQueryBuilderForTable($tablenameRegistration);

        $subQuery = $queryBuilder->getConnection()->createQueryBuilder();
        $subQuery
            ->addSelectLiteral('COUNT(1)')
            ->from($tablenamePerson)
            ->where(
                $subQuery->expr()->eq('registration', 'r.uid'),
                //$subQuery->expr()->eq('deleted', 0)
            );

        $queryBuilder
            //->select('r.event')
            ->addSelectLiteral('SUM((1 + (' . $subQuery->getSQL() . ')) * used_spaces) AS total')
            ->from($tablenameRegistration, 'r')
            ->where(
                $queryBuilder->expr()->eq('r.event', $queryBuilder->createNamedParameter($eventId, ParameterType::INTEGER)),
                //$queryBuilder->expr()->eq('r.deleted', 0)
            )
            ->groupBy('r.event');

        $result = $queryBuilder->executeQuery()->fetchAssociative();

        return (int)($result['total'] ?? 0);
    }

    /*
     * Funktionen fuer Physio Team
     */

    public function findNextRegistrations($user)
    {
        $query = $this->createQuery();

        $today = new \DateTime();
        $constraints = [];

        $constraints[] = $query->equals('feUser', $user);
        $constraints[] = $query->greaterThanOrEqual('event.dateFrom', $today->format('Y-m-d'));

        $query->matching($query->logicalAnd(...$constraints));
        $query->setLimit(3);
        $query->setOrderings(array('event.dateFrom' => 'ASC', 'event.timeFrom' => 'ASC'));

        return $query->execute();
    }


    public function findPassedRegistrations($user)
    {
        $query = $this->createQuery();

        $today = new \DateTime();
        $aYearAgo = clone $today;
        $aYearAgo->modify('-1 year');

        $constraints = [];

        $constraints[] = $query->equals('feUser', $user);
        $constraints[] = $query->greaterThanOrEqual('event.dateFrom', $aYearAgo->format('Y-m-d'));
        $constraints[] = $query->lessThanOrEqual('event.dateFrom', $today->format('Y-m-d'));

        $query->matching($query->logicalAnd(...$constraints));
        $query->setLimit(3);
        $query->setOrderings(array('event.dateFrom' => 'ASC', 'event.timeFrom' => 'ASC'));

        return $query->execute();
    }
}
