<?php
namespace Ig\IgRuckzuckevent\Domain\Repository;

use TYPO3\CMS\Extbase\Utility\DebuggerUtility;

/***
 *
 * This file is part of the "Ruck Zuck Event" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2017 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/

/**
 * The repository for Subscriptions
 */
class SubscriptionRepository extends \TYPO3\CMS\Extbase\Persistence\Repository
{
    protected $defaultOrderings = array(
                      'crdate' => \TYPO3\CMS\Extbase\Persistence\QueryInterface::ORDER_DESCENDING
                      );

  

    /**
       * Finds the active subscriptions of a user
       *
       * @param \Ig\IgRuckzuckevent\Domain\Model\FeUser $user
       * @return QueryResult $subscriptions
       */
    public function findActiveSubscriptions($user)
    {
        $query = $this->createQuery();
        $query->getQuerySettings()->setRespectStoragePage(false);
        
        $today = new \DateTime();
        $constraints = [];
        
        $constraints[] = $query->equals('feUser', $user);
        $constraints[] = $query->greaterThan('daysLeft', 0);
        $constraints[] = $query->greaterThanOrEqual('expirationDate', $today->format('Y-m-d'));
        $constraints[] = $query->lessThanOrEqual('startDate', $today->format('Y-m-d'));
        
        $query->matching($query->logicalAnd(...$constraints));
        
        $query->setOrderings(array('expirationDate' => 'ASC'));
        
        return $query->execute();
    }
}
