<?php
namespace Ig\IgRuckzuckevent\Domain\Validator;

/***
 *
 * This file is part of the "Ruck Zuck Event" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2017 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/

 /**
  * The RegistrationFormValidator validates the input of the registration form of an event and throws errors if imputs are wrong.
  * The actual error messages in german are stored in the Resources/Private/Language/locallang.xlf-File.
  * We are outputting them in fluid by property path and error code.
  */
class RegistrationFormValidator extends \TYPO3\CMS\Extbase\Validation\Validator\AbstractValidator
{
    /**
     * Checks if the registration is valid
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Registration $registration
     * @return void
     */
    public function isValid($registration): void
    {
        $event = $registration -> getEvent();
        // If no registrations are possible, the deadline is reached or the event is booked up throw a specific error error
        if (!$event -> getRegistrationsPossible()) {
            $this -> addError('There are no registrations possible for this event', 1491210089);
        } elseif ($event -> getDeadlineReached()) {
            $this -> addError('The deadline for registrations has already been passed', 1491210238);
        } elseif ($event -> getState() == 'bookedUp') {
            $this -> addError('This event is booked up', 1491210338);
        }

        // Check the form fields because the default validator does not work
        /*if ($registration -> getGender() == '') {
            $this -> addError('No gender set', 1491210090);
        }
        if ($registration -> getName() == '') {
            $this -> addError('No name entered', 1491210091);
        }
        if ($registration -> getFirstName() == '') {
            $this -> addError('No first name entered', 1491210092);
        }
        if ($registration -> getEmail() == '') {
            $this -> addError('No email entered', 1491210094);
        } elseif (!\TYPO3\CMS\Core\Utility\GeneralUtility::validEmail($registration -> getEmail())) {
            $this -> addError('Email entered is wrong', 1491210093);
        }*/
    }
}
