<?php
namespace Ig\IgRuckzuckevent\Domain\Validator;

use TYPO3\CMS\Core\Utility\GeneralUtility;

/***
 *
 * This file is part of the "Ruck Zuck Event" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2017 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/

 /**
  *
  */
class SubscriptionCountValidator extends \TYPO3\CMS\Extbase\Validation\Validator\AbstractValidator
{
    /**
     * Checks if enought subscriptions
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Subscription $subscription
     * @return void
     */
    public function isValid($subscription): void
    {
        $dates = GeneralUtility::_POST('tx_igruckzuckevent_events')['dates'];
        
        if (!$dates) {
            $dates = GeneralUtility::_POST('tx_igruckzuckevent_management')['dates'];
        }

        if (!$dates) {
            $dates = GeneralUtility::_POST('tx_igruckzuckevent_eventscalendar')['dates'];
        }

        if(!$dates) {
            $this->addError('No date chosen', 1496759333);
        }

        if ($subscription == null) {
            $this->addError('No subscription chosen', 1496759123);
        }
        
        if ($dates && count($dates) > $subscription->getDaysLeft()) {
            $this->addError('Too many dates chosen', 1496759216);
        }
    }
}
