<?php
namespace Ig\IgRuckzuckevent\Domain\Validator;

use TYPO3\CMS\Extbase\Utility\DebuggerUtility;

/***
 *
 * This file is part of the "Ruck Zuck Event" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2017 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/

 /**
  * The EventFormValidator validates the input of the forms for creating and editing events and throws errors if inputs are wrong.
  * The actual error messages in german are stored in the Resources/Private/Language/locallang.xlf-File.
  * We are outputting them in fluid by property path and error code.
  */
class UserExistsValidator extends \TYPO3\CMS\Extbase\Validation\Validator\AbstractValidator
{
    /**
     * feUserRepository
     *
     * @var \Ig\IgRuckzuckevent\Domain\Repository\FeUserRepository
     */
    protected $feUserRepository = null;

    /**
     * @param \Ig\IgRuckzuckevent\Domain\Repository\FeUserRepository $feUserRepository
     */
    public function injectFeUserRepository(\Ig\IgRuckzuckevent\Domain\Repository\FeUserRepository $feUserRepository)
    {
        $this->feUserRepository = $feUserRepository;
    }

    /**
     * Checks if the event is valid
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\FeUser $user
     * @return void
     */
    public function isValid($user): void
    {
        $usersWithSameUsername = $this->feUserRepository->findByUsername($user->getEmail());

        if ($usersWithSameUsername->count() > 0) {
            $this -> addError('Username already taken', 1491210145);
        }
    }

}
