<?php

namespace Ig\IgRuckzuckevent\Event;

use Psr\EventDispatcher\StoppableEventInterface;
use Ig\IgRuckzuckevent\Domain\Model\Registration;
use TYPO3\CMS\Extbase\Mvc\RequestInterface;

final class RegistrationEvent implements StoppableEventInterface {

    private $registration;
    private RequestInterface $request;
    private array $data = [];
    private array $default;
 
    public function __construct(Registration $registration, RequestInterface $request, array $default = [])
    {
        $this->registration = $registration;
        $this->request = $request;
        $this->default = $default;
    }
 
    public function getData(): array
    {
        return $this->data;
    }
 
    public function getRegistration(): Registration
    {
        return $this->registration;
    }

    public function getRequest(): RequestInterface
    {
        return $this->request;
    }
 
    public function setData(array $data): void
    {
        $this->data = $data;
    }
    public function isPropagationStopped(): bool
    {
        return false;
	// return !empty($this->data);
    }
    

    public function getDefault(): array
    {
        return $this->default;
    }

    public function setDefault($default)
    {
        $this->default = $default;
    }
}