<?php
namespace Ig\IgRuckzuckevent\Form\Element;

use DateTime;
use Ig\IgRuckzuckevent\Domain\Model\Event;
use Ig\IgRuckzuckevent\Domain\Model\Eventgroup;
use Ig\IgRuckzuckevent\Domain\Model\FormField;
use Ig\IgRuckzuckevent\Domain\Model\Registration;
use TYPO3\CMS\Backend\Form\Element\SelectSingleElement;
use TYPO3\CMS\Backend\Form\Element\TextElement;
use TYPO3\CMS\Core\Database\Connection;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Imaging\Icon;
use TYPO3\CMS\Core\Imaging\IconFactory;
use TYPO3\CMS\Core\Page\JavaScriptModuleInstruction;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Utility\MathUtility;
use TYPO3\CMS\Core\Utility\StringUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\Mapper\DataMapper;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;

use TYPO3\CMS\Extbase\Utility\DebuggerUtility;

class AdditionalFieldsFormElement extends TextElement
{
    protected string $baseFormName = 'data[tx_igruckzuckevent_domain_model_registration]';
    protected string $tablename = 'tx_igruckzuckevent_domain_model_registration';
    protected string $attributePrefix = 'recurrence_';
    protected $fields = [
        'update_scope' => [
            'label' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_db.xlf:tx_igruckzuckevent_domain_model_event.recurrence_behaviour',
            'config' => [
                'items' => [
                    [
                        'label' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_db.xlf:tx_igruckzuckevent_domain_model_event.recurrence.scope.all',
                        'value' => 'all'
                    ],
                    /*
                      [
                      'label' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_db.xlf:tx_igruckzuckevent_domain_model_event.recurrence.scope.future',
                      'value' => 'future'
                      ],
                    */
                    [
                        'label' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_db.xlf:tx_igruckzuckevent_domain_model_event.recurrence.scope.this',
                        'value' => 'this'
                    ],
                ],            
            ],            
        ],
    ];
    
    protected function renderTextLabel(string $label, string $for): string
    {
        return '<label for="' . htmlspecialchars($for) . '" class="form-label t3js-formengine-label">' . $label . '</label>';

    }

    
    public function render(): array
    {
        $this->baseFormName .= '[' . $this->data['databaseRow']['uid'] . '][additional_fields]';
        $resultArray = parent::render();
        $row = $this->data['databaseRow'];
        //$registrationUid = (int)($row['uid'][0] ?? 0);
        //$registration = $this->getRegistrationByUid($registrationUid);
        $additionalFieldValuesStr = $row['additional_fields'];
        $additionalFieldValuesArray = [];

        if(is_array($additionalFieldValuesStr)) {
            $additionalFieldValuesArray = $additionalFieldValuesStr;
        } else if($additionalFieldValuesStr != '') {
            $additionalFieldValuesArray = unserialize($additionalFieldValuesStr);
        }
        $eventUid = (int)($row['event'][0] ?? 0);
        $formFields = $this->getFormFieldsForEvent($eventUid);
        $fieldsAndValues = [];
        foreach($formFields as $formField) {
            $fieldsAndValues[$formField->getUid()] = [
                'field' => $formField,
                'value' => $formField->getType() == 'Checkbox' ? [] : ''
            ];
            foreach($additionalFieldValuesArray as $identifier => $additionalFieldValue) {
                if($identifier == 'additional-' . $formField->getUid()) {
                    if($formField->getType() == 'Checkbox' && !is_array($additionalFieldValue)) {
                        $fieldsAndValues[$formField->getUid()]['value'][] = $additionalFieldValue;
                    } else if($formField->getType() != 'Checkbox' && is_array($additionalFieldValue)) {
                        $fieldsAndValues[$formField->getUid()]['value'] = implode("\n", $additionalFieldValue);
                    } else {
                        $fieldsAndValues[$formField->getUid()]['value'] = $additionalFieldValue;
                    }
                }
            }
        }
        
        $resultArray = $this->initializeResultArray();
        $fieldInformationResult = $this->renderFieldInformation();
        $resultArray = $this->mergeChildReturnIntoExistingResult($resultArray, $fieldInformationResult, false);

        $fieldId = StringUtility::getUniqueId('formengine-additionalFields-');
        $renderedLabel = $this->renderLabel($fieldId);
        $html = [];
        $html[] = $renderedLabel;
        $html[] = '<br>';
        foreach($fieldsAndValues as $fieldAndValue) {
            $formField = $fieldAndValue['field'];
            $value = $fieldAndValue['value'];
            $html[] = $this->renderFormField($formField, $value); // FormField for: tx_igruckzuckevent_domain_model_registration[additional_fields][additional-XX]
        }

        $resultArray['html'] = implode(LF, $html) . $resultArray['html'];
        return $resultArray;
    }

    protected function renderFormField(FormField $formField, $value)
    {
        switch($formField->getType()) {
            case 'Input':
                return $this->getFieldTextfield($formField, $value);
            case 'Textarea':
                return $this->getFieldTextarea($formField, $value);
            case 'Date':
            case 'Birthdate':
                return $this->getFieldTextfield($formField, $value);
            case 'Radio':
                return $this->getFieldRadio($formField, $value);
            case 'RadioBoolean':
                return $this->getFieldRadio($formField, $value, true);
            case 'Checkbox':
                return $this->getFieldCheckbox($formField, $value);
            case 'Dropdown':
                return $this->getFieldSelect($formField, $value);
            default:
                return $this->getFieldTextfield($formField, $value);
        }
        return '';
    }

    // simple text field
    protected function getFieldTextfield(FormField $formField, $value): string
    {
        $html = [];
        $fieldId = StringUtility::getUniqueId('formengine-input-');
        $width = $this->formMaxWidth(100);
        $html[] = $this->renderTextLabel($formField->getTitle(), $fieldId);
        $html[] = '<div class="formengine-field-item t3js-formengine-field-item">
  <div class="form-wizards-wrap">
    <div class="form-wizards-element">
      <div class="form-control-wrap" style="max-width: ' . $width . 'px">
                <input type="text" class="form-control" name="' . $this->baseFormName . '[additional-' . $formField->getUid() . ']" value="' . htmlspecialchars($value ?? '') . '" /> ' . ($infoText ?? '');
        $html[] = '</div>
    </div>
  </div>
</div>';
        return implode(LF, $html);
    }

    // simple text field
    protected function getFieldTextarea($formField, $value): string
    {
        $html = [];
        $fieldId = StringUtility::getUniqueId('formengine-text-');
        $width = $this->formMaxWidth(100);
        $html[] = $this->renderTextLabel($formField->getTitle(), $fieldId);
        $html[] = '<div class="formengine-field-item t3js-formengine-field-item">
  <div class="form-wizards-wrap">
    <div class="form-wizards-element">
      <div class="form-control-wrap" style="max-width: ' . $width . 'px">
                <textarea class="form-control" name="' . $this->baseFormName . '[additional-' . $formField->getUid() . ']">' . htmlspecialchars($value ?? '') . '</textarea>' . ($infoText ?? '');
        $html[] = '</div>
    </div>
  </div>
</div>';
        return implode(LF, $html);
    }

    // simple text field
    protected function getFieldSelect(FormField $formField, $value): string
    {
        $html = [];
        $fieldId = StringUtility::getUniqueId('formengine-select-');
        $width = $this->formMaxWidth(100);
        $html[] = $this->renderTextLabel($formField->getTitle(), $fieldId);
        $html[] = '<div class="formengine-field-item t3js-formengine-field-item">
  <div class="form-wizards-wrap">
    <div class="form-wizards-element">
      <div class="form-control-wrap">
                <select class="form-select form-control-adapt" name="' . $this->baseFormName . '[additional-' . $formField->getUid() . ']">
                    <option value=""></option>';
        foreach ($formField->getOptionsArray() as $key => $option) {
            $html[] = '<option value="' . $key . '"' . ($value == $key ? 'selected="selected"' : '') . '>' . htmlspecialchars($option) . '</option>';
        }
        $html[] = '</select>
      </div>
    </div>
  </div>
</div>';

        return implode(LF, $html);
    }

    // simple text field
    protected function getFieldCheckbox(FormField $formField, $value): string
    {
        $html = [];
        $html[] = '<div class="formengine-field-item t3js-formengine-field-item">';
        $html[] =   '<div class="form-wizards-wrap">';
        $html[] =       '<div class="form-wizards-element">';
        $fieldId = StringUtility::getUniqueId('formengine-check-');
        $html[] = $this->renderTextLabel($formField->getTitle(), $fieldId);
        $iconFactory = GeneralUtility::makeInstance(IconFactory::class);
        $iconChecked = $iconFactory->getIcon('actions-check', Icon::SIZE_SMALL)->render('inline');
        $iconUnchecked = $iconFactory->getIcon('empty-empty', Icon::SIZE_SMALL)->render('inline');
        foreach($formField->getOptionsArray() as $key => $option) {
            $checked = false;
            foreach($value as $v) {
                if($key == $v) {
                    $checked = true;
                }
            }

            $uniqueId = StringUtility::getUniqueId('_');
            $checkboxId = $key . $uniqueId;
            $html[] = '
            <div class="form-check form-check-type-icon-toggle">
                <input type="checkbox"
                    class="form-check-input"
                    value="' . $key . '"
                    name="' . $this->baseFormName . '[additional-' . $formField->getUid() . '][' . $key . ']"
                    id="' . $checkboxId . '"
                    ' . ($checked ? 'checked="checked" ' : '') . '/>
                <label class="form-check-label" for="' . $checkboxId . '">
                    <span class="form-check-label-icon">
                        <span class="form-check-label-icon-checked">' . $iconChecked . '</span>
                        <span class="form-check-label-icon-unchecked">' . $iconUnchecked . '</span>
                    </span>
                    ' . $option . '
                </label>
            </div>';
        }
        $html[] =      '</div>';
        $html[] =   '</div>';
        $html[] = '</div>';

        return implode(LF, $html);
    }

    protected function getFieldRadio(FormField $formField, $value, $boolean = false): string
    {
        $html = [];
        $html[] = '<div class="formengine-field-item t3js-formengine-field-item">';
        $html[] =   '<div class="form-wizards-wrap">';
        $html[] =       '<div class="form-wizards-element">';
        $fieldId = StringUtility::getUniqueId('formengine-radio-');
        $html[] = $this->renderTextLabel($formField->getTitle(), $fieldId);
        $iconFactory = GeneralUtility::makeInstance(IconFactory::class);
        $iconChecked = $iconFactory->getIcon('actions-check', Icon::SIZE_SMALL)->render('inline');
        $iconUnchecked = $iconFactory->getIcon('empty-empty', Icon::SIZE_SMALL)->render('inline');

        foreach ($formField->getOptionsArray() as $key => $option) {
            $optionValue = $key;
            $checked = false;
            if($boolean) {
                $optionValue = 1;
                if($value == $optionValue) {
                    $checked = true;
                }
            } else if ($key == $value) {
                $checked = true;
            }
            $uniqueId = StringUtility::getUniqueId('_');
            $checkboxId = $key . $uniqueId;
            $html[] = '
            <div class="form-check form-check-type-icon-toggle form-radio-inline">
                <input type="' . ($boolean ? 'checkbox' : 'radio') . '"
                    class="form-check-input"
                    value="' . $optionValue . '"
                    name="' . $this->baseFormName . '[additional-' . $formField->getUid() . ']"
                    id="' . $checkboxId . '"
                    ' . ($checked ? 'checked="checked" ' : '') . '/>
                <label class="form-check-label" for="' . $checkboxId . '">
                    <span class="form-check-label-icon">
                        <span class="form-check-label-icon-checked">' . $iconChecked . '</span>
                        <span class="form-check-label-icon-unchecked">' . $iconUnchecked . '</span>
                    </span>
                    ' . $option . '
                </label>
            </div>';
        }
        $html[] =      '</div>';
        $html[] =   '</div>';
        $html[] = '</div>';

        return implode(LF, $html);
    }

    protected function getRegistrationByUid(int $uid)
    {
        $registrationArray = $this->getRegistrationByUidRaw($uid);
        if ($registrationArray !== false && is_array($registrationArray) && !empty($registrationArray)) {
            $dataMapper = GeneralUtility::makeInstance(DataMapper::class);
            $registrations = $dataMapper->map(Registration::class, [$registrationArray]);
            $registration = $registrations[0];            
        } else {
            $registration = GeneralUtility::makeInstance(Registration::class);
        }
        return $registration;
    }

    
    protected function getRegistrationByUidRaw(int $uid)
    {
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable($this->tablename);
        return $queryBuilder
            ->select('*')
            ->from($this->tablename)
            ->where($queryBuilder->expr()->eq('uid', $queryBuilder->createNamedParameter($uid, Connection::PARAM_INT)))
            ->executeQuery()
            ->fetchAssociative();
    }

    protected function getEventByUid(int $uid)
    {
        $eventArray = $this->getEventByUidRaw($uid);
        if ($eventArray !== false && is_array($eventArray) && !empty($eventArray)) {
            $dataMapper = GeneralUtility::makeInstance(DataMapper::class);
            $events = $dataMapper->map(Event::class, [$eventArray]);
            $event = $events[0];
        } else {
            $event = GeneralUtility::makeInstance(Event::class);
        }
        return $event;
    }


    protected function getEventByUidRaw(int $uid)
    {
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('tx_igruckzuckevent_domain_model_event');
        return $queryBuilder
            ->select('*')
            ->from('tx_igruckzuckevent_domain_model_event')
            ->where($queryBuilder->expr()->eq('uid', $queryBuilder->createNamedParameter($uid, Connection::PARAM_INT)))
            ->executeQuery()
            ->fetchAssociative();
    }

    protected function getFormFieldsForEvent(int $eventUid)
    {
        $formFieldsArray = $this->getFormFieldsForEventRaw($eventUid);
        $formFields = [];
        if ($formFieldsArray !== false && is_array($formFieldsArray) && !empty($formFieldsArray)) {
            $dataMapper = GeneralUtility::makeInstance(DataMapper::class);
            $formFields = $dataMapper->map(FormField::class, $formFieldsArray);
        } 
        return $formFields;
    }

    protected function getFormFieldsForEventRaw(int $eventUid)
    {
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('tx_igruckzuckevent_domain_model_formfield');
        return $queryBuilder
            ->select('*')
            ->from('tx_igruckzuckevent_domain_model_formfield')
            ->where($queryBuilder->expr()->eq('event', $queryBuilder->createNamedParameter($eventUid, Connection::PARAM_INT)))
            ->executeQuery()
            ->fetchAllAssociative();
    }

}