<?php
namespace Ig\IgRuckzuckevent\Form\Element;

use DateTime;
use Ig\IgRuckzuckevent\Domain\Model\Eventgroup;
use TYPO3\CMS\Backend\Form\Element\SelectSingleElement;
use TYPO3\CMS\Core\Database\Connection;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Imaging\Icon;
use TYPO3\CMS\Core\Imaging\IconFactory;
use TYPO3\CMS\Core\Page\JavaScriptModuleInstruction;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Utility\MathUtility;
use TYPO3\CMS\Core\Utility\StringUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\Mapper\DataMapper;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;

use TYPO3\CMS\Extbase\Utility\DebuggerUtility;

class RecurrenceFormElements extends SelectSingleElement
{
    protected string $baseFormName = 'recurrence';
    protected string $tablename = 'tx_igruckzuckevent_domain_model_eventgroup';
    protected string $attributePrefix = 'recurrence_';
    protected $fields = [
        'update_scope' => [
            'label' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_db.xlf:tx_igruckzuckevent_domain_model_event.recurrence_behaviour',
            'config' => [
                'items' => [
                    [
                        'label' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_db.xlf:tx_igruckzuckevent_domain_model_event.recurrence.scope.all',
                        'value' => 'all'
                    ],
                    /*
                      [
                      'label' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_db.xlf:tx_igruckzuckevent_domain_model_event.recurrence.scope.future',
                      'value' => 'future'
                      ],
                    */
                    [
                        'label' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_db.xlf:tx_igruckzuckevent_domain_model_event.recurrence.scope.this',
                        'value' => 'this'
                    ],
                ],            
            ],            
        ],
    ];
    
    protected function renderTextLabel(string $label, string $for): string
    {
        return '<label for="' . htmlspecialchars($for) . '" class="form-label t3js-formengine-label">' . $label . '</label>';

    }

    
    public function render(): array
    {
        $resultArray = parent::render();
        $row = $this->data['databaseRow'];
        $eventgroupUid = (int)($row['eventgroup'][0] ?? 0);
        $eventgroup = $this->getEventgroupByUid($eventgroupUid);
        //$resultArray = $this->initializeResultArray();
        //$resultArray['labelHasBeenHandled'] = true;

        $parameterArray = $this->data['parameterArray'];
        $request = $GLOBALS['TYPO3_REQUEST'];
        $queryParamsRecurrence = $request->getQueryParams()['recurrence'] ?? [];

        $isNewRecord = (int)($this->data['databaseRow']['uid'] ?? 0) === 0;
        //$items = $parameterArray['fieldConf']['config']['items'];

        $html = [];

        $html[] = '<div class="row">';
        $html[] = '<div class="form-group t3js-formengine-validation-marker t3js-formengine-palette-field col col-sm-6">';
        // frequency input
        $html[] = $this->getFieldSelect('frequency', $eventgroup->getRecurrenceFrequency() ?? '');
        $html[] = '</div>'; // end form-group
        

        if (!$isNewRecord) {
            $html[] = '<div class="form-group t3js-formengine-validation-marker t3js-formengine-palette-field col col-sm-6">';
            // update scope
            $dateFrom = substr($row['date_from'], 0, 10);
            $itemValue = $queryParamsRecurrence['update_scope'] ?? 'all';
            if ($eventgroup->isExcludeDate($dateFrom)) {
                $itemValue = 'this';
            }
            $html[] = $this->getFieldSelect('update_scope', $itemValue, $this->fields['update_scope']);
            $html[] = '</div>'; // end form-group
        }
        $html[] = '</div>'; // end row
        

        
        $html[] = '<div class="row">';
        $html[] = '<div class="form-group t3js-formengine-validation-marker t3js-formengine-palette-field col col-sm-6">';
        // ends_on Date input
        $html[] = $this->getFieldDate('ends_on', $eventgroup->getRecurrenceEndsOn()?->getTimestamp() ?? null);
        $resultArray['javaScriptModules'][] = JavaScriptModuleInstruction::create('@typo3/backend/form-engine/element/datetime-element.js');
        $html[] = '</div>'; // end form-group
        
        $html[] = '<div class="form-group t3js-formengine-validation-marker t3js-formengine-palette-field col col-sm-6">';
        // ends_after input
        $infoText = LocalizationUtility::translate('LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_db.xlf:tx_igruckzuckevent_domain_model_event.recurrence.occurrences');
        $html[] = $this->getFieldTextfield('ends_after', $eventgroup->getRecurrenceEndsAfter(), null, $infoText);
        $html[] = '</div>'; // end form-group
        $html[] = '</div>'; // end row

        $resultArray['html'] = implode(LF, $html) . $resultArray['html'];
        return $resultArray;
    }

    // simple text field
    protected function getFieldTextfield(string $itemName, ?string $itemValue = null, ?int $width = null, ?string $infoText = null): string
    {
        $html = [];
        $fieldId = StringUtility::getUniqueId('formengine-input-');
        $width = $this->formMaxWidth($width ?? $this->defaultInputWidth);
        $html[] = $this->renderTextLabel(LocalizationUtility::translate($GLOBALS['TCA'][$this->tablename]['columns'][$this->attributePrefix . $itemName]['label']), $fieldId);
        $html[] = '<div class="formengine-field-item t3js-formengine-field-item">
  <div class="form-wizards-wrap">
    <div class="form-wizards-element">
      <div class="form-control-wrap" style="max-width: ' . $width . 'px">
                <input type="text" class="form-control" name="' . $this->baseFormName . '[' . $itemName . ']" value="' . htmlspecialchars($itemValue ?? '') . '" /> ' . ($infoText ?? '');
        $html[]= '</div>
    </div>
  </div>
</div>';
        return implode(LF, $html);
    }

    // select field
    protected function getFieldSelect(string $itemName, ?string $itemValue = null, array $fieldConf = null): string
    {
        if ($fieldConf === null) {
            $fieldConf = $GLOBALS['TCA'][$this->tablename]['columns'][$this->attributePrefix . $itemName];
            //var_dump($fieldConf['config']['items']);exit(0);
        }
        $html = [];
        $fieldId = StringUtility::getUniqueId('formengine-select-');
        $html[] = $this->renderTextLabel(LocalizationUtility::translate($fieldConf['label']), $fieldId);
        $html[] = '<div class="formengine-field-item t3js-formengine-field-item">
  <div class="form-wizards-wrap">
    <div class="form-wizards-element">
      <div class="form-control-wrap">
                <select class="form-select form-control-adapt" name="' . $this->baseFormName . '[' . $itemName . ']">';
        foreach ($fieldConf['config']['items'] as $item ) {
            $html[] = '<option value="' . $item['value'] . '"' . ($itemValue == $item['value'] ? 'selected="selected"' : '') . '>' . htmlspecialchars(LocalizationUtility::translate($item['label'])) . '</option>';
        }
        $html[]= '</select>
      </div>
    </div>
  </div>
</div>';
        return implode(LF, $html);
    }

    // date field (vendor/typo3/cms-backend/Classes/Form/Element/DatetimeElement.php)
    protected function getFieldDate(string $itemName, ?int $itemValue = null): string
    {
        $fieldId = StringUtility::getUniqueId('formengine-input-');
        $format = 'date';
        $config = [];
        $evalList = [$format];
        $width = $this->formMaxWidth(MathUtility::forceIntegerInRange(13, $this->minimumInputWidth, $this->maxInputWidth));
        /*
          if (!empty($itemValue) && !MathUtility::canBeInterpretedAsInteger($itemValue)) {
          $itemValue = (new DateTime((string)$itemValue))->getTimestamp();
          }
        */
        // Format the unix-timestamp to the defined format (date/year etc)
        $itemValue = $this->formatValue($format, $itemValue);


        $attributes = [
            'value' => '',
            'id' => $fieldId,
            'class' => implode(' ', [
                'form-control',
                'form-control-clearable',
                't3js-clearable',
            ]),
            'data-input-type' => 'datetimepicker',
            'data-date-type' => 'date',
            'data-formengine-validation-rules' => $this->getValidationDataAsJsonString($config),
            'data-formengine-input-params' => (string)json_encode([
                'field' => $this->baseFormName . '[' . $itemName . ']',
                'evalList' => implode(',', $evalList),
            ], JSON_THROW_ON_ERROR),
            'data-formengine-input-name' => $this->baseFormName . '[' . $itemName . ']',
        ];
        $languageService = $this->getLanguageService();

        // $fieldWizardResult = $this->renderFieldWizard();
        // $fieldWizardHtml = $fieldWizardResult['html'];
        // $resultArray = $this->mergeChildReturnIntoExistingResult($resultArray, $fieldWizardResult, false);

        // $fieldControlResult = $this->renderFieldControl();
        // $fieldControlHtml = $fieldControlResult['html'];
        // $resultArray = $this->mergeChildReturnIntoExistingResult($resultArray, $fieldControlResult, false);
        

        $buttonAriaLabelEscaped = htmlspecialchars($languageService->sL('LLL:EXT:core/Resources/Private/Language/locallang_core.xlf:labels.datepicker.label'));

        $iconFactory = GeneralUtility::makeInstance(IconFactory::class);
        $expansionHtml = [];
        $expansionHtml[] = '<div class="form-control-wrap" style="max-width: ' . $width . 'px">';
        $expansionHtml[] =  '<div class="form-wizards-wrap">';
        $expansionHtml[] =      '<div class="form-wizards-element">';
        $expansionHtml[] =          '<div class="input-group">';
        $expansionHtml[] =              '<input type="text" ' . GeneralUtility::implodeAttributes($attributes, true) . ' />';
        $expansionHtml[] =              '<input type="hidden" name="' . $this->baseFormName . '[' . $itemName . ']" value="' . htmlspecialchars((string)$itemValue) . '" />';
        $expansionHtml[] =              '<button class="btn btn-default" aria-label="' . $buttonAriaLabelEscaped . '" type="button" data-global-event="click" data-action-focus="#' . $attributes['id'] . '">';
        $expansionHtml[] =                  $iconFactory->getIcon('actions-edit-pick-date', Icon::SIZE_SMALL)->render();
        $expansionHtml[] =              '</button>';
        $expansionHtml[] =          '</div>';
        $expansionHtml[] =      '</div>';
        $expansionHtml[] =  '</div>';
        $expansionHtml[] = '</div>';
        $expansionHtml = implode(LF, $expansionHtml);

        $fullElement = [];
        /*
          $fullElement[] = '<div class="form-check t3js-form-field-eval-null-placeholder-checkbox">';
          $fullElement[] =     '<input type="hidden" name="' . $nullControlNameEscaped . '" value="0" />';
          $fullElement[] =     '<input type="checkbox" class="form-check-input" name="' . $nullControlNameEscaped . '" id="' . $nullControlNameEscaped . '" value="1"' . $checked . ' />';
          $fullElement[] =     '<label class="form-check-label" for="' . $nullControlNameEscaped . '">';
          $fullElement[] =         $overrideLabel;
          $fullElement[] =     '</label>';
          $fullElement[] = '</div>';
          $fullElement[] = '<div class="t3js-formengine-placeholder-placeholder">';
          $fullElement[] =    '<div class="form-control-wrap" style="max-width:' . $width . 'px">';
          $fullElement[] =        '<input type="text" class="form-control" disabled="disabled" value="' . htmlspecialchars($shortenedPlaceholder) . '" />';
          $fullElement[] =    '</div>';
          $fullElement[] = '</div>';
        */
        $fullElement[] = '<div class="t3js-formengine-placeholder-formfield">';
        $fullElement[] =    $expansionHtml;
        $fullElement[] = '</div>';
        $fullElement = implode(LF, $fullElement);

        $renderedLabel = $this->renderTextLabel(LocalizationUtility::translate($GLOBALS['TCA'][$this->tablename]['columns'][$this->attributePrefix . $itemName]['label']), $fieldId);
        return  $renderedLabel . '
            <typo3-formengine-element-datetime class="formengine-field-item t3js-formengine-field-item" recordFieldId="' . htmlspecialchars($fieldId) . '">
                ' . $fullElement . '
            </typo3-formengine-element-datetime>';
    }

    protected function getEventgroupByUid(int $uid)
    {
        $eventgroupArray = $this->getEventgroupByUidRaw($uid);
        if ($eventgroupArray !== false && is_array($eventgroupArray) && !empty($eventgroupArray)) {
            $dataMapper = GeneralUtility::makeInstance(DataMapper::class);
            $eventgroups = $dataMapper->map(Eventgroup::class, [$eventgroupArray]);
            $eventgroup = $eventgroups[0];            
        } else {
            $eventgroup = GeneralUtility::makeInstance(Eventgroup::class);
        }
        return $eventgroup;
    }

    
    protected function getEventgroupByUidRaw(int $uid)
    {
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('tx_igruckzuckevent_domain_model_eventgroup');;
        return $queryBuilder
            ->select('*')
            ->from('tx_igruckzuckevent_domain_model_eventgroup')
            ->where($queryBuilder->expr()->eq('uid', $queryBuilder->createNamedParameter($uid, Connection::PARAM_INT)))
            ->executeQuery()
            ->fetchAssociative();
    }

}