<?php
namespace Ig\IgRuckzuckevent\Hook;

use DateTime;
use DateTimeZone;
use Ig\IgRuckzuckevent\Domain\Model\Eventgroup;
use TYPO3\CMS\Core\Database\Connection;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Database\Query\QueryHelper;
use TYPO3\CMS\Core\Database\Query\Restriction\HiddenRestriction;
use TYPO3\CMS\Core\DataHandling\DataHandler;
use TYPO3\CMS\Core\Messaging\FlashMessage;
use TYPO3\CMS\Core\Messaging\FlashMessageService;
use TYPO3\CMS\Core\SysLog\Action\Database;
use TYPO3\CMS\Core\SysLog\Error;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Core\Utility\MathUtility;
use TYPO3\CMS\Core\Utility\StringUtility;
use TYPO3\CMS\Extbase\Utility\DebuggerUtility;
use TYPO3\CMS\Extbase\Persistence\Generic\Mapper\DataMapper;

class AdditionalFieldsDataHandlerHook
{
    protected string $registrationTable = 'tx_igruckzuckevent_domain_model_registration';
    protected string $formFieldTable = 'tx_igruckzuckevent_domain_model_formfield';
    protected int $pid = 0;
    protected string $temporaryId = '';
    protected static bool $addDeletedToExcludeDate = true; // add deleted dates to exclude dates, so they are not created on recurrence updates


    /**
     * set max recurrence period for occurences
     */
    public function __construct()
    {
        //$this->maxRecurrenceDate = new DateTime((date('Y') + 2) . '-12-31');
        // @todo set this from constants? and do something like
        // $maxRecurrenceDateModifier = 'last day of December +2 years';
        // $currentDate = new DateTime();
        // $this->maxRecurrenceDate = $currentDate->modify($maxRecurrenceDateModifier);
    }

    /**
     * on create/update also create/update occurences according update_scope and update eventgroup
     */
    public function processDatamap_beforeStart(DataHandler $dataHandler)
    {
        // no events to change
        if (empty($dataHandler->datamap[$this->registrationTable] ?? [])) {
            return;
        }
        $conn = GeneralUtility::makeInstance(ConnectionPool::class)->getConnectionForTable($this->formFieldTable);
        foreach ($dataHandler->datamap[$this->registrationTable] as $registrationUid => $registration) {
            /*$eventUid = $registration['event'];
            $qb = $conn->createQueryBuilder();

            $formFields = $qb->select('*')
                             ->from($this->formFieldTable)
                             ->where($qb->expr()->eq('event', $qb->createNamedParameter($eventUid, Connection::PARAM_INT)))
                             ->executeQuery()
                             ->fetchAllAssociative();

            foreach($formFields as $formField) {
                if($formField['type'] == 'Checkbox') {
                    foreach($registration['additional_fields'] as $identifier => &$additionalField) {
                        if($identifier == 'additional-' . $formField['uid'] && !is_array($additionalField)) {
                            $additionalField = explode("\n", $additionalField);
                        }
                    }
                }
            }*/
            if(is_array($registration['additional_fields'])) {
                $dataHandler->datamap[$this->registrationTable][$registrationUid]['additional_fields'] = serialize($registration['additional_fields']);
            }
        }
    }

    

}