<?php
namespace Ig\IgRuckzuckevent\Utility;

class JsonUtility
{
    public static function getJsonForProperties($properties)
    {
        $json = [];

        $site = $GLOBALS['TYPO3_REQUEST']->getAttribute('site');

        foreach($properties as $propertyName => $value) {
            if(!is_object($value)) {
                $json[$propertyName] = $value;
            } else if($value instanceof \DateTime) {
                $json[$propertyName] = $value->format('Y-m-d H:i:s');
            } else if($value instanceof \TYPO3\CMS\Extbase\Persistence\ObjectStorage || is_array($value)) {
                $data = [];
                foreach($value as $v) {
                    if($v instanceof \TYPO3\CMS\Extbase\Domain\Model\FileReference) {
                        $data[] = [
                            'file' => rtrim($site->getConfiguration()['base'], '/') . $v->getOriginalResource()->getPublicUrl(),
                            'extension' => $v->getOriginalResource()->getExtension(),
                            'size' => $v->getOriginalResource()->getSize()
                        ];
                    } else if(method_exists($v, 'getJson')) {
                        $data[] = $v->getJson();
                    } else {
                        $data[] = $v->getUid();
                    }
                }
                $json[$propertyName] = $data;
            } else if(is_object($value)) {
                    if($value instanceof \TYPO3\CMS\Extbase\Domain\Model\FileReference) {
                    $data[] = [
                        'file' => rtrim($site->getConfiguration()['base'], '/') . $value->getOriginalResource()->getPublicUrl(),
                        'extension' => $value->getOriginalResource()->getExtension(),
                        'size' => $value->getOriginalResource()->getSize()
                    ];
                } else if(method_exists($value, 'getJson')) {
                    $json[$propertyName] = $value->getJson();
                } else {
                    $json[$propertyName] = $value->getUid();
                }
            }
        }

        return $json;
    }
}
