<?php

namespace Ig\IgRuckzuckevent\Controller;

use DateTime;
use Evoweb\Recaptcha\Services\CaptchaService;
use Ig\IgRuckzuckevent\Controller\TYPO3\CMS\Extbase\Annotation\IgnoreValidation;
use Ig\IgRuckzuckevent\Controller\TYPO3\CMS\Extbase\Annotation\Validate;
use Ig\IgRuckzuckevent\Domain\Model\Event;
use Ig\IgRuckzuckevent\Domain\Model\FeUser;
use Ig\IgRuckzuckevent\Domain\Model\Registration;
use Ig\IgRuckzuckevent\Domain\Model\Subscription;
use Ig\IgRuckzuckevent\Domain\Repository\AttentionRepository;
use Internetgalerie\IgRecurrenceDate\Domain\Repository\EventgroupRepository;
use Ig\IgRuckzuckevent\Domain\Repository\EventRepository;
use Ig\IgRuckzuckevent\Domain\Repository\FeUserRepository;
use Ig\IgRuckzuckevent\Domain\Repository\RegistrationRepository;
use Ig\IgRuckzuckevent\Domain\Repository\StatusRepository;
use Ig\IgRuckzuckevent\Domain\Repository\SubscriptionOfferRepository;
use Ig\IgRuckzuckevent\Domain\Repository\SubscriptionRepository;
use Ig\IgRuckzuckevent\Domain\Repository\WorkareaRepository;
use Ig\IgRuckzuckevent\Domain\Validator\AgbValidator;
use Ig\IgRuckzuckevent\Service\WaitlistService;
use Ig\IgRuckzuckevent\Service\MailService;
use Ig\IgRuckzuckevent\Domain\Validator\DatesValidator;
use Ig\IgRuckzuckevent\Domain\Validator\SubscriptionCountValidator;
use Ig\IgRuckzuckevent\Event\BeforeSendUserMailEvent;
use Ig\IgRuckzuckevent\Event\RegistrationEvent;
use Ig\IgRuckzuckevent\Utility\CacheUtility;
use Ig\IgRuckzuckevent\Utility\UserUtility;
use Internetgalerie\IgDynval\Controller\DynamicValidationActionController;
use Internetgalerie\IgDynval\Validation\Validator\DynamicValidator;
use Internetgalerie\IgFrontendUser\Domain\Repository\FrontendUserGroupRepository;
use PhpOffice\PhpSpreadsheet\Cell\DataType;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Psr\EventDispatcher\EventDispatcherInterface;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Type\ContextualFeedbackSeverity;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Annotation\IgnoreValidation as AnnotationIgnoreValidation;
use TYPO3\CMS\Extbase\Annotation\Validate as AnnotationValidate;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;
use TYPO3\CMS\Extbase\Http\ForwardResponse;
use TYPO3\CMS\Extbase\Mvc\Controller\Exception\RequiredArgumentMissingException;
use TYPO3\CMS\Extbase\Persistence\Generic\PersistenceManager;
use TYPO3\CMS\Extbase\Property\TypeConverter\DateTimeConverter;
use TYPO3\CMS\Extbase\Utility\DebuggerUtility;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;
use TYPO3\CMS\Fluid\View\StandaloneView;

/**
 * The RegistrationController handles all the actions directly related to Registrations
 */
class RegistrationController extends \Internetgalerie\IgDatapoolFe\Controller\ActionController
{
    use DynamicValidationActionController;

    /**
     * The repository for registrations
     *
     * @var RegistrationRepository
     */
    protected $registrationRepository = null;

    /**
     * The repository for registrations
     *
     * @var StatusRepository
     */
    protected $statusRepository = null;

    /**
     * The repository for registrations
     *
     * @var AttentionRepository
     */
    protected $attentionRepository = null;

    /**
     * The repository for events
     *
     * @var EventRepository
     */
    protected $eventRepository = null;

    /**
     * The repository for eventgroups
     *
     * @var EventgroupRepository
     */
    protected $eventgroupRepository = null;

    /**
     * feUserRepository
     *
     * @var FeUserRepository
     */
    protected $feUserRepository = null;

    /**
     * feUserGroupRepository
     *
     * @var FrontendUserGroupRepository
     */
    protected $feUserGroupRepository = null;

    /**
     * subscriptionOfferRepository
     *
     * @var SubscriptionOfferRepository
     */
    protected $subscriptionOfferRepository = null;

    /**
     * subscriptionRepository
     *
     * @var SubscriptionRepository
     */
    protected $subscriptionRepository = null;

    /**
     * workareaRepository
     *
     * @var WorkareaRepository
     */
    protected $workareaRepository = null;

    /**
     * waitlistService
     *
     * @var WaitlistService
     */
    protected $waitlistService = null;

    /**
     * mailService
     *
     * @var MailService
     */
    protected $mailService = null;

    protected CaptchaService $captchaService;

    public function injectRegistrationRepository(RegistrationRepository $registrationRepository): void
    {
        $this->registrationRepository = $registrationRepository;
    }

    /**
     * Set the value of The repository for registrations
     */
    public function injectStatusRepository(StatusRepository $statusRepository): void
    {
        $this->statusRepository = $statusRepository;
    }

    public function injectAttentionRepository(AttentionRepository $attentionRepository): void
    {
        $this->attentionRepository = $attentionRepository;
    }

    public function injectEventRepository(EventRepository $eventRepository): void
    {
        $this->eventRepository = $eventRepository;
    }

    public function injectEventgroupRepository(EventgroupRepository $eventgroupRepository): void
    {
        $this->eventgroupRepository = $eventgroupRepository;
    }

    public function injectFeUserRepository(FeUserRepository $feUserRepository): void
    {
        $this->feUserRepository = $feUserRepository;
    }

    public function injectFeUserGroupRepository(FrontendUserGroupRepository $feUserGroupRepository): void
    {
        $this->feUserGroupRepository = $feUserGroupRepository;
    }

    public function injectSubscriptionOfferRepository(SubscriptionOfferRepository $subscriptionOfferRepository): void
    {
        $this->subscriptionOfferRepository = $subscriptionOfferRepository;
    }

    public function injectSubscriptionRepository(SubscriptionRepository $subscriptionRepository): void
    {
        $this->subscriptionRepository = $subscriptionRepository;
    }

    public function injectWorkareaRepository(WorkareaRepository $workareaRepository): void
    {
        $this->workareaRepository = $workareaRepository;
    }

    public function injectCaptchaService(CaptchaService $captchaService): void
    {
        $this->captchaService = $captchaService;
    }

    public function injectWaitlistService(WaitlistService $waitlistService): void
    {
        $this->waitlistService = $waitlistService;
    }

    public function injectMailService(MailService $mailService): void
    {
        $this->mailService = $mailService;
    }


    public function initializeView($view): void
    {
        $this->view->assign('controller', 'Registration');
        $this->view->assign('pageUid', $this->request->getAttribute('frontend.page.information')?->getId());

        //parent::initializeView($view);
    }


    /**
     * Initializes the current action
     */
    public function initializeAction(): void
    {
        parent::initializeAction();

        // Setup mail service
        $this->mailService->setSettings($this->settings);
        $this->mailService->setRequest($this->request);

        // Setup waitlist service with settings and request
        $this->waitlistService->setSettings($this->settings);
        $this->waitlistService->setRequest($this->request);
        
        if (isset($this->arguments['registration']) || isset($this->arguments['newRegistration'])) {
            if (isset($this->arguments['registration'])) {
                $registration = $this->arguments['registration'];
            } else {
                $registration = $this->arguments['newRegistration'];
            }
            $propertyMappingConfiguration = $registration->getPropertyMappingConfiguration();

            // Set date format of date fields
            foreach (['validFrom'] as $dateField) {
                $propertyMappingConfiguration->forProperty($dateField)
->setTypeConverterOption(DateTimeConverter::class, DateTimeConverter::CONFIGURATION_DATE_FORMAT, 'd.m.Y');
            }
        }
    }


    /**
     * action new
     */
    #[AnnotationIgnoreValidation([
        'argumentName' => 'event',
    ])]
    public function newAction(?Event $event = null, array $default = []): ResponseInterface
    {
        if ($event === null && isset($this->settings['flexform']['event']) && (int)$this->settings['flexform']['event'] > 0) {
            /** @var Event $event */
            $event = $this->eventRepository->findByUid((int)$this->settings['flexform']['event']);
        }
        if ($event === null) {
            throw new RequiredArgumentMissingException(
                'Required argument "event" is not set for Ig\IgRuckzuckevent\Controller\RegistrationController->new.'
            );
        }

        $now = new DateTime();
        if ($event->getDateTimeFrom() < $now) {
            return $this->htmlResponse('');
        }

        // Check if event is accepting registrations (regular or waitlist)
        if (!$this->waitlistService->isAcceptingRegistrations($event)) {
            // Event is full and no waitlist - show message and redirect
            $this->addFlashMessage(
                'Dieser Kurs ist leider ausgebucht und es steht keine Warteliste zur Verfügung.',
                'Kurs ausgebucht',
                \TYPO3\CMS\Core\Type\ContextualFeedbackSeverity::WARNING
            );

            // Redirect to event detail page if available
            if ($this->settings['detailPageUid']) {
                return $this->redirect('show', 'Event', null, ['event' => $event], $this->settings['detailPageUid']);
            }

            return $this->htmlResponse('');
        }

        $workspaces = [];
        $i = 0;
        foreach ($GLOBALS['TCA']['tx_igruckzuckevent_domain_model_registration']['columns']['workspace']['config']['items'] as $item) {
            if ($i++ > 0) {
                $workspaces[$item['value']] = LocalizationUtility::translate($item['label'], 'IgRuckzuckevent');
            }
        }
        $workareas = $this->workareaRepository->findAll();
        $statusses = $this->statusRepository->findAll();
        $attentions = $this->attentionRepository->findAll();

        $context = GeneralUtility::makeInstance(Context::class);
        $languageUid = $context->getPropertyFromAspect('language', 'id');

        $this->view->assign('default', $default);
        $this->view->assign('event', $event);
        $this->view->assign('statusses', $statusses);
        $this->view->assign('attentions', $attentions);
        $this->view->assign('workspaces', $workspaces);
        $this->view->assign('workareas', $workareas);
        $this->view->assign('sys_language_uid', $languageUid);
        $this->view->assign('captchaConfiguration', $this->captchaService->getConfiguration());

        return $this->htmlResponse();
    }


    public function initializeCreateSimpleAction(): void
    {
        if ($this->arguments->hasArgument('newRegistration')) {
            // In the model we will serialize the array we got from the form, not the propertymapper shall do this
            $this->arguments->getArgument('newRegistration')
->getPropertyMappingConfiguration()
->setTargetTypeForSubProperty('additionalFields', 'array');
        }
    }
    /**
     * Action that gets called when submitting the event registration form
     */
    #[AnnotationValidate([
        'validator' => DynamicValidator::class,
        'param' => 'newRegistration',
    ])]
    public function createSimpleAction(Registration $newRegistration, array $default = []): ResponseInterface
    {
        $context = GeneralUtility::makeInstance(Context::class);
        $languageUid = $context->getPropertyFromAspect('language', 'id');
        $newRegistration->setLanguage($languageUid);

        $event = $newRegistration->getEvent();
        // captcha test > forward on empty at the moment
        $status = $this->captchaService->validateReCaptcha($this->request->getParsedBody()['g-recaptcha-response'] ?? '');
        if ($status == false || $status['error'] !== '') {
            return (new ForwardResponse('new'))
                ->withControllerName('Registration')
                ->withArguments([
                    'event' => $newRegistration->getEvent()->getUid(),
                ]);
        }

        // Check if registration can be accepted (regular or waitlist)
        if (!$this->waitlistService->canAcceptRegistration($event, $newRegistration)) {
            return (new ForwardResponse('new'))
                ->withControllerName('Registration')
                ->withArguments([
                    'event' => $newRegistration->getEvent()->getUid(),
                ]);
        }

        // Process registration and set waitlist status appropriately
        $this->waitlistService->processNewRegistration($event, $newRegistration);

        $this->registrationRepository->add($newRegistration);
        $persistenceManager = GeneralUtility::makeInstance(PersistenceManager::class);
        $persistenceManager->persistAll();
        $cacheUtility = GeneralUtility::makeInstance(CacheUtility::class);
        $cacheUtility->flushByEventId($event->getUid());
        $context = GeneralUtility::makeInstance(Context::class);
        $languageUid = $context->getPropertyFromAspect('language', 'id');

        $registrationData = GeneralUtility::makeInstance(EventDispatcherInterface::class)->dispatch(
            new RegistrationEvent($newRegistration, $this->request, $default)
        )->getData();

        // Setup fluid template for the confirmation mail
        $variables = [
            'registration' => $newRegistration,
            'event' => $event,
            'langUid' => $languageUid,
            'registrationData' => $registrationData,
        ];

        // Send User Mail
        if ($newRegistration->getEmail()) {
            // Determine template and subject based on waitlist status
            $template = 'IgRuckzuckevent/Registration/Create/User';
            $subjectKey = 'email.user.subject';

            if ($newRegistration->getWaitlist()) {
                $template = 'IgRuckzuckevent/Registration/Create/UserWaitlist';
                $subjectKey = 'email.user.waitlist.subject';
            }

            // Build email
            $email = $this->mailService->buildFluidEmail(
                LocalizationUtility::translate($subjectKey, 'IgRuckzuckevent'),
                [$this->settings['mailFrom']],
                [$newRegistration->getEmail()],
                $template,
                $variables
            );

            // Dispatch event to allow modifications
            $email = GeneralUtility::makeInstance(EventDispatcherInterface::class)->dispatch(
                new BeforeSendUserMailEvent($email, $registrationData)
            )->getMail();

            // Send the email
            $this->mailService->send($email);
        }
        // Send admin mail
        if ($this->settings['mailTo'] || $event->getRegistrationEmail() || $event->getOrganizer() && $event->getOrganizer()->getEmail()) {
            $mailTo = $this->settings['mailTo'];
            if ($event->getRegistrationEmail()) {
                $mailTo = $event->getRegistrationEmail();
            }
            if ($event->getOrganizer() && $event->getOrganizer()->getEmail()) {
                $mailTo = $event->getOrganizer()
->getEmail();
            }

            // Determine admin email subject based on waitlist status
            $adminSubjectKey = 'email.admin.subject';
            if ($newRegistration->getWaitlist()) {
                $adminSubjectKey = 'email.admin.waitlist.subject';
            }

            $this->mailService->sendMail(
                LocalizationUtility::translate($adminSubjectKey, 'IgRuckzuckevent'),
                [$this->settings['mailFrom']],
                explode(',', (string) $mailTo),
                'IgRuckzuckevent/Registration/Create/Admin',
                $variables
            );
        }
        // Redirect to thank you page
        return $this->redirect('thankYou', 'Registration', 'IgRuckzuckevent', [
            'registration' => $newRegistration,
        ], $this->settings['thankYouPageUid']);
    }

    /**
     * Shows thank you page
     */
    #[AnnotationIgnoreValidation([
        'argumentName' => 'registration',
    ])]
    public function thankYouAction(Registration $registration): ResponseInterface
    {
        $this->view->assign('registration', $registration);

        return $this->htmlResponse();
    }



    /**
     * action export
     */
    public function exportAction(): ResponseInterface
    {
        return $this->htmlResponse();
    }


    /**
     * Physio Team
     **/
    /**
     * Action that gets called when submitting the event registration form when logged in
     *
     * @param boolean $agb
     * @param string $captcha
     */
    #[AnnotationValidate([
        'validator' => DynamicValidator::class,
        'param' => 'newRegistration',
    ])]
    #[AnnotationValidate([
        'validator' => DatesValidator::class,
        'param' => 'dates',
    ])]
    #[AnnotationValidate([
        'validator' => 'NotEmpty',
        'param' => 'subscription',
    ])]
    #[AnnotationValidate([
        'validator' => SubscriptionCountValidator::class,
        'param' => 'subscription',
    ])]
    #[AnnotationValidate([
        'validator' => AgbValidator::class,
        'param' => 'agb',
    ])]
    public function createAction(
        Registration $newRegistration,
        array $dates,
        bool $agb,
        ?Subscription $subscription = null,
        $captcha = ''
    ): ResponseInterface {
        $context = GeneralUtility::makeInstance(Context::class);
        $userId = $context->getPropertyFromAspect('frontend.user', 'id');
        $isLoggedIn = $context->getPropertyFromAspect('frontend.user', 'isLoggedIn');
        $languageUid = $context->getPropertyFromAspect('language', 'id');
        $message = '';

        $newRegistration->setLanguage($languageUid);

        if ($isLoggedIn && (UserUtility::isAdminLoggedIn() || $newRegistration->getFeUser()->getUid() == $userId)) {
            if ($this->request->hasArgument('managementUser') && UserUtility::isAdminLoggedIn()) {
                $user = $this->feUserRepository->findByUid($this->request->getArgument('managementUser'));
            } else {
                $user = $this->feUserRepository->findByUid($userId);
            }

            if (UserUtility::isAdminLoggedIn()) {
                $newRegistration->setPaymentMethod('office');
            } else {
                $newRegistration->setPaymentMethod($subscription->getSubscriptionOffer()->getName());
            }
            $newRegistration->setFeUser($user);
            $newRegistration->setSubscription($subscription);

            $cacheUtility = GeneralUtility::makeInstance(CacheUtility::class);
            $dateObjects = [];
            $dateErrors = [];
            foreach ($dates as $eventUid) {
                if ($subscription->getDaysLeft() > 0) {
                    $event = $this->eventRepository->findByUid($eventUid);
                    // If no registrations are possible, the deadline is reached or the event is booked up throw a specific error error
                    $skipSetEvent = false;
                    if (!$event -> getRegistrationsPossible()) {
                        $dateErrors[] = 'Keine Anmeldungen für den Kurs am ' . $event->getDateFrom()->format(
                            'd.m.Y'
                        ) . ' möglich';
                        $skipSetEvent = true;
                    } elseif ($event -> getRegistrationNotStarted()) {
                        $dateErrors[] = 'Die Anmeldung für den Kurs am ' . $event->getDateFrom()->format('d.m.Y') . ' hat noch nicht begonnen';
                        $skipSetEvent = true;
                    } elseif ($event -> getDeadlineReached()) {
                        $dateErrors[] = 'Der Kurs am ' . $event->getDateFrom()->format('d.m.Y') . ' ist bereits vorbei';
                        $skipSetEvent = true;
                    } elseif ($event -> getState() == 'bookedUp' && !$event->getEnableWaitlist()) {
                        //var_dump($registration);exit(0);
                        $dateErrors[] = 'Der Kurs am ' . $event->getDateFrom()->format('d.m.Y') . ' ist ausgebucht';
                        $skipSetEvent = true;
                    }

                    if (!$skipSetEvent) {
                        $newRegistration->setEvent($event);
                        // Process registration and set waitlist status appropriately
                        $this->waitlistService->processNewRegistration($event, $newRegistration);
                        $this->registrationRepository->add(clone $newRegistration);
                        $dateObjects[] = $event;
                        $subscription->setDaysLeft($subscription->getDaysLeft() - 1);
                        $cacheUtility->flushByEventId($event->getUid());
                    }
                }
            }

            if (!empty($dateErrors)) {
                $request = $this->request;
                return (new ForwardResponse('show'))->withControllerName('Calendar')
                ->withArguments(array_merge($request->getArguments(), ['dateErrors' => $dateErrors]));
            }

            if (GeneralUtility::validEmail($user -> getEmail())) {
                $this->mailService->sendMail(
                    'Physio-Team Naderi: Sie haben sich an einem Kurs angemeldet',
                    [$this->settings['debugMail'] ?: $this->settings['mailFrom']],
                    [$this->settings['debugMail'] ?: $user->getEmail()],
                    'IgRuckzuckevent/Registration/Calendar/New/User',
                    [
                        'registration' => $newRegistration,
                        'dates' => $dateObjects,
                    ]
                );
            }

            // Admin mail
            $this->mailService->sendMail(
                'Physio-Team Naderi: Neue Anmeldung an einen Kurs',
                [$this->settings['debugMail'] ?: $this->settings['mailFrom']],
                [$this->settings['debugMail'] ?: $this->settings['mailFrom']],
                'IgRuckzuckevent/Registration/Calendar/New/Admin',
                [
                    'registration' => $newRegistration,
                    'dates' => $dateObjects,
                ]
            );
            

            $message = 'success';
        }

        if (UserUtility::isAdminLoggedIn()) {
            //$pageUid = $this->settings['myflexformsettingpart'];
            $uriBuilder = $this->uriBuilder;
            $uri = $uriBuilder->setTargetPageUid(168)
->setArguments([
    'tx_igruckzuckevent_managementuser' => [
        'user' => $user,
    ],
])->build();
            return $this->redirectToURI($uri, null, 303);
        }
        return $this -> redirect('list', 'Calendar', 'IgRuckzuckevent', [
            'message' => $message,
        ]);
        
        exit();
    }


    public function searchExportAction(): ResponseInterface
    {
        $eventGroups = $this->eventgroupRepository->findAll();
        $groupArray = [];

        foreach ($eventGroups as $g) {
            $title = $g->getTitle();

            if ($title) {
                $groupArray[$g->getUid()] = $g->getTitle();
            }
        }

        $this->view->assign('eventGroups', array_unique($groupArray));

        return $this->htmlResponse();
    }

    public function exportXlsAction(): ResponseInterface
    {
        if ($this->request->hasArgument('search')) {
            $eventgroup = $this->eventgroupRepository->findByUid($this->request->getArgument('search')['event']);
            $events = $this->eventRepository->findPassedByTitle($eventgroup->getTitle())
->toArray();

            //$phpExcelService = GeneralUtility::makeInstanceService('phpexcel');
            $phpExcel = new Spreadsheet();
            $phpExcel->setActiveSheetIndex(0);
            $row = 1;

            $phpExcel->getActiveSheet()
->SetCellValue('A' . $row, $eventgroup->getTitle());
            $phpExcel->getActiveSheet()
->getStyle('A' . $row)->getFont()->setBold(true);

            $row++;

            // Second row: Output attribute titles
            $phpExcel->getActiveSheet()
->SetCellValue('A' . $row, 'Datum');
            $phpExcel->getActiveSheet()
->SetCellValue('B' . $row, 'Zeit von');
            $phpExcel->getActiveSheet()
->SetCellValue('C' . $row, 'Zeit bis');
            $phpExcel->getActiveSheet()
->SetCellValue('D' . $row, 'Vorname');
            $phpExcel->getActiveSheet()
->SetCellValue('E' . $row, 'Name');
            $phpExcel->getActiveSheet()
->SetCellValue('F' . $row, 'E-Mail-Adresse');
            $phpExcel->getActiveSheet()
->SetCellValue('G' . $row, 'Telefon');

            // Set second row bold
            $phpExcel->getActiveSheet()
->getStyle('A' . $row . ':G' . $row)->getFont()->setBold(true);

            $row++;

            usort($events, fn ($a, $b) => $a->getDateTimeFrom() > $b->getDateTimeFrom());
            foreach ($events as $event) {
                // We are beginning at the 3rd row (Excel rows count from 1)
                foreach ($event->getRegistrations() as $registration) {
                    if ($registration->getFeUser() || ($registration->getFirstName() && $registration->getName() && $registration->getEmail())) {
                        $phpExcel->getActiveSheet()
->SetCellValue('A' . $row, html_entity_decode((string) $event->getDateFrom()->format('d.m.Y')));
                        $phpExcel->getActiveSheet()
->SetCellValue('B' . $row, html_entity_decode((string) $event->getDateTimeFrom()->format('H:i')));
                        $phpExcel->getActiveSheet()
->SetCellValue('C' . $row, html_entity_decode((string) $event->getDateTimeTo()->format('H:i')));

                        if ($registration->getFeUser()) {
                            $phpExcel->getActiveSheet()
->SetCellValue('D' . $row, $registration->getFeUser()->getFirstName());
                            $phpExcel->getActiveSheet()
->SetCellValue('E' . $row, $registration->getFeUser()->getLastName());
                            $phpExcel->getActiveSheet()
->SetCellValue('F' . $row, $registration->getFeUser()->getEmail());
                            $phpExcel->getActiveSheet()
->SetCellValueExplicit('G' . $row, $registration->getFeUser()->getTelephone(), DataType::TYPE_STRING);
                        } else {
                            $phpExcel->getActiveSheet()
->SetCellValue('D' . $row, $registration->getFirstName());
                            $phpExcel->getActiveSheet()
->SetCellValue('E' . $row, $registration->getName());
                            $phpExcel->getActiveSheet()
->SetCellValue('F' . $row, $registration->getEmail());
                            $phpExcel->getActiveSheet()
->SetCellValueExplicit('G' . $row, $registration->getPhone(), DataType::TYPE_STRING);
                        }
                        $row++;
                    }
                }
            }

            // Set column width automatically according to their content
            foreach (range('A', 'G') as $column) {
                $phpExcel->getActiveSheet()
->getColumnDimension($column)
->setAutoSize(true);
            }

            // Temporary fielname
            $fileName = 'typo3temp/events-' . $eventgroup->getUid() . '-' . time() . '.xlsx';

            // Create an Excel Writer
            $excelWriter = new Xlsx($phpExcel); // Create an Excel Writer
            // Save to temporary file
            $excelWriter->save($fileName);

            // Set headers
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Content-Disposition: attachment;filename="' . str_replace('typo3temp/', '', $fileName) . '"');
            header('Cache-Control: max-age=0');
            // If you're serving to IE 9, then the following may be needed
            header('Cache-Control: max-age=1');
            // If you're serving to IE over SSL, then the following may be needed
            header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
            // Date in the past
            header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
            // always modified
            header('Cache-Control: cache, must-revalidate');
            // HTTP/1.1
            header('Pragma: public');
            // HTTP/1.0
            header('Content-Length: ' . filesize($fileName));
            //header('Pragma: no-cache');

            echo file_get_contents($fileName);
            // Output file

            unlink($fileName);
            // Delete temporary file

            exit();

            return $this->htmlResponse();
        }
        return $this->redirect('searchExport');
    }


    /**
     * Deletes a registration
     *
     * @param bool $byEvent
     */
    public function deleteAction(Registration $registration, $byEvent = false): ResponseInterface
    {
        $user = $registration->getFeUser();
        $event = $registration->getEvent();
        $canDelete = $registration->getCanDelete();

        $context = GeneralUtility::makeInstance(Context::class);
        $userId = $context->getPropertyFromAspect('frontend.user', 'id');
        $isLoggedIn = $context->getPropertyFromAspect('frontend.user', 'isLoggedIn');

        if ($isLoggedIn && (UserUtility::isAdminLoggedIn() || ($user->getUid() == $userId && $canDelete))) {
            $subscription = GeneralUtility::makeInstance(Subscription::class);

            $product = $this->subscriptionOfferRepository->findByUid(1);

            if ($user) {
                $subscription->setSubscriptionOffer($product);
                $subscription->setFeUser($user);

                $startDateObject = new DateTime();

                $inThreeMonths = clone $startDateObject;
                $inThreeMonths->modify('+' . $product->getDuration() . ' month');

                $subscription->setStartDate($startDateObject);
                $subscription->setExpirationDate($inThreeMonths);
                $subscription->setDaysLeft($product->getDays());

                $user->addSubscription($subscription);

                $this->subscriptionRepository->add($subscription);
            }
            $this->registrationRepository->remove($registration);
        } else {
            $this->addFlashMessage('Anmeldungen können nur bis 24 Stunden vor Kursbeginn gelöscht werden');
        }

        if (UserUtility::isAdminLoggedIn()) {
            if ($byEvent) {
                return $this -> redirect('listByEvent', 'Registration', 'IgRuckzuckevent', [
                    'event' => $event,
                ]);
            }
            return $this -> redirect('list', 'Registration', 'IgRuckzuckevent', [
                'user' => $user,
            ]);
        }
        return $this -> redirect('list', 'Registration', 'IgRuckzuckevent');
    }

    /**
     * Lists the registrations of a user. If no user is provided the logged in user is taken. If a user is provided, admin access is required.
     */
    public function listByEventAction(Event $event): ResponseInterface
    {
        if (UserUtility::isAdminLoggedIn()) {
            $this->view->assign('event', $event);
        }

        return $this->htmlResponse();
    }

    /**
     * Lists the registrations of a user. If no user is provided the logged in user is taken. If a user is provided, admin access is required.
     */
    public function listAction(?FeUser $user = null): ResponseInterface
    {
        $context = GeneralUtility::makeInstance(Context::class);
        $userId = $context->getPropertyFromAspect('frontend.user', 'id');
        $isLoggedIn = $context->getPropertyFromAspect('frontend.user', 'isLoggedIn');
        if (!$user && $userId) {
            $user = $this->feUserRepository->findByUid($userId);
        }

        if ($isLoggedIn && (UserUtility::isAdminLoggedIn() || $user->getUid() == $userId)) {
            $this->view->assign('user', $user);
        }

        return $this->htmlResponse();
    }

    /**
     * Action that gets called when submitting the event registration form when not logged in
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Event $event
     * @param string $mode
     */
    public function loginFirstAction(Event $event, array $dates, $mode = 'login'): ResponseInterface
    {
        $GLOBALS['TSFE']->fe_user->setAndSaveSessionData('tx_igruckzuckevent_dates', $dates);

        if ($mode == 'register') {
            return $this->redirect('new', 'User', 'IgRuckzuckevent', [
                'referer' => $this->generateReferer($event),
            ]);
        }
        $redirect = $this->uriBuilder->reset()
        ->setCreateAbsoluteUri(true)
        ->setArguments([
            'return_url' => $this->generateReferer($event),
        ])
        ->setTargetPageUid($this->settings['pageUidLogin'])
        ->build();

        return $this->redirectToURI($redirect);
    }

    /**
     * Action that gets called when hitting the subscription-button in the event registration form
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Event $event
     */
    public function subscribeAction(?Event $event = null, ?FeUser $user = null, array $dates = []): ResponseInterface
    {
        $context = GeneralUtility::makeInstance(Context::class);
        $userId = $context->getPropertyFromAspect('frontend.user', 'id');
        $isLoggedIn = $context->getPropertyFromAspect('frontend.user', 'isLoggedIn');
        if (!$user && $userId) {
            $user = $this->feUserRepository->findByUid($userId);
        }

        if ($isLoggedIn && (UserUtility::isAdminLoggedIn() || $user->getUid() == $userId)) {
            $GLOBALS['TSFE']->fe_user->setAndSaveSessionData('tx_igruckzuckevent_dates', $dates);

            $this->view->assign('user', $user);
            $this->view->assign('referer', $this->generateReferer($event));
            $this->view->assign('subscriptionOffers', $this->subscriptionOfferRepository->findAll());
        }

        return $this->htmlResponse();
    }


    /**
     * Generates the referer to the show action
     *
     * @param \Ig\IgRuckzuckevent\Domain\Model\Event $event
     * @return string
     */
    private function generateReferer($event)
    {
        if ($event) {
            $this->uriBuilder->reset()
->setCreateAbsoluteUri(true);
            $this->uriBuilder->setArguments([
                'tx_igruckzuckevent_events' => [
                    'controller' => 'Calendar',
                    'action' => 'show',
                    'event' => $event->getUid(),
                ],
            ]);
            return $this->uriBuilder->build();
        }

        return null;
    }

    /**
     * Accept waitlist promotion with token
     *
     * @param string $token
     * @return ResponseInterface
     */
    public function acceptWaitlistPromotionAction(string $token = ''): ResponseInterface
    {
        $success = false;
        $registration = null;
        $errorMessage = '';

        if (empty($token)) {
            $errorMessage = LocalizationUtility::translate('waitlist.promotion.invalid_token', 'IgRuckzuckevent');
        } else {
            // Find registration by token
            $registration = $this->registrationRepository->findOneByWaitlistPromotionToken($token);

            if (!$registration) {
                $errorMessage = LocalizationUtility::translate('waitlist.promotion.not_found', 'IgRuckzuckevent');
            } else {
                // Try to accept the promotion
                if ($this->waitlistService->acceptPromotion($registration)) {
                    $context = GeneralUtility::makeInstance(Context::class);
                    $languageUid = $context->getPropertyFromAspect('language', 'id');
                    $event = $registration->getEvent();

                    $variables = [
                        'registration' => $registration,
                        'event' => $event,
                        'langUid' => $languageUid,
                    ];

                    // Send confirmation email to user
                    if ($registration->getEmail()) {
                        $this->mailService->sendMail(
                            LocalizationUtility::translate('email.user.promotion.accepted.subject', 'IgRuckzuckevent') ?: 'Ihre Teilnahmebestätigung',
                            [$this->settings['mailFrom']],
                            [$registration->getEmail()],
                            'IgRuckzuckevent/Registration/Promotion/Accepted',
                            $variables
                        );
                    }

                    // Send notification to admin
                    $mailTo = $this->settings['mailTo'];
                    if ($event->getRegistrationEmail()) {
                        $mailTo = $event->getRegistrationEmail();
                    }
                    if ($event->getOrganizer() && $event->getOrganizer()->getEmail()) {
                        $mailTo = $event->getOrganizer()->getEmail();
                    }

                    if ($mailTo) {
                        $this->mailService->sendMail(
                            LocalizationUtility::translate('email.admin.promotion.accepted.subject', 'IgRuckzuckevent') ?: 'Warteliste: Teilnahme bestätigt',
                            [$this->settings['mailFrom']],
                            explode(',', (string) $mailTo),
                            'IgRuckzuckevent/Registration/Promotion/AdminAccepted',
                            $variables
                        );
                    }

                    // Persist the changes immediately
                    $persistenceManager = GeneralUtility::makeInstance(PersistenceManager::class);
                    $persistenceManager->persistAll();

                    $success = true;
                } else {
                    $errorMessage = LocalizationUtility::translate('waitlist.promotion.failed', 'IgRuckzuckevent');
                }
            }
        }

        $this->view->assign('success', $success);
        $this->view->assign('registration', $registration);
        $this->view->assign('errorMessage', $errorMessage);

        return $this->htmlResponse();
    }

    /**
     * Decline waitlist promotion with token
     *
     * @param string $token
     * @return ResponseInterface
     */
    public function declineWaitlistPromotionAction(string $token = ''): ResponseInterface
    {
        $success = false;
        $registration = null;
        $errorMessage = '';

        if (empty($token)) {
            $errorMessage = LocalizationUtility::translate('waitlist.promotion.invalid_token', 'IgRuckzuckevent');
        } else {
            // Find registration by token
            $registration = $this->registrationRepository->findOneByWaitlistPromotionToken($token);

            if (!$registration) {
                $errorMessage = LocalizationUtility::translate('waitlist.promotion.not_found', 'IgRuckzuckevent');
            } else {
                // Decline the promotion
                if ($this->waitlistService->declinePromotion($registration)) {
                    $context = GeneralUtility::makeInstance(Context::class);
                    $languageUid = $context->getPropertyFromAspect('language', 'id');
                    $event = $registration->getEvent();

                    $variables = [
                        'registration' => $registration,
                        'event' => $event,
                        'langUid' => $languageUid,
                    ];

                    // Send confirmation email to user
                    if ($registration->getEmail()) {
                        $this->mailService->sendMail(
                            LocalizationUtility::translate('email.user.promotion.declined.subject', 'IgRuckzuckevent') ?: 'Ihre Rückmeldung zur Warteliste',
                            [$this->settings['mailFrom']],
                            [$registration->getEmail()],
                            'IgRuckzuckevent/Registration/Promotion/Declined',
                            $variables
                        );
                    }

                    // Send notification to admin
                    $mailTo = $this->settings['mailTo'];
                    if ($event->getRegistrationEmail()) {
                        $mailTo = $event->getRegistrationEmail();
                    }
                    if ($event->getOrganizer() && $event->getOrganizer()->getEmail()) {
                        $mailTo = $event->getOrganizer()->getEmail();
                    }

                    if ($mailTo) {
                        $this->mailService->sendMail(
                            LocalizationUtility::translate('email.admin.promotion.declined.subject', 'IgRuckzuckevent') ?: 'Warteliste: Teilnahme abgelehnt',
                            [$this->settings['mailFrom']],
                            explode(',', (string) $mailTo),
                            'IgRuckzuckevent/Registration/Promotion/AdminDeclined',
                            $variables
                        );
                    }

                    $success = true;
                } else {
                    $errorMessage = LocalizationUtility::translate('waitlist.promotion.failed', 'IgRuckzuckevent');
                }
            }
        }

        $this->view->assign('success', $success);
        $this->view->assign('registration', $registration);
        $this->view->assign('errorMessage', $errorMessage);

        return $this->htmlResponse();
    }
}
