<?php

namespace Ig\IgRuckzuckevent\Domain\Model;

use DateTime;
use Evoweb\Recaptcha\Validation\RecaptchaValidator;
use Ig\IgRuckzuckevent\Domain\Model\TYPO3\CMS\Extbase\Annotation\Validate;
use TYPO3\CMS\Extbase\Annotation\Validate as AnnotationValidate;

/***
 *
 * This file is part of the "Ruck Zuck Event" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2017 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/
/**
 * The Event model class is representing an entity of the table tx_igruckzuckevent_domain_model_event
 */
class CaptchaEvent extends Event
{
    /**
     * @var string
     */
    #[AnnotationValidate([
        'validator' => 'NotEmpty',
    ])]
    protected $title;

    /**
     * @var string
     */
    #[AnnotationValidate([
        'validator' => 'NotEmpty',
    ])]
    protected $description;

    /**
     * @var string
     */
    #[AnnotationValidate([
        'validator' => 'NotEmpty',
    ])]
    protected $place;

    /**
     * @var DateTime
     */
    #[AnnotationValidate([
        'validator' => 'NotEmpty',
    ])]
    protected $dateFrom;

    /**
     * @var DateTime
     */
    #[AnnotationValidate([
        'validator' => 'NotEmpty',
    ])]
    protected $dateDeadline;

    /**
     * @var string
     */
    #[AnnotationValidate([
        'validator' => 'NotEmpty',
    ])]
    protected $company;

    /**
     * @var string
     */
    #[AnnotationValidate([
        'validator' => 'NotEmpty',
    ])]
    protected $street;

    /**
     * @var string
     */
    #[AnnotationValidate([
        'validator' => 'NotEmpty',
    ])]
    protected $zip;

    /**
     * @var string
     */
    #[AnnotationValidate([
        'validator' => 'NotEmpty',
    ])]
    protected $city;

    /**
     * @var string
     */
    #[AnnotationValidate([
        'validator' => 'EmailAddress',
    ])]
    #[AnnotationValidate([
        'validator' => 'NotEmpty',
    ])]
    protected $email;

    /**
     * @var string
     */
    #[AnnotationValidate([
        'validator' => 'NotEmpty',
    ])]
    protected $url;

    /**
     * @var string
     */
    #[AnnotationValidate([
        'validator' => 'EmailAddress',
    ])]
    #[AnnotationValidate([
        'validator' => 'NotEmpty',
    ])]
    protected $adminEmail;

    /**
     * @var string
     */
    #[AnnotationValidate([
        'validator' => RecaptchaValidator::class,
    ])]
    protected $captcha;

    public function getCaptcha()
    {
        return $this->captcha;
    }

    public function setCaptcha($captcha): void
    {
        $this->captcha = $captcha;
    }
}
