<?php

namespace Ig\IgRuckzuckevent\Domain\Model;

use Ig\IgRuckzuckevent\Domain\Model\TYPO3\CMS\Extbase\Annotation\ORM\Cascade;
use Ig\IgRuckzuckevent\Domain\Repository\RegistrationRepository;
use Ig\IgRuckzuckevent\Domain\Repository\SubscriptionRepository;
use Ig\IgRuckzuckevent\Utility\JsonUtility;
use Internetgalerie\IgFrontendUser\Domain\Model\FrontendUser;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Annotation\ORM\Cascade as ORMCascade;
use TYPO3\CMS\Extbase\Persistence\ObjectStorage;

/***
 *
 * This file is part of the "Ruck Zuck Event" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2017 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/

/**
 * The FeUser model represents the frontend user
 */
class FeUser extends FrontendUser
{
    /**
     * @var ObjectStorage<Subscription> $subscriptions
     */
    #[ORMCascade([
        'value' => 'remove',
    ])] // remove
    protected $subscriptions = null;

    /**
     * @var ObjectStorage<Registration> $registrations
     */
    #[ORMCascade([
        'value' => 'remove',
    ])] // remove
    protected $registrations = null;

    /**
     * disable
     *
     * @var boolean
     */
    protected $disable = true;

    /**
     * deleted
     *
     * @var boolean
     */
    protected $deleted = false;

    /**
     * hash
     *
     * @var string
     */
    protected $hash = '';

    
    public function __construct()
    {
        //Do not remove the next line: It would break the functionality
        $this -> initStorageObjects();
        parent::__construct();
    }

    /**
     * Returns the subscriptions
     *
     * @return ObjectStorage<Subscription> $subscriptions
     */
    public function getSubscriptions()
    {
        return $this->subscriptions;
    }

    public function getActiveSubscriptions()
    {
        $subscriptionRepository = GeneralUtility::makeInstance(SubscriptionRepository::class);
        return $subscriptionRepository->findActiveSubscriptions($this);
    }

    /**
     * Sets the subscriptions
     *
     * @param ObjectStorage<Subscription> $subscriptions
     */
    public function setSubscriptions(ObjectStorage $subscriptions): void
    {
        $this->subscriptions = $subscriptions;
    }

    /**
     * Adds an subscription
     */
    public function addSubscription(Subscription $subscription): void
    {
        $this -> subscriptions -> attach($subscription);
    }

    /**
     * Removes an subscription
     */
    public function removeSubscription(Subscription $subscription): void
    {
        $this -> subscriptions -> detach($subscription);
    }

    /**
     * Returns the registrations
     *
     * @return array
     */
    public function getRegistrations()
    {
        return $this->registrations;
    }

    public function getRegistrationsSorted()
    {
        $registrations = $this->getRegistrations()
->toArray();

        usort($registrations, fn ($a, $b) => $a->getEvent()->getDateTimeFrom() > $b->getEvent()->getDateTimeFrom());

        return $registrations;
    }

    /**
     * Returns the registrations
     *
     * @return ObjectStorage<Registration> $registrations
     */
    public function getNextRegistrations()
    {
        $registrationRepository = GeneralUtility::makeInstance(RegistrationRepository::class);
        return $registrationRepository->findNextRegistrations($this);
    }

    /**
     * Returns the registrations
     *
     * @return ObjectStorage<Registration> $registrations
     */
    public function getPassedRegistrations()
    {
        $registrationRepository = GeneralUtility::makeInstance(RegistrationRepository::class);
        return $registrationRepository->findPassedRegistrations($this);
    }


    /**
     * Sets the registrations
     *
     * @param ObjectStorage<Registration> $registrations
     */
    public function setRegistrations(ObjectStorage $registrations): void
    {
        $this->registrations = $registrations;
    }

    /**
     * Adds an registration
     */
    public function addRegistration(Registration $registration): void
    {
        $this -> registrations -> attach($registration);
    }

    /**
     * Removes an registration
     */
    public function removeRegistration(Registration $registration): void
    {
        $this -> registrations -> detach($registration);
    }

    /**
     * Returns the disable
     *
     * @return bool
     */
    public function getDisable()
    {
        return $this->disable;
    }

    /**
     * Sets the disable
     *
     * @param boolean $disable
     */
    public function setDisable($disable): void
    {
        $this->disable = $disable;
    }

    /**
     * Returns the deleted
     *
     * @return bool
     */
    public function getDeleted()
    {
        return $this->deleted;
    }

    /**
     * Sets the deleted
     *
     * @param boolean $deleted
     */
    public function setDeleted($deleted): void
    {
        $this->deleted = $deleted;
    }

    /**
     * Returns the hash
     *
     * @return bool
     */
    public function getHash()
    {
        return $this->hash;
    }

    /**
     * Sets the hash
     *
     * @param boolean $hash
     */
    public function setHash($hash): void
    {
        $this->hash = $hash;
    }

    /**
     * Returns the amount of subscriptions left
     *
     * @return integer
     */
    public function getSubscriptionTotal()
    {
        $subscriptionTotal = 0;

        foreach ($this->subscriptions as $subscription) {
            $subscriptionTotal += $subscription->getDaysLeft();
        }

        return $subscriptionTotal;
    }

    public function getJson()
    {
        return JsonUtility::getJsonForProperties($this->_getProperties());
    }

    /**
     * Initializes all ObjectStorage properties
     */
    protected function initStorageObjects()
    {
        $this -> registrations = new ObjectStorage();
        $this -> subscriptions = new ObjectStorage();
    }
}
