<?php

namespace Ig\IgRuckzuckevent\Domain\Model;

use Ig\IgRuckzuckevent\Utility\JsonUtility;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

/***
 *
 * This file is part of the "Ruck Zuck Event" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2019 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/

class FormField extends AbstractEntity
{
    /**
     * sorting
     *
     * @var integer
     */
    protected int $sorting = 0;
 
    /**
     * name
     *
     * @var string
     */
    protected $name = '';

    /**
     * title
     *
     * @var string
     */
    protected $title = '';

    /**
     * type
     *
     * @var string
     */
    protected $type = 0;

    /**
     * required
     *
     * @var bool
     */
    protected $required = false;

    /**
     * options
     *
     * @var string
     */
    protected $options = '';
    
    /**
     * description
     *
     * @var string
     */
    protected $description = '';

    /**
     * depends_on
     *
     * @var string
     */
    protected $dependsOn = '';

    /**
     * depends_value
     *
     * @var string
     */
    protected $dependsValue = '';

    /**
     * depends_operator
     *
     * @var string
     */
    protected $dependsOperator = '';

    /**
     * Returns the sorting
     */
    public function getSorting(): int
    {
        return $this->sorting;
    }
 
    /**
     * Sets the sorting
     */
    public function setSorting(?int $sorting): void
    {
        $this->sorting = $sorting;
    }

    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     *
     * @param string $name
     */
    public function setName($name): void
    {
        $this->name = $name;
    }

    /**
     * Returns the title
     *
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Sets the title
     *
     * @param string $title
     */
    public function setTitle($title): void
    {
        $this->title = $title;
    }

    /**
     * Returns the type
     *
     * @return string
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Sets the type
     *
     * @param string $type
     */
    public function setType($type): void
    {
        $this->type = $type;
    }

    /**
     * Returns the required
     *
     * @return bool
     */
    public function getRequired()
    {
        return $this->required;
    }

    /**
     * Sets the required
     *
     * @param bool $required
     */
    public function setRequired($required): void
    {
        $this->required = $required;
    }

    /**
     * Returns the boolean state of required
     *
     * @return bool
     */
    public function isRequired()
    {
        return $this->required;
    }

    /**
     * Returns the options
     *
     * @return array
     */
    public function getOptionsArray(): array
    {
        return explode("\n", $this->options);
    }
    public function getOptions(): string
    {
        return $this->options;
    }

    /**
     * Sets the options
     */
    public function setOptions(string $options): void
    {
        $this->options = $options;
    }
    public function setOptionsArray(array $options): void
    {
        $this->options = implode("\n", $options);
    }

    /**
     * Returns the description
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Sets the description
     *
     * @param string $description
     */
    public function setDescription($description): void
    {
        $this->description = $description;
    }

    /**
     * Returns the dependsOn
     *
     * @return string
     */
    public function getDependsOn()
    {
        return $this->dependsOn;
    }

    /**
     * Sets the dependsOn
     *
     * @param string $dependsOn
     */
    public function setDependsOn($dependsOn): void
    {
        $this->dependsOn = $dependsOn;
    }

    /**
     * Returns the dependsValue
     *
     * @return string
     */
    public function getDependsValue()
    {
        return $this->dependsValue;
    }

    /**
     * Sets the dependsValue
     *
     * @param string $dependsValue
     */
    public function setDependsValue($dependsValue): void
    {
        $this->dependsValue = $dependsValue;
    }

    /**
     * Returns the dependsOperator
     *
     * @return string
     */
    public function getDependsOperator()
    {
        return $this->dependsOperator;
    }

    /**
     * Sets the dependsOperator
     *
     * @param string $dependsOperator
     */
    public function setDependsOperator($dependsOperator): void
    {
        $this->dependsOperator = $dependsOperator;
    }

    public function getJson()
    {
        return JsonUtility::getJsonForProperties($this->_getProperties());
    }
}
