<?php

namespace Ig\IgRuckzuckevent\Domain\Model;

use Ig\IgRuckzuckevent\Domain\Model\TYPO3\CMS\Extbase\Annotation\Validate;
use Ig\IgRuckzuckevent\Utility\JsonUtility;
use TYPO3\CMS\Extbase\Annotation\Validate as AnnotationValidate;
use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

/***
 *
 * This file is part of the "Ruck Zuck Event" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2018 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/


class Workarea extends AbstractEntity
{
    /**
     * name
     *
     * @var string
     */
    #[AnnotationValidate([
        'validator' => 'NotEmpty',
    ])]
    protected $name = '';

    /**
     * Returns the name
     *
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Sets the name
     *
     * @param string $name
     */
    public function setName($name): void
    {
        $this->name = $name;
    }

    public function getJson()
    {
        return JsonUtility::getJsonForProperties($this->_getProperties());
    }
}
