<?php

namespace Ig\IgRuckzuckevent\Domain\Validator;

use Ig\IgRuckzuckevent\Domain\Model\Subscription;
use TYPO3\CMS\Extbase\Validation\Validator\AbstractValidator;

/***
 *
 * This file is part of the "Ruck Zuck Event" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2017 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/

class SubscriptionCountValidator extends AbstractValidator
{
    /**
     * Checks if enought subscriptions
     *
     * @param Subscription $subscription
     */
    public function isValid($subscription): void
    {
        $dates = ($GLOBALS['TYPO3_REQUEST']->getParsedBody()['tx_igruckzuckevent_events'] ?? null)['dates'];
        
        if (!$dates) {
            $dates = ($GLOBALS['TYPO3_REQUEST']->getParsedBody()['tx_igruckzuckevent_management'] ?? null)['dates'];
        }

        if (!$dates) {
            $dates = ($GLOBALS['TYPO3_REQUEST']->getParsedBody()['tx_igruckzuckevent_eventscalendar'] ?? null)['dates'];
        }

        if (!$dates) {
            $this->addError('No date chosen', 1496759333);
        }

        if ($subscription == null) {
            $this->addError('No subscription chosen', 1496759123);
        }
        
        if ($dates && count($dates) > $subscription->getDaysLeft()) {
            $this->addError('Too many dates chosen', 1496759216);
        }
    }
}
