<?php

namespace Ig\IgRuckzuckevent\Event;

use Ig\IgRuckzuckevent\Domain\Model\Registration;
use Psr\EventDispatcher\StoppableEventInterface;
use TYPO3\CMS\Extbase\Mvc\RequestInterface;

final class RegistrationEvent implements StoppableEventInterface
{
    private array $data = [];
 
    public function __construct(
        private readonly Registration $registration,
        private readonly RequestInterface $request,
        private array $default = []
    ) {
    }
 
    public function getData(): array
    {
        return $this->data;
    }
 
    public function getRegistration(): Registration
    {
        return $this->registration;
    }

    public function getRequest(): RequestInterface
    {
        return $this->request;
    }
 
    public function setData(array $data): void
    {
        $this->data = $data;
    }
    public function isPropagationStopped(): bool
    {
        return false;
        // return !empty($this->data);
    }
    

    public function getDefault(): array
    {
        return $this->default;
    }

    public function setDefault($default): void
    {
        $this->default = $default;
    }
}
