<?php

namespace Ig\IgRuckzuckevent\Hook;

use Ig\IgRuckzuckevent\Utility\CacheUtility;
use TYPO3\CMS\Core\DataHandling\DataHandler;
use TYPO3\CMS\Core\Utility\GeneralUtility;

class ClearCacheDataHandlerHook
{
    protected string $eventTable = 'tx_igruckzuckevent_domain_model_event';

    /**
     * called after updating of entries
     * clear cache of all updated entries
     */
    public function processDatamap_afterDatabaseOperations(
        $status,
        $table,
        $id,
        array $fieldArray,
        DataHandler $dataHandler
    ): void {
        if ($table === $this->eventTable && is_numeric($id)) {
            $cacheUtility = GeneralUtility::makeInstance(CacheUtility::class);
            $cacheUtility->flushByEventId($id);
        }
    }

    /**
     * called after deleting of entries
     * clear cache of all deleted entries
     */
    public function processCmdmap_postProcess($command, $table, $id, $value, DataHandler $dataHandler): void
    {
        if ($command !== 'delete' || $table !== $this->eventTable) {
            return;
        }
        $cacheUtility = GeneralUtility::makeInstance(CacheUtility::class);
        $cacheUtility->flushByEventId($id);
    }
}
