<?php

namespace Ig\IgRuckzuckevent\Property\TypeConverter;

use TYPO3\CMS\Core\SingletonInterface;
use TYPO3\CMS\Extbase\Property\PropertyMappingConfigurationInterface;
use TYPO3\CMS\Extbase\Property\TypeConverter\AbstractTypeConverter;

/***
 *
 * This file is part of the "Ruck Zuck Event" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2017 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/
/**
 * The TimestampConverter converts a string like 12:00 to the timestamp at 1.1.1970, so we can use it only as time
 */
class TimestampConverter extends AbstractTypeConverter implements SingletonInterface
{
    protected $sourceTypes = ['string'];
    protected $targetType = 'integer';
    protected $priority = 10;
    
    public function convertFrom(
        $source,
        $targetType,
        array $convertedChildProperties = [],
        PropertyMappingConfigurationInterface $configuration = null
    ) {
        $t = explode(':', (string) $source);
        if (count($t) > 1) {
            return $t[0] * 3600 + $t[1] * 60;
        }
        return 0;
        
        //      $time = (strtotime($source) % 86400);
        //return $time;
    }
}
