<?php

use TYPO3\CMS\Core\Information\Typo3Version;
use TYPO3\CMS\Core\Utility\GeneralUtility;

$typo3Version = GeneralUtility::makeInstance(Typo3Version::class);
$navigationComponent = $typo3Version->getMajorVersion() > 12 ? '@internetgalerie/igruckzuckevent/tree/category-tree-element' : '@internetgalerie/igruckzuckevent/category-tree/category-tree-element';
return [
    'igruckzuckevent_main' => [
        'extensionName' => 'IgRuckzuckevent',
        'position' => ['after' => 'file'],
        'access' => 'user',
        'icon' => 'EXT:ig_ruckzuckevent/Resources/Public/Icons/folder-module-igruckzuckevent.svg',
        'labels' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_nav.xlf',
        'moduleData' => [
            'ig_backend_helpers_module' => true,
        ],
    ],
    'igruckzuckevent_events' => [
        'parent' => 'igruckzuckevent_main',
        'extensionName' => 'IgRuckzuckevent',
        'position' => ['top'],
        'access' => 'user',
        'icon' => 'EXT:ig_backend_helpers/Resources/Public/Icons/module-db-entry.svg',
        'labels' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_nav_event.xlf',
        'path' => '/igruckzuckevent/events',
        'navigationComponent' => $navigationComponent,
        'controllerActions' => [
            \Ig\IgRuckzuckevent\Controller\Backend\EventBackendController::class => ['index', 'calendar', 'listParticipants', 'waitlist', 'exportRegistrations', 'checkRegistrations', 'deleteRegistration', 'deleteRegistrations', 'deleteEvent', 'promoteWaitlist', 'propagateWaitlist', 'cancelWaitlistPromotion'],
        ],
        'moduleData' => [
            'ig_backend_helpers_module' => true,
        ],
    ],
    'igruckzuckevent_categories' => [
        'parent' => 'igruckzuckevent_main',
        'extensionName' => 'IgRuckzuckevent',
        'position' => ['top'],
        'access' => 'user',
        'icon' => 'EXT:ig_backend_helpers/Resources/Public/Icons/module-db-entry.svg',
        'labels' => 'LLL:EXT:ig_ruckzuckevent/Resources/Private/Language/locallang_nav_category.xlf',
        'path' => '/igruckzuckevent/categories',
        'navigationComponent' => $navigationComponent,
        'controllerActions' => [
            \Ig\IgRuckzuckevent\Controller\Backend\CategoryBackendController::class => ['index'],
        ],
        'moduleData' => [
            'ig_backend_helpers_module' => true,
        ],
    ],
];
