<?php

namespace Ig\IgRuckzuckevent\Command;

use Ig\IgRuckzuckevent\Domain\Repository\EventRepository;
use Ig\IgRuckzuckevent\Domain\Repository\RegistrationRepository;
use TYPO3\CMS\Core\Mail\MailMessage;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManager;
use TYPO3\CMS\Extbase\Configuration\ConfigurationManagerInterface;
use TYPO3\CMS\Extbase\Mvc\Controller\CommandController;
use TYPO3\CMS\Fluid\View\StandaloneView;

class ReminderCommandController extends CommandController
{
    /**
     * The repository for events
     *
     * @var EventRepository
     */
    protected $eventRepository = null;
    /**
     * The repository for registrations
     *
     * @var RegistrationRepository
     */
    protected $registrationRepository = null;


    /**
     * @var ConfigurationManager
     */
    protected $configurationManager = null;

    public function injectEventRepository(EventRepository $eventRepository): void
    {
        $this->eventRepository = $eventRepository;
    }

    public function injectRegistrationRepository(RegistrationRepository $registrationRepository): void
    {
        $this->registrationRepository = $registrationRepository;
    }

    public function injectConfigurationManager(ConfigurationManagerInterface $configurationManager): void
    {
        $this->configurationManager = $configurationManager;
        $this->configurationManager->setConfiguration([
            'extensionName' => 'IgRuckzuckevent',
        ]);
    }


    public function reminderCommand(): void
    {
        $events = $this->eventRepository->findForReminder();

        $settings = $this->configurationManager->getConfiguration(
            ConfigurationManagerInterface::CONFIGURATION_TYPE_SETTINGS
        );

        foreach ($events as $event) {
            $registrations = $event->getRegistrations();

            foreach ($registrations as $registration) {
                if (!$registration->getReminded()) {
                    // Setup fluid template for the confirmation mail
                    if (GeneralUtility::validEmail($registration->getEmail())) {
                        $mailView = $this -> createFluidTemplate('Registration/ReminderMail.html');
                        $mailView -> assign('registration', $registration);

                        // Create mail object and send mail to email address the user who registered to the event entered
                        $mail = GeneralUtility::makeInstance(MailMessage::class);
                        $mail -> setSubject('Erinnerung zu Ihrer Kursanmeldung')
                        -> setFrom([$settings['mailFrom']])
                        -> setTo([$registration -> getEmail()])
                        -> text($mailView -> render())
                        -> send();
                    }

                    $registration->setReminded(true);
                    $this->registrationRepository->update($registration);
                }
            }
        }
    }

    /**
     * Create a fluid template
     *
     * @param string $name
     *
     * @return StandaloneView
     */
    private function createFluidTemplate($name)
    {
        $extbaseFrameworkConfiguration = $this -> configurationManager -> getConfiguration(
            ConfigurationManagerInterface::CONFIGURATION_TYPE_FRAMEWORK
        );

        $view = GeneralUtility::makeInstance(StandaloneView::class);
        $view -> setLayoutRootPaths($extbaseFrameworkConfiguration['view']['layoutRootPaths']);
        $view -> setTemplateRootPaths($extbaseFrameworkConfiguration['view']['templateRootPaths']);
        $view -> setPartialRootPaths($extbaseFrameworkConfiguration['view']['partialRootPaths']);
        $view -> setTemplate($name);

        return $view;
    }
}
