<?php

namespace Ig\IgRuckzuckevent\Controller;

use DateInterval;
use DatePeriod;
use DateTime;
use GeorgRinger\News\Pagination\QueryResultPaginator;
use GeorgRinger\NumberedPagination\NumberedPagination;
use Ig\IgRuckzuckevent\Controller\TYPO3\CMS\Extbase\Annotation\IgnoreValidation;
use Ig\IgRuckzuckevent\Controller\TYPO3\CMS\Extbase\Annotation\Validate;
use Ig\IgRuckzuckevent\Domain\Model\Event;
use Internetgalerie\IgRecurrenceDate\Domain\Model\Eventgroup;
use Internetgalerie\IgRecurrenceDate\Domain\Repository\EventgroupRepository;
use Ig\IgRuckzuckevent\Domain\Repository\EventRepository;
use Ig\IgRuckzuckevent\Domain\Repository\FeUserRepository;
use Ig\IgRuckzuckevent\Domain\Validator\EventFormValidator;
use Ig\IgRuckzuckevent\Utility\UserUtility;
use Internetgalerie\IgDynval\Controller\DynamicValidationActionController;
use Internetgalerie\IgDynval\Validation\Validator\DynamicValidator;
use Internetgalerie\IgFrontendUser\Domain\Repository\FrontendUserGroupRepository;
use PhpOffice\PhpSpreadsheet\Cell\DataType;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Context\Context;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Annotation\IgnoreValidation as AnnotationIgnoreValidation;
use TYPO3\CMS\Extbase\Annotation\Validate as AnnotationValidate;
use TYPO3\CMS\Extbase\Mvc\Controller\ActionController;
use TYPO3\CMS\Extbase\Property\TypeConverter\DateTimeConverter;

/**
 * The CalendarController handles all actions directly related to Events.
 */
class CalendarController extends ActionController
{
    use DynamicValidationActionController;

    /**
     * The repository for events
     *
     * @var EventRepository
     */
    protected $eventRepository = null;

    /**
     * The repository for events
     *
     * @var EventgroupRepository
     */
    protected $eventgroupRepository = null;

    /**
     * feUserRepository
     *
     * @var FeUserRepository
     */
    protected $feUserRepository = null;

    /**
     * feUserGroupRepository
     *
     * @var FrontendUserGroupRepository
     */
    protected $feUserGroupRepository = null;

    public function injectEventRepository(EventRepository $eventRepository): void
    {
        $this->eventRepository = $eventRepository;
    }

    public function injectEventgroupRepository(EventgroupRepository $eventgroupRepository): void
    {
        $this->eventgroupRepository = $eventgroupRepository;
    }

    public function injectFeUserRepository(FeUserRepository $feUserRepository): void
    {
        $this->feUserRepository = $feUserRepository;
    }

    public function injectFeUserGroupRepository(FrontendUserGroupRepository $feUserGroupRepository): void
    {
        $this->feUserGroupRepository = $feUserGroupRepository;
    }


    /**
     * Initialize the current action
     */
    public function initializeAction(): void
    {
        if (isset($this->arguments['event']) || isset($this->arguments['newEvent'])) {
            if (isset($this->arguments['event'])) {
                $event = $this->arguments['event'];
            } else {
                $event = $this->arguments['newEvent'];
            }

            // Set date format of date fields
            foreach (['dateFrom', 'dateTo', 'dateDeadline'] as $dateField) {
                $event->getPropertyMappingConfiguration()
                    ->forProperty($dateField)
                    ->setTypeConverterOption(
                        DateTimeConverter::class,
                        DateTimeConverter::CONFIGURATION_DATE_FORMAT,
                        'd.m.Y'
                    );
            }

            // Set time format of time fields
            /*foreach (['timeFrom', 'timeTo', 'timeDeadline'] as $timeField) {
              $event->getPropertyMappingConfiguration()
              ->forProperty($timeField)
              ->setTypeConverter(GeneralUtility::makeInstance('Ig\\IgRuckzuckevent\\Property\\TypeConverter\\TimestampConverter'));
              }*/
        }
    }

    /**
     * List all events with possibility to sort and filter them
     */
    public function listAction(): ResponseInterface
    {
        $eventgroups = $this->eventgroupRepository->findAll();
        $eventsPerDayAndTime = [];
        $message = '';

        if ($this->request->hasArgument('message')) {
            $success = $this->request->getArgument('message');

            if ($success == 'success') {
                $message = 'Sie haben sich erfolgreich an einem Kurs angemeldet. Prüfen Sie bitte Ihr E-Mail-Konto.';
            }
        }
        /*		echo('a');
                $e=$this->eventRepository->findByUid(2434); // error bei nested level 1000 /etc/php/7.0/mods-available/xdebug.ini
                $e=$this->eventRepository->findByUid(8024); // geht
                echo('b');
                exit(0);
        */

        $dDate = new DateTime('2020-05-03');
        for ($d = 1;$d <= 7;$d++) {
            $eventsPerDayAndTime[$d] = [
                'entries' => [],
                'day' => [
                    'nr' => $d,
                    'text' => $dDate->format('Y-m-d'),
                ],
            ];
        }
        foreach ($eventgroups as $eventgroup) {
            /*
              if($eventgroup->getUid() == 18  && 0) {
              //$event = $eventgroup->getCurrentEvent();
              continue;
              }
             */
            $event = $eventgroup->getCurrentEvent();
            if ($event) {
                if (!isset($eventsPerDayAndTime[$event->getIsoDay()])) {
                    $eventsPerDayAndTime[$event->getIsoDay()] = [];
                }
                if (!isset($eventsPerDayAndTime[$event->getIsoDay()][$event->getDaytime()]) || !is_array(
                    $eventsPerDayAndTime[$event->getIsoDay()][$event->getDaytime()]
                )) {
                    $eventsPerDayAndTime[$event->getIsoDay()][$event->getDaytime()] = [];
                }
                // ist event schon vorhanden?
                $eventSchonVorhanden = false;
                foreach ($eventsPerDayAndTime[$event->getIsoDay()][$event->getDaytime()] as $eNr => $e) {
                    if ($e->getTitle() == $event->getTitle() && $e->getSubTitle() == $event->getSubTitle() && $e->getTimeFrom() === $event->getTimeFrom() && $e->getTimeTo() === $event->getTimeTo()) {
                        $eventSchonVorhanden = true;
                        break;
                    }
                }
                if (!$eventSchonVorhanden) {
                    $eventsPerDayAndTime[$event->getIsoDay()][$event->getDaytime()][] = $event;
                }
                usort(
                    $eventsPerDayAndTime[$event->getIsoDay()][$event->getDaytime()],
                    fn ($a, $b) => strtotime((string) $a->getTimeFrom()) > strtotime((string) $b->getTimeFrom())
                );
            }
        }

        $morningMax = 1;
        $afternoonMax = 1;
        $eveMax = 1;
        foreach ($eventsPerDayAndTime as &$eventsPerTime) {
            $morningMax = max($morningMax, empty($eventsPerTime['morning']) ? 0 : count($eventsPerTime['morning']));
            $afternoonMax = max(
                $afternoonMax,
                empty($eventsPerTime['afternoon']) ? 0 : count($eventsPerTime['afternoon'])
            );
            $eveMax = max($eveMax, empty($eventsPerTime['eve']) ? 0 : count($eventsPerTime['eve']));
        }
        for ($d = 1;$d <= 7;$d++) {
            if (empty($eventsPerDayAndTime[$d]['morning']) && empty($eventsPerDayAndTime[$d]['afternoon']) && empty($eventsPerDayAndTime[$d]['eve'])) {
                unset($eventsPerDayAndTime[$d]);
            }
        }
        foreach ($eventsPerDayAndTime as &$day) {
            if (is_array($day)) {
                $startDayMorning = empty($day['morning']) ? 0 : count($day['morning']);
                for ($i = $startDayMorning; $i < $morningMax; $i++) {
                    $day['morning'][] = 'empty';
                }
                $startDayAfternoon = empty($day['afternoon']) ? 0 : count($day['afternoon']);
                for ($i = $startDayAfternoon; $i < $afternoonMax; $i++) {
                    $day['afternoon'][] = 'empty';
                }
                $startDayEve = empty($day['eve']) ? 0 : count($day['eve']);
                for ($i = $startDayEve; $i < $eveMax; $i++) {
                    $day['eve'][] = 'empty';
                }
            }
        }

        if ($this->request->hasArgument('managementUser') && UserUtility::isAdminLoggedIn()) {
            $this->view->assign('managementUser', $this->request->getArgument('managementUser'));
        } else {
            $this->view->assign('managementUser', '');
        }

        // Vorhandene Wochentage abfuellen
        $days = ['Sonntag', 'Montag', 'Dienstag', 'Mittwoch', 'Donnerstag', 'Freitag', 'Samstag', 'Sonntag'];
        $weekdayHeaders = [];
        foreach (array_keys($eventsPerDayAndTime) as $dayNr) {
            $weekdayHeaders[] = [
                'nr' => $dayNr,
                'text' => $days[$dayNr],
            ];
        }

        /*
          echo($dayNr .'<br />');
          sort($eventsPerDayAndTime);
          exit(0);
         */
        $this->view->assign('weekdayHeaders', $weekdayHeaders);

        $this->view->assign('events', $eventsPerDayAndTime);
        $this->view->assign('message', $message);

        return $this->htmlResponse();
    }

    /**
     * List all events with possibility to sort and filter them.
     * This action is for organizers, so all the edit, create and delete links are visible here.
     */
    public function organizerListAction(): ResponseInterface
    {
        $context = GeneralUtility::makeInstance(Context::class);
        $userId = $context->getPropertyFromAspect('frontend.user', 'id');
        $this->eventRepository->setShowOnlyActiveEntries(false);
        $events = $this->eventRepository->findBySearchAndSorting($this->getSearch(), $this->getSorting());
        $eventgroups = $this->eventgroupRepository->findCurrent();
        $eventgroupOptions = [];
        foreach ($eventgroups as $eg) {
            if ($eg->getEventsCount() > 0) {
                $eventgroupOptions[] = $eg;
            } //->getTitle();
        }

        $currentPage = $this->request->hasArgument('currentPage') ? (int) $this->request->getArgument(
            'currentPage'
        ) : 1;
        $paginator = new QueryResultPaginator($events, $currentPage, 20);
        $pagination = new NumberedPagination($paginator, 10); // zweiter Argument: maximal Anzahl Links

        $this->view->assign('pagination', [
            'paginator' => $paginator,
            'pagination' => $pagination,
        ]);

        $this->view->assign('events', $events);
        $this->view->assign('eventgroupOptions', $eventgroupOptions);
        $this->view->assign('eventgroups', $eventgroups);
        $this->view->assign('organizer', $this->feUserRepository->findByUid($userId));

        return $this->htmlResponse();
    }

    /**
     * Shows the detail view of an event
     */
    public function showAction(Event $event): ResponseInterface
    {
        $eventsWithSameTitle = $this->eventRepository->findForShow($event);
        $dates = $GLOBALS['TSFE']->fe_user->getKey('ses', 'tx_igruckzuckevent_dates');
        $GLOBALS['TSFE']->fe_user->removeSessionData();

        $context = GeneralUtility::makeInstance(Context::class);
        $userId = $context->getPropertyFromAspect('frontend.user', 'id');
        $isLoggedIn = $context->getPropertyFromAspect('frontend.user', 'isLoggedIn');
        $user = null;
        
        if ($this->request->hasArgument('managementUser') && UserUtility::isAdminLoggedIn()) {
            $user = $this->feUserRepository->findByUid($this->request->getArgument('managementUser'));
            $this->view->assign('managementUser', $this->request->getArgument('managementUser'));
        } elseif ($isLoggedIn) {
            $user = $this->feUserRepository->findByUid($userId);
        }

        if ($this->request->hasArgument('dateErrors')) {
            $this->view->assign('dateErrors', $this->request->getArgument('dateErrors'));
        }

        $subscribeLink = $this->uriBuilder->reset()
                       ->uriFor('subscribe', null, 'Registration');

        /*->setArguments([
          'tx_igruckzuckevent_events' => [
          'controller' => 'Registration',
          'action' => 'subscribe'
          ]
          ])
          ->setUseCacheHash(false)
          ->build();
        */


        $eventsByWeekdays = [];
        foreach ($eventsWithSameTitle as $eventWithSameTitle) {
            $day = $eventWithSameTitle->getIsoDay();
            $time = $eventWithSameTitle->getTimeFrom();

            if (!isset($eventsByWeekdays[$day]) || !is_array($eventsByWeekdays[$day])) {
                $eventsByWeekdays[$day] = [];
            }
            if (!isset($eventsByWeekdays[$day][$time]) || !is_array($eventsByWeekdays[$day][$time])) {
                $eventsByWeekdays[$day][$time] = [];
            }
            if (!in_array($eventWithSameTitle, $eventsByWeekdays[$day][$time])) {
                $eventsByWeekdays[$day][$time][] = $eventWithSameTitle;
            }
        }

        $this->view->assign('event', $event);
        $this->view->assign('eventsByWeekdays', $eventsByWeekdays);
        $this->view->assign('dates', $dates);
        $this->view->assign('user', $user);
        $this->view->assign('subscribeLink', $subscribeLink);
        $this->view->assign(
            'selectedSubscription',
            ($this->request->getParsedBody()['tx_igruckzuckevent_events'] ?? null)['subscription'] ?? null
        );

        return $this->htmlResponse();
    }

    /**
     * Shows form to create a new event
     */
    public function newAction(): ResponseInterface
    {
        $context = GeneralUtility::makeInstance(Context::class);
        $userId = $context->getPropertyFromAspect('frontend.user', 'id');
        $this->view->assign('organizer', $this->feUserRepository->findByUid($userId));

        return $this->htmlResponse();
    }

    /**
     * Action called when the Form in the new-Action is submitted.
     * We validate the event with our EventFormValidator, handle the file uploads and finally persist the event in the database.
     *
     * @param boolean $repeat
     * @param int $repeatMode
     * @param string $repeatTill
     */
    #[AnnotationValidate([
        'validator' => DynamicValidator::class,
        'param' => 'newEvent',
    ])]
    #[AnnotationValidate([
        'validator' => EventFormValidator::class,
        'param' => 'newEvent',
    ])]
    public function createAction(Event $newEvent, $repeat = false, $repeatMode = 1, $repeatTill = ''): ResponseInterface
    {
        //$this->handleUpload($newEvent);

        if ($repeatTill != '') {
            $repeatTill = new DateTime($repeatTill);
        }

        $eventgroup = GeneralUtility::makeInstance(Eventgroup::class);
        $eventgroup->setFirstDate(clone $newEvent->getDateTimeFrom());
        $eventgroup->setRepeated($repeat);

        if ($repeat && $repeatTill != '') {
            $eventgroup->setRepeatTill($repeatTill);
            $repeatTill->modify('+1 day');
        } elseif ($repeat && $repeatTill == '') {
            $repeatTill = clone $newEvent->getDateTimeFrom();
            $repeatTill->modify('+5 years');
        }

        if ($repeat) {
            $period = new DatePeriod($newEvent->getDateFrom(), new DateInterval('P' . $repeatMode . 'W'), $repeatTill);

            $i = 0; // We only use the period for the loop, the actual dates are calculated by the events date + $i weeks
            foreach ($period as $date) {
                $eventInGroup = clone $newEvent;
                $dateFrom = clone $eventInGroup->getDateFrom();

                $dateFrom->modify('+' . ($i++ * $repeatMode) . ' week');
                $eventInGroup->setDateFrom($dateFrom);
                $eventInGroup->setEventgroup($eventgroup);

                $this->eventRepository->add($eventInGroup);

                //$eventgroup->addEvent($eventInGroup);
            }
        } else {
            $this->eventRepository->add($newEvent);

            $newEvent->setEventgroup($eventgroup);
            //$eventgroup->addEvent($newEvent);
        }
        $this->eventgroupRepository->add($eventgroup);

        return $this->redirect('organizerList');
    }

    /**
     * Shows the edit form of an event
     */
    #[AnnotationIgnoreValidation([])] // $event
    public function editAction(Event $event): ResponseInterface
    {
        $this->view->assign('event', $event);

        return $this->htmlResponse();
    }

    /**
     * This action is called when the edit form of an event is submitted.
     * It persists the changes made to the event to the database.
     * The event is validated by our EventFormValidator.
     *
     * @param int $saveMode
     */
    #[AnnotationValidate([
        'validator' => DynamicValidator::class,
        'param' => 'event',
    ])]
    #[AnnotationValidate([
        'validator' => EventFormValidator::class,
        'param' => 'event',
    ])]
    public function updateAction(Event $event, $saveMode = 1): ResponseInterface
    {
        $arguments = $this->request->getArguments();
        $eventgroup = $event->getEventgroup();

        if ($saveMode == 3) { // Save changes for single event and put it in new eventgroup
            // Remove images to delete
            if (isset($arguments['imagesToDelete']) && !empty($arguments['imagesToDelete'])) {
                $imagesToDelete = [];
                foreach ($event->getImages() as $image) {
                    if (in_array($image->getUid(), $arguments['imagesToDelete'])) {
                        $imagesToDelete[] = $image;
                    }
                }
                foreach ($imagesToDelete as $imageToDelete) {
                    $event->removeImage($imageToDelete);
                }
            }
            //$this->handleUpload($event);

            if ($eventgroup->getEvents()->count() > 1) {
                $newEventgroup = GeneralUtility::makeInstance(Eventgroup::class);
                $newEventgroup->setFirstDate(clone $event->getDateTimeFrom());
                $newEventgroup->setRepeated(false);

                $event->setEventgroup($newEventgroup);
                //$newEventgroup->addEvent($event);
                $this->eventgroupRepository->add($newEventgroup);
            }

            $this->eventRepository->update($event);
        } elseif ($saveMode == 2) { // Save changes for the following events and put them in new eventgroup
            $newEventgroup = GeneralUtility::makeInstance(Eventgroup::class);
            $newEventgroup->setFirstDate(clone $eventgroup->getFirstDate());
            $newEventgroup->setRepeated($eventgroup->getRepeated());
            $newEventgroup->setRepeatTill($eventgroup->getRepeatTill());
            $events = [];

            foreach ($eventgroup->getEvents() as $eventInGroup) {
                if ($eventInGroup->getDateTimeFrom() >= $event->getDateTimeFrom()) {
                    $eventInGroup->setActive($event->getActive());
                    $eventInGroup->setTitle($event->getTitle());
                    $eventInGroup->setSubtitle($event->getSubtitle());
                    $eventInGroup->setDescription($event->getDescription());
                    $eventInGroup->setTimeFrom($event->getTimeFrom());
                    $eventInGroup->setTimeTo($event->getTimeTo());
                    $eventInGroup->setMaxRegistrations($event->getMaxRegistrations());
                    $eventInGroup->setEventgroup($newEventgroup);
                    $this->eventRepository->update($eventInGroup);
                    $events[] = $eventInGroup;
                }
            }

            /*foreach($events as $eventInGroup) {
              $newEventgroup->addEvent($eventInGroup);
              $eventgroup->removeEvent($eventInGroup);
              $this->eventRepository->update($eventInGroup);
              }*/

            $this->eventgroupRepository->add($newEventgroup);
            $this->eventgroupRepository->update($eventgroup);
        } else { // Save changes for all the events in eventgroup
            foreach ($eventgroup->getEvents() as $eventInGroup) {
                $eventInGroup->setActive($event->getActive());
                $eventInGroup->setTitle($event->getTitle());
                $eventInGroup->setSubtitle($event->getSubtitle());
                $eventInGroup->setDescription($event->getDescription());
                $eventInGroup->setTimeFrom($event->getTimeFrom());
                $eventInGroup->setTimeTo($event->getTimeTo());
                $eventInGroup->setMaxRegistrations($event->getMaxRegistrations());

                $this->eventRepository->update($eventInGroup);
            }
        }

        return $this->redirect('organizerList');
    }

    /**
     * Deletes an event.
     *
     * @param string $deleteMode
     */
    public function deleteAction(Event $event, $deleteMode = null): ResponseInterface
    {
        switch ($deleteMode) {
            case 'all':
                $eventgroup = $event->getEventgroup();
                foreach ($eventgroup->getEvents() as $eventInGroup) {
                    if ($eventInGroup->getRegistrations()->count() == 0) {
                        $this->eventRepository->remove($eventInGroup);
                    }
                }
                return $this->redirect('organizerList');
                break;
            case 'following':
                $eventgroup = $event->getEventgroup();
                foreach ($eventgroup->getEvents() as $eventInGroup) {
                    if ($eventInGroup->getRegistrations()->count() == 0 && $eventInGroup->getDateTimeFrom() >= $event->getDateTimeFrom()) {
                        $this->eventRepository->remove($eventInGroup);
                    }
                }
                return $this->redirect('organizerList');
                break;
            case 'single':
                if ($event->getRegistrations()->count() == 0) {
                    $this->eventRepository->remove($event);
                }
                return $this->redirect('organizerList');
                break;
            default:
                $this->view->assign('event', $event);
                break;
        }

        return $this->htmlResponse();
    }

    /**
     * Exports the reservations of an event to an XLSX-File openable in Microsoft Excel
     */
    public function exportAction(Event $event): ResponseInterface
    {
        //$phpExcelService = GeneralUtility::makeInstanceService('phpexcel');
        $phpExcel = new Spreadsheet();
        $phpExcel->setActiveSheetIndex(0);

        $rowNr = 1;
        $colNr = 1;
        // First row: Output event title and registration count
        $phpExcel->getActiveSheet()
->setCellValue(
    [$colNr++, $rowNr],
    $event->getTitle() . ': ' . $event->getDateFrom()->format('d.m.Y') . ' ' . $event->getTimeFromText()
);

        // Output registration count
        $phpExcel->getActiveSheet()
->setCellValue([$colNr++, $rowNr], 'Anzahl Anmeldungen: ' . $event->getRegistrations()->count());

        // Set first row bold
        $phpExcel->getActiveSheet()
->getStyle('A1:C1')
->getFont()
->setBold(true);


        // Leerzeile
        $rowNr++;

        // Zeile mit Überschriften
        //$phpExcel->getActiveSheet()->SetCellValue('A2', 'Anrede');
        $rowNr++;
        $colNr = 1;
        $phpExcel->getActiveSheet()
->setCellValue([$colNr++, $rowNr], 'Name');
        $phpExcel->getActiveSheet()
->setCellValue([$colNr++, $rowNr], 'Vorname');
        $phpExcel->getActiveSheet()
->setCellValue([$colNr++, $rowNr], 'E-Mail-Adresse');
        $phpExcel->getActiveSheet()
->setCellValue([$colNr++, $rowNr], 'Telefon');
        $phpExcel->getActiveSheet()
->setCellValue([$colNr++, $rowNr], 'Gebucht am');

        // Set second row bold
        $phpExcel->getActiveSheet()
->getStyle('A' . $rowNr . ':E' . $rowNr)->getFont()->setBold(true);


        // For each registration of the event set the values of the attributes to the according column
        foreach ($event->getRegistrations() as $registration) {
            $rowNr++;
            $colNr = 1;
            $feUser = $registration->getFeUser();
            //            $phpExcel->getActiveSheet()->SetCellValue('A' . $i, $feUser->getGender() == 'm' ? 'Herr' : 'Frau');
            $phpExcel->getActiveSheet()
->setCellValue([$colNr++, $rowNr], $feUser->getLastName());
            $phpExcel->getActiveSheet()
->setCellValue([$colNr++, $rowNr], $feUser->getFirstName());
            $phpExcel->getActiveSheet()
->setCellValue([$colNr++, $rowNr], $feUser->getUsername());
            //setCellValueExplicitByColumnAndRow
            $phpExcel->getActiveSheet()
->setCellValueExplicit([$colNr++, $rowNr], $feUser->getTelephone(), DataType::TYPE_STRING);
            $phpExcel->getActiveSheet()
->setCellValue([$colNr++, $rowNr], $registration->getCrdate()->format('d.m.Y H:i'));
        }

        // Set column width automatically according to their content
        foreach (range('A', 'E') as $column) {
            $phpExcel->getActiveSheet()
->getColumnDimension($column)
->setAutoSize(true);
        }

        // Temporary filename
        $fileName = 'typo3temp/event-' . $event->getUid() . '-' . time() . '.xlsx';

        // Create an Excel Writer
        $excelWriter = new Xlsx($phpExcel); // Create an Excel Writer
        // Save to temporary file
        $excelWriter->save($fileName);

        // Set headers
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . str_replace('typo3temp/', '', $fileName) . '"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
        // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
        // always modified
        header('Cache-Control: cache, must-revalidate');
        // HTTP/1.1
        header('Pragma: public');
        // HTTP/1.0
        header('Content-Length: ' . filesize($fileName));
        //header('Pragma: no-cache');

        echo file_get_contents($fileName);
        // Output file

        unlink($fileName);
        // Delete temporary file

        exit();

        return $this->htmlResponse();
    }

    /**
     * Get the search array
     *
     * @return array
     */
    private function getSearch()
    {
        if ($this->request) {
            $arguments = $this->request->getArguments();
        } else {
            $arguments = [];
        }

        if (isset($arguments['search'])) {
            $search = $arguments['search'];
        } else {
            $search = [];
        }

        $this->view->assign('search', $search);

        return $search;
    }

    /**
     * Get the sorting array for the repository
     *
     * @return array
     */
    private function getSorting()
    {
        if ($this->request) {
            $arguments = $this->request->getArguments();
        } else {
            $arguments = [];
        }

        if (isset($arguments['sorting'])) {
            $sorting = $arguments['sorting'];
        } else {
            // If no sorting was requested, use default sorting
            $sorting = [];
            $sorting['field'] = 'dateFrom';
            $sorting['direction']['dateFrom'] = 'ASC';
            $sorting['direction']['title'] = 'ASC';
        }

        // This is the sorting array given to the repository
        $sortingArr = [
            $sorting['field'] => $sorting['direction'][$sorting['field']],
        ];
        if ($sorting['field'] == 'dateFrom') {
            $sortingArr['timeFrom'] = $sorting['direction'][$sorting['field']];
        }

        // If the current sorting direction of the current sorting field is ASC, switch it  to DESC, but all others stay at ASC
        // Else switch all sorting directions to ASC
        if ($sorting['direction'][$sorting['field']] == 'ASC') {
            foreach ($sorting['direction'] as &$sortingDirection) {
                $sortingDirection = 'ASC';
            }

            $sorting['direction'][$sorting['field']] = 'DESC';
        } else {
            foreach ($sorting['direction'] as &$sortingDirection) {
                $sortingDirection = 'ASC';
            }
        }

        $this->view->assign('sorting', $sorting);

        return $sortingArr;
    }
}
