<?php

namespace Ig\IgRuckzuckevent\Controller;

use Ig\IgRuckzuckevent\Controller\TYPO3\CMS\Extbase\Annotation\IgnoreValidation;
use Ig\IgRuckzuckevent\Controller\TYPO3\CMS\Extbase\Annotation\Validate;
use Ig\IgRuckzuckevent\Domain\Model\Category;
use Ig\IgRuckzuckevent\Domain\Repository\CategoryRepository;
use Internetgalerie\IgDynval\Controller\DynamicValidationActionController;
use Internetgalerie\IgDynval\Validation\Validator\DynamicValidator;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Extbase\Annotation\IgnoreValidation as AnnotationIgnoreValidation;
use TYPO3\CMS\Extbase\Annotation\Validate as AnnotationValidate;

/**
 * The EventController handles all actions directly related to Events.
 */
class CategoryController extends \Internetgalerie\IgDatapoolFe\Controller\ActionController
{
    use DynamicValidationActionController;

    /**
     * The repository for categories
     *
     * @var CategoryRepository
     */
    protected $categoryRepository = null;

    public function injectCategoryRepository(CategoryRepository $categoryRepository): void
    {
        $this->categoryRepository = $categoryRepository;
    }

    public function initializeView($view): void
    {
        $this->view->assign('controller', 'Category');
        $this->view->assign('pageUid', $this->request->getAttribute('frontend.page.information')?->getId());
    }

    public function listAction(): ResponseInterface
    {
        $categories = $this->categoryRepository->findAll();
        $this->view->assign('categories', $categories);

        return $this->htmlResponse();
    }

    /**
     * New action
     */
    public function newAction(): ResponseInterface
    {
        $categories = $this->categoryRepository->findAll();
        $this->view->assign('categories', $categories);

        return $this->htmlResponse();
    }

    /**
     * Create action
     */
    #[AnnotationValidate([
        'validator' => DynamicValidator::class,
        'param' => 'newCategory',
    ])]
    public function createAction(Category $newCategory): ResponseInterface
    {
        $this->categoryRepository->add($newCategory);
        return $this->redirect('list');
    }

    /**
     * Edit action
     */
    #[AnnotationIgnoreValidation([])] // $category
    public function editAction(Category $category): ResponseInterface
    {
        $categories = $this->categoryRepository->findAll();
        $this->view->assign('categories', $categories);
        $this->view->assign('category', $category);

        return $this->htmlResponse();
    }

    /**
     * Update action
     */
    #[AnnotationValidate([
        'validator' => DynamicValidator::class,
        'param' => 'category',
    ])]
    public function updateAction(Category $category): ResponseInterface
    {
        $this->categoryRepository->update($category);
        return $this->redirect('list');
    }

    /**
     * Delete action
     */
    public function deleteAction(Category $category): ResponseInterface
    {
        $this->categoryRepository->remove($category);
        return $this->redirect('list');
    }
}
