<?php

namespace Ig\IgRuckzuckevent\Domain\Model;

use TYPO3\CMS\Extbase\DomainObject\AbstractEntity;

/**
 * The Registration model represents entities of the table tx_igruckzuckevent_domain_model_registration.
 */
class Person extends AbstractEntity
{
    /**
     * The gender of the registrant
     */
    protected string $gender = '';

    /**
     * The name of the registratant
     */
    protected string $lastName = '';

    /**
     * First name of the registrant
     */
    protected string $firstName = '';

    protected string $email = '';

    /**
     * The event the registration is for
     *
     * @var Registration
     */
    protected $registration = null;

    public function getGender(): string
    {
        return $this->gender;
    }

    public function setGender(string $gender): void
    {
        $this->gender = $gender;
    }

    public function getLastName(): string
    {
        return $this->lastName;
    }

    public function setLastName(string $lastName): void
    {
        $this->lastName = $lastName;
    }

    public function getFirstName(): string
    {
        return $this->firstName;
    }

    public function setFirstName(string $firstName): void
    {
        $this->firstName = $firstName;
    }


    public function getEmail(): string
    {
        return $this->email;
    }

    public function setEmail(string $email): void
    {
        $this->email = $email;
    }

    /**
     * Returns the registration
     *
     * @return Registration
     */
    public function getRegistration()
    {
        return $this->registration;
    }

    /**
     * Sets the registration
     */
    public function setRegistration(Registration $registration): void
    {
        $this->registration = $registration;
    }
}
