<?php

namespace Ig\IgRuckzuckevent\Domain\Validator;

use DateTime;
use Ig\IgRuckzuckevent\Domain\Model\Event;
use TYPO3\CMS\Extbase\Validation\Validator\AbstractValidator;

/***
 *
 * This file is part of the "Ruck Zuck Event" Extension for TYPO3 CMS.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 *  (c) 2017 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 ***/

/**
 * The EventFormValidator validates the input of the forms for creating and editing events and throws errors if inputs are wrong.
 * The actual error messages in german are stored in the Resources/Private/Language/locallang.xlf-File.
 * We are outputting them in fluid by property path and error code.
 */
class EventFormValidator extends AbstractValidator
{
    /**
     * Checks if the event is valid
     *
     * @param Event $event
     */
    public function isValid($event): void
    {
        // Check the form fields because the default validators don't work
        /*if (!$event -> getDateFrom()) {
            $this -> addError('No date from set', 1491209334);
        }*/

        $today = new DateTime();
        $today->setTime(0, 0, 0);
        /*if ($event -> getDateFrom() && $event -> getDateFrom() < $today) {
            $this -> addError('From date before today', 1491209702);
        }*/
        if ($event->getDateDeadline() && $event->getDateFrom() && $event->getDateDeadline() > $event->getDateFrom()) {
            $this->addError('Date from before date deadline', 1491205654);
        }
        /*if ($event -> getTitle() == '') {
            $this -> addError('No title set', 1491209332);
        }
        if ($event -> getTeaser() == '') {
            $this -> addError('No teaser set', 1491209331);
        }
        if ($event -> getDescription() == '') {
            $this -> addError('No description set', 1491209333);
        }
        if (!$event -> getPlace()) {
            $this -> addError('No place set', 1491209338);
        }
        if (!$event -> getDateFrom()) {
            $this -> addError('No date from set', 1491209334);
        }
        if (!$event -> getDateDeadline()) {
            $this -> addError('No deadline set', 1491209336);
        }
        if (!$event -> getCompany()) {
            $this -> addError('No company set', 1491209337);
        }
        if (!$event -> getZip()) {
            $this -> addError('No zip set', 1491209339);
        }
        if (!$event -> getCity()) {
            $this -> addError('No city set', 1491209340);
        }
        if (!$event -> getEmail()) {
            $this -> addError('No email set', 1491209341);
        } else if(!GeneralUtility::validEmail($event -> getEmail())) {
            $this -> addError('Invalid email set', 1491209344);
        }
        if (!$event -> getUrl()) {
            $this -> addError('No website set', 1491209342);
        }
        if (!$event -> getAdminEmail()) {
            $this -> addError('No admin email set', 1491209343);
        } else if(!GeneralUtility::validEmail($event -> getAdminEmail())) {
            $this -> addError('Invalid admin email set', 1491209345);
        }*/
        /*if (!$event -> getTimeFrom()) {
            $this -> addError('No time from set', 1491209335);
        }*/
        /*if ($event -> getDateTimeFrom() && $event -> getDateTimeFrom() < new \DateTime()) {
            $this -> addError('From date before today', 1491209702);
        }*/
        /*if ($event -> getDateTimeFrom() && $event -> getDateTimeFrom() < new \DateTime()) {
            $this -> addError('End time lower than start time and no end date set', 1491209652);
        }*/

        /*if ($event -> getDateFrom() && $event -> getDateFrom() < $event -> getDateDeadline()) {
            $this -> addError('To date before deadline', 1491209706);
        }*/

        /*if ($event -> getDateDeadline() && !$event -> getTimeDeadline()) {
            $this -> addError('No time for the deadline set', 1491209657);
        } elseif ($event -> getTimeDeadline() && !$event -> getDateDeadline()) {
            $this -> addError('No date for the deadline set', 1491209658);
        }*/

        /*if ($event -> getMinRegistrations() && $event -> getMaxRegistrations()) {
            if ($event -> getMinRegistrations() > $event -> getMaxRegistrations()) {
                $this -> addError('Min registrations greater than max registrations', 1491209659);
            }
        }*/
    }
}
