<?php
declare(strict_types = 1);

use Ig\IgRuckzuckevent\Domain\Model\FileReference;
use Ig\IgRuckzuckevent\Domain\Model\FeUser;
use Ig\IgRuckzuckevent\Domain\Model\Subscription;
use Ig\IgRuckzuckevent\Domain\Model\CaptchaEvent;
use Ig\IgRuckzuckevent\Domain\Model\Registration;

return [
    FileReference::class => [
        'tableName' => 'sys_file_reference',
        'properties' => [
            'originalFileIdentifier' => [
                'fieldName' => 'uid_local',
            ],
        ],
    ],
    FeUser::class => [
        'tableName' => 'fe_users',
        'properties' => [
            'subscriptions' => [
                'fieldName' => 'subscriptions',
            ],
            'registrations' => [
                'fieldName' => 'registrations',
            ],
            'disable' => [
                'fieldName' => 'disable',
            ],
            'deleted' => [
                'fieldName' => 'deleted',
            ],
        ],
    ],
    Subscription::class => [
        'tableName' => 'tx_igruckzuckevent_domain_model_subscription',
        'properties' => [
            'crdate' => [
                'fieldName' => 'crdate',
            ],
        ],
    ],
    CaptchaEvent::class => [
        'tableName' => 'tx_igruckzuckevent_domain_model_event',
    ],
    Registration::class => [
        'tableName' => 'tx_igruckzuckevent_domain_model_registration',
        'properties' => [
            'crdate' => [
                'fieldName' => 'crdate',
            ],
        ],
    ],
];
