// TODO: Rewrite to module...
window.addEventListener("load", (event) => {
    function getCurrentEvent(e) {
        var event;
        for(var i = 0; i < e.events.length; i++) {
            event = e.events[i];
            if(!event) {
                continue;
            }
            if(event.eventId && event.id) {
                break;
            }
        }

        return event;
    }

    function isEventEmpty(event) {
        return !event || !event.eventId || !event.id;
    }

    function editEvent(event) {
        if(isEventEmpty(event)) {
            return;
        }

        
        if(event.editUri) {
            location.href = event.editUri;
        }
    }
    function deleteEvent(event) {
        if(isEventEmpty(event) || !event.deleteUri || !event.deleteMessage) {
            return;
        }
        
        if(confirm(event.deleteMessage)) {
            location.href = event.deleteUri;
        }
    }
    const calendarElement = document.querySelector('.calendar');
    var dataSource = JSON.parse(calendarElement.dataset.source);
    var startYear = calendarElement.dataset.startYear;
    for(var i = 0; i < dataSource.length; i++) {
        dataSource[i]['startDate'] = new Date(dataSource[i]['startDate']);
        dataSource[i]['endDate'] = new Date(dataSource[i]['endDate']);
    }

    // TODO: Fetch dataSource dynamically
    const calendar = new Calendar(calendarElement, {
        language: 'de',
        dataSource: dataSource,
        startYear: startYear,
        style: 'background',
        roundRangeLimits: true,
        enableContextMenu: true,
        contextMenuItems:[
            {
                text: 'Bearbeiten',
                click: editEvent
            },
            {
                text: 'Löschen',
                click: deleteEvent
            }
        ],
	mouseOnDay: function(e) {
            var event = getCurrentEvent(e);
	    if (event) {
		e.target.setAttribute('title', event.title);
	    }
	},
        customDayRenderer: function (element, date) {
            dataSource.forEach(event => {
                if (date.toDateString() === event.startDate.toDateString()) {
                    element.classList.add('event-start-day');
                }
            });
        }
	/*
	mouseOutDay: function(e) {
	    var event = getCurrentEvent(e);
            if (event) {
		e.target.removeAttribute('title');
	    }
	}
*/
	/*        clickDay: function(e) {
            var event = getCurrentEvent(e);
            deleteEvent(event);
        }
		*/
    });
});