<?php
namespace Internetgalerie\IgSimplesubscribe\Domain\Model;

/***************************************************************
 *
 *  Copyright notice
 *
 *  (c) 2016 Simon Häsler <sh@internetgalerie.ch>, Internetgalerie AG
 *
 *  All rights reserved
 *
 *  This script is part of the TYPO3 project. The TYPO3 project is
 *  free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  The GNU General Public License can be found at
 *  http://www.gnu.org/copyleft/gpl.html.
 *
 *  This script is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  This copyright notice MUST APPEAR in all copies of the script!
 ***************************************************************/

/**
 * Address
 */
class AddressChanges extends \TYPO3\CMS\Extbase\DomainObject\AbstractEntity
{
    /**
     * @var string
     */
    protected $state = '';

    /**
     * @var int
     */
    protected $userid = '';

    /**
     * @var string
     */
    protected $oldData = '';

    /**
     * @var string
     */
    protected $newData = '';

    /**
     * @var int
     */
    protected $tstamp = 0;

    /**
     * @var int
     */
    protected $crdate = 0;

    /**
     * @var array
     */
    protected $user = '';

    /**
     * @var array
     */
    protected $old = '';

    /**
     * Returns the state
     *
     * @return string $state
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Sets the state
     *
     * @param string $state
     *
     * @return void
     */
    public function setState($state)
    {
        $this->state = $state;
    }

    /**
     * Returns the userid
     *
     * @return int $userid
     */
    public function getUserid()
    {
        return $this->userid;
    }

    /**
     * Sets the userid
     *
     * @param int $userid
     *
     * @return void
     */
    public function setUserid($userid)
    {
        $this->userid = $userid;
    }

    /**
     * Returns the oldData
     *
     * @return string $oldData
     */
    public function getOldData()
    {
        return $this->oldData;
    }

    /**
     * Sets the oldData
     *
     * @param string $oldData
     *
     * @return void
     */
    public function setOldData($oldData)
    {
        $this->oldData = $oldData;
    }

    /**
     * Returns the newData
     *
     * @return string $newData
     */
    public function getNewData()
    {
        return $this->newData;
    }

    /**
     * Sets the newData
     *
     * @param string $newData
     *
     * @return void
     */
    public function setNewData($newData)
    {
        $this->newData = $newData;
    }

    /**
     * Returns the tstamp
     *
     * @return int $tstamp
     */
    public function getTstamp()
    {
        return $this->tstamp;
    }

    /**
     * Sets the tstamp
     *
     * @param int $tstamp
     *
     * @return void
     */
    public function setTstamp($tstamp)
    {
        $this->tstamp = $tstamp;
    }

    /**
     * Returns the crdate
     *
     * @return int $crdate
     */
    public function getCrdate()
    {
        return $this->crdate;
    }

    /**
     * Sets the crdate
     *
     * @param int $crdate
     *
     * @return void
     */
    public function setCrdate($crdate)
    {
        $this->crdate = $crdate;
    }

    /**
     * Returns the user
     *
     * @return array $user
     */
    public function getUser()
    {
        return $this->user;
    }

    /**
     * Sets the user
     *
     * @param array $user
     *
     * @return void
     */
    public function setUser(array $user)
    {
        $this->user = $user;
    }

    /**
     * Returns the old
     *
     * @return array $old
     */
    public function getOld()
    {
        return $this->old;
    }

    /**
     * Sets the old
     *
     * @param array $old
     *
     * @return void
     */
    public function setOld(array $old)
    {
        $this->old = $old;
    }
}
