<?php
namespace Internetgalerie\IgSimplesubscribe\Domain\Model;

use Internetgalerie\IgFrontendUser\Domain\Model\FrontendUser as IgFrontendUser;

/***************************************************************
 * Copyright notice
 *
 * (c) 2011-17 Sebastian Fischer <typo3@evoweb.de>
 * All rights reserved
 *
 * This script is part of the TYPO3 project. The TYPO3 project is
 * free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * The GNU General Public License can be found at
 * http://www.gnu.org/copyleft/gpl.html.
 *
 * This script is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * This copyright notice MUST APPEAR in all copies of the script!
 ***************************************************************/

/**
 * An extended frontend user with more attributes
 */
class FrontendUser extends IgFrontendUser
{
    /**
     * If the account is disabled or not
     *
     * @var boolean
     */
    protected $disable;

    /**
     * Mailhash for activation by email
     *
     * @var string
     */
    protected $mailhash;

    /**
     * Date on which the account was activated
     *
     * @var \DateTime|NULL
     */
    protected $activatedOn;

    /**
     *  virtual not stored in database
     *
     * @var string
     */
    protected $captcha;

    /**
     *  virtual not stored in database
     *
     * @var string
     */
    protected $passwordRepeat;

    /**
     * linkHash
     *
     * @var string
     */
    protected $linkHash = '';

    /**
     * accepted
     *
     * @var boolean
     */
    protected $accepted = false;

    /**
     * ipAddress
     *
     * @var string
     */
    protected $ipAddress = '';

    /**
     * browser
     *
     * @var string
     */
    protected $browser = '';

    /**
     *  virtual not stored in database
     *
     * @var string
     */
    protected $emailRepeat;

    /**
     * Pseudonym
     *
     * @var string
     */
    protected $pseudonym;

    /**
     * Gender 1 or 2 for mr or mrs
     *
     * @var integer
     */
    protected $gender;

    /**
     * Date of birth
     *
     * @var \DateTime
     */
    protected $dateOfBirth;

    /**
     * Day of date of birth
     *
     * @var integer
     */
    protected $dateOfBirthDay;

    /**
     * Month of date of birth
     *
     * @var integer
     */
    protected $dateOfBirthMonth;

    /**
     * Year of date of birth
     *
     * @var integer
     */
    protected $dateOfBirthYear;

    /**
     * Language
     *
     * @var string
     */
    protected $language;

    /**
     * Code of state/province
     *
     * @var string
     */
    protected $zone;

    /**
     * Timezone
     *
     * @var float
     */
    protected $timezone;

    /**
     * Daylight saving time
     *
     * @var boolean
     */
    protected $daylight;

    /**
     * Country with static info table code
     *
     * @var string
     */
    protected $staticInfoCountry;

    /**
     * Number of mobilephone
     *
     * @var string
     */
    protected $mobilephone;

    /**
     * General terms and conditions accepted flag
     *
     * @var boolean
     */
    protected $gtc;

    /**
     * Privacy agreement accepted flag
     *
     * @var boolean
     */
    protected $privacy;

    /**
     * Status
     *
     * @var integer
     */
    protected $status = 0;

    /**
     * wether the user register by invitation
     *
     * @var boolean
     */
    protected $byInvitation;

    /**
     * comment of user
     *
     * @var string
     */
    protected $comments = '';

    /**
     * if Dmail should be enabled
     *
     * @var boolean
     */
    protected $moduleSysDmailNewsletter;

    /**
     * if emails should be send as HTML or plain text
     *
     * @var boolean
     */
    protected $moduleSysDmailHtml;

    /**
     * selected dmail categories
     *
     * @var array
     */
    protected $moduleSysDmailCategory;

    /**
     * new email address before edit
     *
     * @var string
     */
    protected $emailNew;

    /**
     * email address of invitee
     *
     * @var string
     */
    protected $invitationEmail;

    /**
     * Initializes the date of birth if related values
     * are set by request to argument mapping
     *
     * @return void
     */
    public function prepareDateOfBirth()
    {
        if ($this->dateOfBirthDay !== null && $this->dateOfBirthMonth !== null && $this->dateOfBirthYear !== null) {
            if ($this->dateOfBirth === null) {
                $this->dateOfBirth = new \DateTime();
            }
            $this->dateOfBirth->setDate($this->dateOfBirthYear, $this->dateOfBirthMonth, $this->dateOfBirthDay);
        } else {
            $this->dateOfBirth = null;
        }
    }

    /**
     * Getter for disable
     *
     * @return boolean
     */
    public function getDisable()
    {
        return ($this->disable ? true : false);
    }

    public function isHidden()
    {
        return $this->getDisable();
    }

    /**
     * Setter for disable
     *
     * @param boolean $disable
     * @return void
     */
    public function setDisable($disable): void
    {
        $this->disable = ($disable ? true : false);
    }
    /**
     * Setter for disable
     *
     * @param boolean $disable
     * @return void
     */
    public function setHidden($disable): void
    {
        $this->setDisable($disable);
    }

    /**
     * Getter for mailhash
     *
     * @return string
     * @deprecated
     */
    public function getMailhash()
    {
        return $this->mailhash;
    }

    /**
     * Setter for mailhash
     *
     * @param string $mailhash
     * @return void
     * @deprecated
     */
    public function setMailhash($mailhash): void
    {
        $this->mailhash = trim($mailhash);
    }

    /**
     * Getter for activatedOn
     *
     * @return \DateTime|NULL
     */
    public function getActivatedOn()
    {
        return $this->activatedOn;
    }

    /**
     * Setter for activatedOn
     *
     * @param \DateTime|NULL $activatedOn
     * @return void
     */
    public function setActivatedOn(\DateTime $activatedOn = null): void
    {
        $this->activatedOn = $activatedOn;
    }

    /**
     * Getter for captcha
     *
     * @return string
     */
    public function getCaptcha()
    {
        return $this->captcha;
    }

    /**
     * Setter for captcha
     *
     * @param string $captcha
     * @return void
     */
    public function setCaptcha($captcha): void
    {
        $this->captcha = trim($captcha);
    }

    /**
     * Returns the linkHash
     *
     * @return string $linkHash
     */
    public function getLinkHash()
    {
        return $this->linkHash;
    }

    /**
     * Sets the linkHash
     *
     * @param string $linkHash
     * @return void
     */
    public function setLinkHash($linkHash): void
    {
        $this->linkHash = $linkHash;
    }

    /**
     * Returns the accepted
     *
     * @return string $accepted
     */
    public function getAccepted()
    {
        return $this->accepted;
    }

    /**
     * Sets the accepted
     *
     * @param string $accepted
     * @return void
     */
    public function setAccepted($accepted): void
    {
        $this->accepted = $accepted;
    }

    /**
     * Returns the ipAddress
     *
     * @return string $ipAddress
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }

    /**
     * Sets the ipAddress
     *
     * @param string $ipAddress
     * @return void
     */
    public function setIpAddress($ipAddress): void
    {
        $this->ipAddress = $ipAddress;
    }

    /**
     * Returns the browser
     *
     * @return string $browser
     */
    public function getBrowser()
    {
        return $this->browser;
    }

    /**
     * Sets the browser
     *
     * @param string $browser
     * @return void
     */
    public function setBrowser($browser): void
    {
        $this->browser = $browser;
    }

    /**
     * Getter for passwordRepeat
     *
     * @return string
     */
    public function getPasswordRepeat()
    {
        return $this->passwordRepeat;
    }

    /**
     * Setter for passwordRepeat
     *
     * @param string $passwordRepeat
     * @return void
     */
    public function setPasswordRepeat($passwordRepeat): void
    {
        $this->passwordRepeat = trim($passwordRepeat);
    }

    /**
     * Getter for emailRepeat
     *
     * @return string
     */
    public function getEmailRepeat()
    {
        return $this->emailRepeat;
    }

    /**
     * Setter for emailRepeat
     *
     * @param string $emailRepeat
     * @return void
     */
    public function setEmailRepeat($emailRepeat): void
    {
        $this->emailRepeat = trim($emailRepeat);
    }

    /**
     * Remove an image
     *
     * @return void
     */
    public function removeImage()
    {
        $this->image = null;
    }

    /**
     * Setter for title
     *
     * @param string $title
     * @return void
     */
    public function setTitle($title): void
    {
        if ($title == 'none') {
            $title = '';
        }
        $this->title = $title;
    }

    /**
     * Getter for pseudonym
     *
     * @return string
     */
    public function getPseudonym()
    {
        return $this->pseudonym;
    }

    /**
     * Setter for pseudonym
     *
     * @param string $pseudonym
     * @return void
     */
    public function setPseudonym($pseudonym): void
    {
        $this->pseudonym = $pseudonym;
    }

    /**
     * Getter for gender
     *
     * @return integer
     */
    public function getGender()
    {
        return $this->gender;
    }

    /**
     * Setter for gender
     *
     * @param integer $gender
     * @return void
     */
    public function setGender($gender): void
    {
        $this->gender = $gender;
    }

    /**
     * Getter for dateOfBirth
     *
     * @return \DateTime|NULL
     */
    public function getDateOfBirth()
    {
        return $this->dateOfBirth;
    }

    /**
     * Setter for dateOfBirth
     *
     * @param \DateTime|NULL $dateOfBirth
     * @return void
     */
    public function setDateOfBirth(\DateTime $dateOfBirth = null): void
    {
        $this->dateOfBirth = $dateOfBirth;
    }

    /**
     * Getter for day of dateOfBirth
     *
     * @return integer
     */
    public function getDateOfBirthDay()
    {
        $result = null;

        if ($this->dateOfBirth instanceof \DateTime) {
            $result = $this->dateOfBirth->format('j');
        }

        return $result;
    }

    /**
     * Setter for day of dateOfBirth
     *
     * @param integer $day
     * @return void
     */
    public function setDateOfBirthDay($day): void
    {
        $this->dateOfBirthDay = $day;
        $this->prepareDateOfBirth();
    }

    /**
     * Getter for month of dateOfBirth
     *
     * @return integer
     */
    public function getDateOfBirthMonth()
    {
        $result = null;

        if ($this->dateOfBirth instanceof \DateTime) {
            $result = $this->dateOfBirth->format('n');
        }

        return $result;
    }

    /**
     * Setter for month of dateOfBirth
     *
     * @param integer $month
     * @return void
     */
    public function setDateOfBirthMonth($month): void
    {
        $this->dateOfBirthMonth = $month;
        $this->prepareDateOfBirth();
    }

    /**
     * Getter for year of dateOfBirth
     *
     * @return integer
     */
    public function getDateOfBirthYear()
    {
        $result = null;

        if ($this->dateOfBirth instanceof \DateTime) {
            $result = $this->dateOfBirth->format('Y');
        }

        return $result;
    }

    /**
     * Setter for month of dateOfBirth
     *
     * @param integer $year
     * @return void
     */
    public function setDateOfBirthYear($year): void
    {
        $this->dateOfBirthYear = $year;
        $this->prepareDateOfBirth();
    }

    /**
     * Getter for mobilphone
     *
     * @return string
     */
    public function getMobilephone()
    {
        return $this->mobilephone;
    }

    /**
     * Setter for mobilphone
     *
     * @param string $mobilephone
     * @return void
     */
    public function setMobilephone($mobilephone): void
    {
        $this->mobilephone = $mobilephone;
    }

    /**
     * Getter for zone
     *
     * @return string
     */
    public function getZone()
    {
        return $this->zone;
    }

    /**
     * Setter for zone
     *
     * @param string $zone
     * @return void
     */
    public function setZone($zone): void
    {
        $this->zone = $zone;
    }

    /**
     * Getter for timezone
     *
     * @return float
     */
    public function getTimezone()
    {
        return floor($this->timezone) != $this->timezone ?
        $this->timezone * 10 :
        $this->timezone;
    }

    /**
     * Setter for timezone
     *
     * @param float $timezone
     * @return void
     */
    public function setTimezone($timezone): void
    {
        $this->timezone = ($timezone > 14 || $timezone < -12 ?
            $timezone / 10 :
            $timezone);
    }

    /**
     * Getter for daylight
     *
     * @return boolean
     */
    public function getDaylight()
    {
        return $this->daylight ?
        true :
        false;
    }

    /**
     * Setter for daylight
     *
     * @param boolean $daylight
     * @return void
     */
    public function setDaylight($daylight): void
    {
        $this->daylight = ($daylight ?
            true :
            false);
    }

    /**
     * Getter for static info cpuntry
     *
     * @return string
     */
    public function getStaticInfoCountry()
    {
        return $this->staticInfoCountry;
    }

    /**
     * Setter got static info country
     *
     * @param string $staticInfoCountry
     * @return void
     */
    public function setStaticInfoCountry($staticInfoCountry): void
    {
        $this->staticInfoCountry = $staticInfoCountry;
    }

    /**
     * Getter for gtc
     *
     * @return boolean
     */
    public function getGtc()
    {
        return $this->gtc ?
        true :
        false;
    }

    /**
     * Setter for gtc
     *
     * @param boolean $gtc
     * @return void
     */
    public function setGtc($gtc): void
    {
        $this->gtc = ($gtc ?
            true :
            false);
    }

    /**
     * Getter for privacy agreement flag
     *
     * @return boolean
     */
    public function getPrivacy()
    {
        return $this->privacy ?
        true :
        false;
    }

    /**
     * Setter for privacy agreement flag
     *
     * @param boolean $privacy
     * @return void
     */
    public function setPrivacy($privacy): void
    {
        $this->privacy = ($privacy ?
            true :
            false);
    }

    /**
     * Setter for byInvitation
     *
     * @param boolean $byInvitation
     * @return void
     */
    public function setByInvitation($byInvitation)
    {
        $this->byInvitation = $byInvitation;
    }

    /**
     * Getter for byInvitation
     *
     * @return boolean
     */
    public function getByInvitation()
    {
        return $this->byInvitation;
    }

    /**
     * Setter for comments
     *
     * @param string $comments
     * @return void
     */
    public function setComments($comments)
    {
        $this->comments = $comments;
    }

    /**
     * Getter for comments
     *
     * @return string
     */
    public function getComments()
    {
        return $this->comments;
    }

    /**
     * Setter language
     *
     * @param string $language
     * @return void
     */
    public function setLanguage($language)
    {
        $this->language = $language;
    }

    /**
     * Getter for language
     *
     * @return string
     */
    public function getLanguage()
    {
        return $this->language;
    }

    /**
     * Setter for moduleSysDmailCategory
     *
     * @param array $moduleSysDmailCategory
     * @return void
     */
    public function setModuleSysDmailCategory($moduleSysDmailCategory)
    {
        $this->moduleSysDmailCategory = $moduleSysDmailCategory;
    }

    /**
     * Getter for moduleSysDmailCategory
     *
     * @return array
     */
    public function getModuleSysDmailCategory()
    {
        return $this->moduleSysDmailCategory;
    }

    /**
     * Set moduleSysDmailNewsletter
     *
     * @param boolean $moduleSysDmailNewsletter
     * @return void
     */
    public function setModuleSysDmailNewsletter($moduleSysDmailNewsletter)
    {
        $this->moduleSysDmailNewsletter = $moduleSysDmailNewsletter;
    }

    /**
     * Get moduleSysDmailNewsletter
     *
     * @return boolean
     */
    public function getModuleSysDmailNewsletter()
    {
        return $this->moduleSysDmailNewsletter;
    }

    /**
     * Setter for moduleSysDmailHtml
     *
     * @param boolean $moduleSysDmailHtml
     * @return void
     */
    public function setModuleSysDmailHtml($moduleSysDmailHtml)
    {
        $this->moduleSysDmailHtml = $moduleSysDmailHtml;
    }

    /**
     * Getter for moduleSysDmailHtml
     *
     * @return boolean
     */
    public function getModuleSysDmailHtml()
    {
        return $this->moduleSysDmailHtml;
    }

    /**
     * Setter for status
     *
     * @param int $status
     * @return void
     */
    public function setStatus($status)
    {
        $this->status = $status;
    }

    /**
     * Getter for status
     *
     * @return int
     */
    public function getStatus()
    {
        return $this->status;
    }

    /**
     * Setter for emailNew
     *
     * @param string $emailNew
     * @return void
     */
    public function setEmailNew($emailNew)
    {
        $this->emailNew = $emailNew;
    }

    /**
     * Getter for emailNew
     *
     * @return string
     */
    public function getEmailNew()
    {
        return $this->emailNew;
    }

    /**
     * Getter for invitationEmail
     *
     * @return string
     */
    public function getInvitationEmail()
    {
        return $this->invitationEmail;
    }

    /**
     * Setter for invitationEmail
     *
     * @param string $invitationEmail
     *
     * @return void
     */
    public function setInvitationEmail($invitationEmail)
    {
        $this->invitationEmail = $invitationEmail;
    }
}
