<?php

use TYPO3\CMS\Core\Information\Typo3Version;
use TYPO3\CMS\Core\Utility\GeneralUtility;

$typo3Version = GeneralUtility::makeInstance(Typo3Version::class)->getMajorVersion();

$sysLanguageFieldConfig = [
    'type' => 'language'
];
if($typo3Version < 13) {
    $sysLanguageFieldConfig = [
        'type' => 'select',
        'renderType' => 'selectSingle',
        'foreign_table' => 'sys_language',
        'foreign_table_where' => 'ORDER BY sys_language.title',
        'items' => [
            [
                'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.allLanguages',
                'value' => -1
            ],
            [
                'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.default_value',
                'value' => 0
            ]
        ],
    ];
}

return [
    'ctrl' => [
        'title' => 'LLL:EXT:ig_simplesubscribe/Resources/Private/Language/locallang_db.xlf:tt_address_changes',
        'label' => 'state',
        'tstamp' => 'tstamp',
        'crdate' => 'crdate',
        'dividers2tabs' => TRUE,
        'versioningWS' => 2,
        'versioning_followPages' => TRUE,

        'languageField' => 'sys_language_uid',
        'transOrigPointerField' => 'l10n_parent',
        'transOrigDiffSourceField' => 'l10n_diffsource',
        'delete' => 'deleted',
        'enablecolumns' => [
            'disabled' => 'hidden',
            'starttime' => 'starttime',
            'endtime' => 'endtime',
        ],
        'searchFields' => 'state, userid, old_data, new_data',
        'iconfile' => 'EX:ig_simplesubscribe/Resources/Public/Icons/tt_address_changes.gif'
    ],
    'types' => [
        '1' => ['showitem' => 'sys_language_uid;;;;1-1-1, l10n_parent, l10n_diffsource, hidden;;1, state, userid, old_data, new_data, --div--;LLL:EXT:core/Resources/Private/Language/Form/locallang_tabs.xlf:access, starttime, endtime'],
    ],
    'palettes' => [
        '1' => ['showitem' => ''],
    ],
    'columns' => [

        'sys_language_uid' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.language',
            'config' => $sysLanguageFieldConfig,
        ],
        'l10n_diffsource' => [
            'config' => [
                'type' => 'passthrough',
            ],
        ],

        't3ver_label' => [
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.versionLabel',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'max' => 255,
            ]
        ],

        'hidden' => [
            'exclude' => 1,
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.hidden',
            'config' => [
                'type' => 'check',
            ],
        ],
        'starttime' => [
            'exclude' => 1,
            'l10n_mode' => 'mergeIfNotBlank',
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.starttime',
            'config' => [
                'type' => 'input',
                'size' => 13,
                'max' => 20,
                'eval' => 'datetime',
                'checkbox' => 0,
                'default' => 0,
                'range' => [
                    'lower' => mktime(0, 0, 0, date('m'), date('d'), date('Y'))
                ],
            ],
        ],
        'endtime' => [
            'exclude' => 1,
            'l10n_mode' => 'mergeIfNotBlank',
            'label' => 'LLL:EXT:core/Resources/Private/Language/locallang_general.xlf:LGL.endtime',
            'config' => [
                'type' => 'input',
                'size' => 13,
                'max' => 20,
                'eval' => 'datetime',
                'checkbox' => 0,
                'default' => 0,
                'range' => [
                    'lower' => mktime(0, 0, 0, date('m'), date('d'), date('Y'))
                ],
            ],
        ],

        'state' => [
            'exclude' => 0,
            'label' => 'LLL:EXT:ig_simplesubscribe/Resources/Private/Language/locallang_db.xlf:tt_address_changes.state',
            'config' => [
                'type' => 'input',
                'size' => 30,
            ],
        ],

        'userid' => [
            'exclude' => 0,
            'label' => 'LLL:EXT:ig_simplesubscribe/Resources/Private/Language/locallang_db.xlf:tt_address_changes.userid',
            'config' => [
                'type' => 'input',
                'size' => 30,
            ],
        ],

        'old_data' => [
            'exclude' => 0,
            'label' => 'LLL:EXT:ig_simplesubscribe/Resources/Private/Language/locallang_db.xlf:tt_address_changes.old_data',
            'config' => [
                'type' => 'input',
                'size' => 30,
                'eval' => 'trim',
                'required' => true,
            ],
        ],

        'new_data' => [
            'exclude' => 0,
            'label' => 'LLL:EXT:ig_simplesubscribe/Resources/Private/Language/locallang_db.xlf:tt_address_changes.new_data',
            'config' => [
                'type' => 'input',
                'size' => 30,
            ],
        ],

        'tstamp' => [
            'exclude' => 1,
            'config' => [
                'type' => 'passthrough',
            ],
        ],

        'crdate' => [
            'exclude' => 1,
            'config' => [
                'type' => 'passthrough',
            ],
        ],

    ],
];
