<?php

namespace Internetgalerie\IgSimplesubscribe\Controller;

use Internetgalerie\IgSimplesubscribe\Domain\Repository\AddressChangesRepository;
use Psr\Http\Message\ResponseInterface;

class ChangeController extends \TYPO3\CMS\Extbase\Mvc\Controller\ActionController
{
    protected ?AddressChangesRepository $addressChangesRepository;
    
    public function __construct(AddressChangesRepository $addressChangesRepository)
    {
        $this->addressChangesRepository = $addressChangesRepository;
    }

    public function listAction(): ResponseInterface
    {
        $allRows = [];
        $addressChanges = $this->addressChangesRepository->findAll();

        foreach ($addressChanges as $addressChange) {
            $newData = unserialize(utf8_decode($addressChange->getNewData()));
            $oldData = unserialize(utf8_decode($addressChange->getOldData()));

            if (!empty($newData) && !empty($oldData)) {
                $addressChange->setUser($newData);
                $addressChange->setOld($oldData);
            } elseif (!empty($newData)) {
                $addressChange->setUser($newData);
            } else {
                $addressChange->setUser($oldData);
            }

            $allRows[] = $addressChange;
        }

        $this->view->assign('rows', $allRows);
        $this->view->assign('settings', $this->settings);

        return $this->htmlResponse();
    }
}
