<?php
namespace Internetgalerie\IgSimplesubscribe\Domain\Repository;

use Internetgalerie\IgFrontendUser\Domain\Repository\FrontendUserRepository as IgFrontendUserRepository;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Database\Query\Restriction\HiddenRestriction;
use TYPO3\CMS\Core\Utility\GeneralUtility;

/***************************************************************
 * Copyright notice
 *
 * (c) 2011-17 Sebastian Fischer <typo3@evoweb.de>
 * All rights reserved
 *
 * This script is part of the TYPO3 project. The TYPO3 project is
 * free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * The GNU General Public License can be found at
 * http://www.gnu.org/copyleft/gpl.html.
 *
 * This script is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * This copyright notice MUST APPEAR in all copies of the script!
 ***************************************************************/

/**
 * A repository for feusers
 */
class FrontendUserRepository extends IgFrontendUserRepository
{
    /**
     * Finds an object matching the given identifier.
     *
     * @param mixed $identifier The identifier of the object to find
     * @param bool $ignoreHidden Whether to ignore hidden state
     *
     * @return NULL|\Evoweb\SfRegister\Interfaces\FrontendUserInterface|object
     */
    public function findByIdentifier($identifier, $ignoreHidden = false)
    {
        if ($ignoreHidden) {
            return parent::findByIdentifier($identifier);
        }

        $query = $this->createQuery();

        $querySettings = $query->getQuerySettings();
        $querySettings->setRespectStoragePage(false);
        $querySettings->setRespectSysLanguage(false);
        $querySettings->setIgnoreEnableFields(true);
        $querySettings->setEnableFieldsToBeIgnored(['disabled']);

        $object = $query->matching($query->equals('uid', $identifier))
            ->execute()
            ->getFirst();

        return $object;
    }

    /**
     * Find user by mailhash
     *
     * @param string $mailhash
     *
     * @return \Evoweb\SfRegister\Domain\Model\FrontendUser|object
     */
    public function findByMailhash($mailhash)
    {
        $query = $this->createQuery();

        $querySettings = $query->getQuerySettings();
        $querySettings->setRespectStoragePage(true);
        $querySettings->setIgnoreEnableFields(true);

        $user = $query->matching($query->equals('mailhash', $mailhash))
            ->execute()
            ->getFirst();

        return $user;
    }

    /**
     * Count users in storagefolder which have a field that contains the value
     *
     * @param string $field
     * @param string $value
     * @param boolean $respectStoragePage
     *
     * @return integer
     */
    public function countByField($field, $value, $respectStoragePage = true)
    {
        $query = $this->createQuery();

        $querySettings = $query->getQuerySettings();
        $querySettings->setRespectStoragePage($respectStoragePage);
        $querySettings->setIgnoreEnableFields(true);

        return $query->matching($query->equals($field, $value))
            ->setLimit(1)
            ->execute()
            ->count();
    }

    /**
     * Count users installationwide which have a field that contains the value
     *
     * @param string $field
     * @param string $value
     *
     * @return integer
     */
    public function countByFieldGlobal($field, $value)
    {
        return $this->countByField($field, $value, false);
    }

    public function findHiddenByUid($uid)
    {
        $query = $this->createQuery();
        $querySettings = $query->getQuerySettings();

        $querySettings->setIgnoreEnableFields(true);
        $querySettings->setEnableFieldsToBeIgnored(['disabled']);
        //$this -> setDefaultQuerySettings(clone $querySettings);
        $query->matching($query->equals('uid', $uid));
        return $query->execute()->getFirst();
    }

    public function countInLastHour()
    {
        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('fe_users');

        $queryBuilder->getRestrictions()->removeByType(HiddenRestriction::class);

        $res = $queryBuilder->selectLiteral('COUNT(*) AS count')
            ->from('fe_users')
            ->where($queryBuilder->expr()->gte('crdate', time() - 3600))
            ->executeQuery()
            ->fetchAssociative();

        return $res['count'];
    }
}
