<?php

namespace Internetgalerie\IgSimplesubscribe\Controller;

use PhpOffice\PhpSpreadsheet\Cell\DataType;
use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Style\Fill;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;
use Psr\Http\Message\ResponseInterface;
use TYPO3\CMS\Core\Database\ConnectionPool;
use TYPO3\CMS\Core\Utility\GeneralUtility;
use TYPO3\CMS\Extbase\Utility\LocalizationUtility;

class ExportController extends \TYPO3\CMS\Extbase\Mvc\Controller\ActionController
{
    public function exportAction(): ResponseInterface
    {
        $this->view->assign('settings', $this->settings);

        return $this->htmlResponse();
    }

    public function xlsExportAction(): ResponseInterface
    {
        $phpExcelService = GeneralUtility::makeInstanceService('phpexcel');

        $queryBuilder = GeneralUtility::makeInstance(ConnectionPool::class)->getQueryBuilderForTable('tt_address_changes');

        $allRows = [];
        $rows = $queryBuilder
            ->select('*')
            ->from('tt_address_changes')
            ->orderBy('tstamp', 'DESC')
            ->executeQuery()
            ->fetchAllAssociative();

        /*$db = new \InternetGalerie\Igsimplesubscribe\Lib\WhDb();
        $db -> setup();
        $rows = $db -> fetchAll("SELECT * FROM tt_address_changes ORDER BY tstamp DESC");*/
        foreach ($rows as $row) {
            $new_data = unserialize(mb_convert_encoding($row['new_data'], 'ISO-8859-1', 'UTF-8'));
            $old_data = unserialize(mb_convert_encoding($row['old_data'], 'ISO-8859-1', 'UTF-8'));
            if (count($new_data) && count($old_data)) {
                $row['user'] = $new_data;
                $row['old'] = [];
                foreach ($new_data as $name => $val) {
                    if ($new_data[$name] != $old_data[$name]) {
                        $row['old'][$name] = $old_data[$name];
                    }
                }
            } elseif (count($new_data)) {
                $row['user'] = unserialize(mb_convert_encoding($row['new_data'], 'ISO-8859-1', 'UTF-8'));
            } else {
                $row['user'] = unserialize(mb_convert_encoding($row['old_data'], 'ISO-8859-1', 'UTF-8'));
            }
            $allRows[] = $row;
        }

        //\TYPO3\CMS\Extbase\Utility\DebuggerUtility::var_dump($allRows);exit;
        $spreadsheet = new Spreadsheet();
        $spreadsheet->setActiveSheetIndex(0);
        $sheet = $spreadsheet->getActiveSheet();

        // First row: Output event title and registration count
        $sheet->SetCellValue('A1', 'CI Tech Update Changes');

        // Output registration count
        //$phpExcel -> getActiveSheet() -> SetCellValue('B1', 'Anzahl Anmeldungen:');
        //$phpExcel -> getActiveSheet() -> SetCellValue('C1', $event -> getRegistrations() -> count());

        // Set first row bold
        //$phpExcel -> getActiveSheet() -> getStyle('A1:C1') -> getFont() -> setBold(true);

        // Second row: Output attribute titles

        $sheet->SetCellValue('A3', 'Date');
        $sheet->SetCellValue('B3', 'State');
        $sheet->SetCellValue('C3', 'Title');
        $sheet->SetCellValue('D3', 'Firstname');
        $sheet->SetCellValue('E3', 'Lastname');
        $sheet->SetCellValue('F3', 'Company');
        $sheet->SetCellValue('G3', 'Position');
        $sheet->SetCellValue('H3', 'E-Mail');

        $endColumn = 'H';
        if ($this->settings['needToAccept']) {
            $endColumn = 'I';
            $sheet->SetCellValue($endColumn . '3', 'Accepted');
        }
        if ($this->settings['logIpAddress']) {
            $endColumn = 'J';
            $sheet->SetCellValue($endColumn . '3', 'IP Address');
        }
        if ($this->settings['logBrowser']) {
            $endColumn = 'K';
            $sheet->SetCellValue($endColumn . '3', 'Browser');
        }
        // Set second row bold
        $sheet->getStyle('A3:' . $endColumn . '3')->getFont()->setBold(true);
        $sheet->getStyle('A3:' . $endColumn . '3')->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('d3d3d3');

        // For each registration of the event set the values of the attributes to the according column
        $i = 4;
        //var_dump($allRows);
        // We are beginning at the 3rd row (Excel rows count from 1)
        foreach ($allRows as $row) {
            $state = ($row['state'] != 'subscribed') ? $row['state'] . 'd' : $row['state'];
            $sheet->SetCellValue('A' . $i, date("d.m.Y - H:i:s", $row['tstamp']));
            $sheet->SetCellValue('B' . $i, $state);
            $sheet->SetCellValue('C' . $i, $row['user']['gender'] == 'm' ? 'Mr' : 'Mrs');
            $sheet->SetCellValue('D' . $i, $row['user']['first_name']);
            $sheet->SetCellValue('E' . $i, $row['user']['last_name']);
            $sheet->SetCellValue('F' . $i, $row['user']['company']);
            $sheet->SetCellValue('G' . $i, $row['user']['position']);
            $sheet->SetCellValue('H' . $i, $row['user']['email']);

            if ($this->settings['needToAccept']) {
                $sheet->SetCellValue('I' . $i, $row['user']['accepted'] ? LocalizationUtility::translate('LLL:' . $this->settings['langFile'] . ':change.accepted.yes') : LocalizationUtility::translate('LLL:' . $this->settings['langFile'] . ':change.accepted.no'));
            }
            if ($this->settings['logIpAddress'] && $row['user']['ip_address']) {
                $sheet->SetCellValueExplicit('J' . $i, $row['user']['ip_address'], DataType::TYPE_STRING);
            }
            if ($this->settings['logBrowser'] && $row['user']['browser']) {
                $sheet->SetCellValue('K' . $i, $row['user']['browser']);
            }
            if ($row['state'] == 'subscribed') {
                $sheet->getStyle('A' . $i . ':' . $endColumn . $i)->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('deffe5');
            } elseif ($row['state'] == 'delete') {
                $sheet->getStyle('A' . $i . ':' . $endColumn . $i)->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('ffdede');
            } elseif ($row['state'] == 'change') {
                $sheet->getStyle('A' . $i . ':' . $endColumn . $i)->getFill()->setFillType(Fill::FILL_SOLID)->getStartColor()->setRGB('fff4de');
            }
            $i++;
        }

        // Set column width automatically according to their content
        foreach (range('A', $endColumn) as $column) {
            $sheet->getColumnDimension($column)->setAutoSize(true);
        }
        // Temporary filename
        $fileName = 'typo3temp/tech_update_changes-' . date("d_m_Y-H_i", time()) . '.xlsx';

        // Save to temporary file
        $excelWriter = GeneralUtility::makeInstance(Xlsx::class);
        // Create an Excel Writer
        $excelWriter->save($fileName);

        // Set headers
        header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
        header('Content-Disposition: attachment;filename="' . str_replace('typo3temp/', '', $fileName) . '"');
        header('Cache-Control: max-age=0');
        // If you're serving to IE 9, then the following may be needed
        header('Cache-Control: max-age=1');
        // If you're serving to IE over SSL, then the following may be needed
        header('Expires: Mon, 26 Jul 1997 05:00:00 GMT');
        // Date in the past
        header('Last-Modified: ' . gmdate('D, d M Y H:i:s') . ' GMT');
        // always modified
        header('Cache-Control: cache, must-revalidate');
        // HTTP/1.1
        header('Pragma: public');
        // HTTP/1.0
        header('Content-Length: ' . filesize($fileName));
        //header('Pragma: no-cache');
        echo file_get_contents($fileName);
        // Output file
        unlink($fileName);
        // Delete temporary file
        exit();

        return $this->htmlResponse();
    }
}
