<?php
namespace Internetgalerie\IgSimplesubscribe\Domain\Model;

use FriendsOfTYPO3\TtAddress\Domain\Model\Address as FriendsOfTYPO3Address;


/**
 * Address
 */
class Address extends FriendsOfTYPO3Address
{

    /**
     * localgender
     *
     * @var string
     */
    protected $localgender = ''; // FIXME: Not used?

    /**
     * password
     *
     * @var string
     */
    protected $password = '';

    /**
     * linkHash
     *
     * @var string
     */
    protected $linkHash = '';

    /**
     * accepted
     *
     * @var boolean
     */
    protected $accepted = false;

    /**
     * ipAddress
     *
     * @var string
     */
    protected $ipAddress = '';

    /**
     * browser
     *
     * @var string
     */
    protected $browser = '';

    /**
     * @var boolean
     */
    protected $sendHtmlMail = true;

    /**
     * tstamp
     * @var int
     */
    protected $crdate = 0;

    /**
     * tstamp
     * @var int
     */
    protected $tstmp = 0;

    /**
     * speciality
     *
     * @var string
     */
    protected $speciality = '';

    /**
     * language
     *
     * @var string
     */
    protected $language = '';

    /**
     * language
     *
     * @var \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Internetgalerie\IgSimplesubscribe\Domain\Model\Category>
     */
    protected $sysDmailCategories = null;

    /**
     * __construct
     */
    public function __construct()
    {
        $this->image = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\\CMS\\Extbase\\Persistence\\ObjectStorage');
        $this->categories = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\\CMS\\Extbase\\Persistence\\ObjectStorage');
        $this->sysDmailCategories = \TYPO3\CMS\Core\Utility\GeneralUtility::makeInstance('TYPO3\\CMS\\Extbase\\Persistence\\ObjectStorage');
    }

    /**
     * Returns the localgender
     *
     * @return string $localgender
     */
    public function getLocalgender()
    {
        return $this->localgender;
    }

    /**
     * Sets the localgender
     *
     * @param string $localgender
     * @return void
     */
    public function setLocalgender($localgender)
    {
        $this->localgender = $localgender;
    }

    /**
     * Returns the password
     *
     * @return string $password
     */
    public function getPassword()
    {
        return $this->password;
    }

    /**
     * Sets the password
     *
     * @param string $password
     * @return void
     */
    public function setPassword($password)
    {
        $this->password = $password;
    }

    /**
     * Returns the linkHash
     *
     * @return string $linkHash
     */
    public function getLinkHash()
    {
        return $this->linkHash;
    }

    /**
     * Sets the linkHash
     *
     * @param string $linkHash
     * @return void
     */
    public function setLinkHash($linkHash)
    {
        $this->linkHash = $linkHash;
    }

    /**
     * Returns the accepted
     *
     * @return string $accepted
     */
    public function getAccepted()
    {
        return $this->accepted;
    }

    /**
     * Sets the accepted
     *
     * @param string $accepted
     * @return void
     */
    public function setAccepted($accepted)
    {
        $this->accepted = $accepted;
    }

    /**
     * Returns the ipAddress
     *
     * @return string $ipAddress
     */
    public function getIpAddress()
    {
        return $this->ipAddress;
    }

    /**
     * Sets the ipAddress
     *
     * @param string $ipAddress
     * @return void
     */
    public function setIpAddress($ipAddress)
    {
        $this->ipAddress = $ipAddress;
    }

    /**
     * Returns the browser
     *
     * @return string $browser
     */
    public function getBrowser()
    {
        return $this->browser;
    }

    /**
     * Sets the browser
     *
     * @param string $browser
     * @return void
     */
    public function setBrowser($browser)
    {
        $this->browser = $browser;
    }

    /**
     * Returns the boolean state of hidden
     *
     * @return boolean
     */
    public function isHidden()
    {
        return $this->getHidden();
    }


    /**
     * Add a category
     *
     * @param \Internetgalerie\IgSimplesubscribe\Domain\Model\Category $category
     *
     * @return void
     */
    public function addCategory($category)
    {
        $this->categories->attach($category);
    }

    /**
     * Removes a category
     *
     * @param \Internetgalerie\IgSimplesubscribe\Domain\Model\Category $category
     *
     * @return void
     */
    public function deleteCategory($category)
    {
        $this->categories->detach($category);
    }

    /**
     * Has a category
     *
     * @param \Internetgalerie\IgSimplesubscribe\Domain\Model\Category $category
     *
     * @return bool
     */
    public function hasCategory($category)
    {
        return $this->categories->contains($category);
    }

    /**
     * Has a category
     *
     * @param \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Internetgalerie\IgSimplesubscribe\Domain\Model\Category> $sysDmailCategories
     *
     * @return void
     */
    public function setSysDmailCategories($sysDmailCategories)
    {
        $this->sysDmailCategories = $sysDmailCategories;
    }


    /**
     * @return \TYPO3\CMS\Extbase\Persistence\ObjectStorage<\Internetgalerie\IgSimplesubscribe\Domain\Model\Category>
     */
    public function getSysDmailCategories()
    {
        return $this->sysDmailCategories;
    }


    /**
     * Add a sysDmailCategory
     *
     * @param \Internetgalerie\IgSimplesubscribe\Domain\Model\SysDmailCategory $sysDmailCategory
     *
     * @return void
     */
    public function addSysDmailCategory($sysDmailCategory)
    {
        $this->sysDmailCategories->attach($sysDmailCategory);
    }

    /**
     * Removes a sysDmailCategory
     *
     * @param \Internetgalerie\IgSimplesubscribe\Domain\Model\SysDmailCategory $sysDmailCategory
     *
     * @return void
     */
    public function deleteSysDmailCategory($sysDmailCategory)
    {
        $this->sysDmailCategories->detach($sysDmailCategory);
    }

    /**
     * Has a sysDmailCategory
     *
     * @param \Internetgalerie\IgSimplesubscribe\Domain\Model\SysDmailCategory $sysDmailCategory
     *
     * @return bool
     */
    public function hasSysDmailCategory($sysDmailCategory)
    {
        return $this->sysDmailCategories->contains($sysDmailCategory);
    }

    /**
     * Returns the send html mail
     *
     * @return boolean $sendHtmlMail
     */
    public function getSendHtmlMail()
    {
        return $this->sendHtmlMail;
    }

    /**
     * Sets the send html mail
     *
     * @param boolean $sendHtmlMail
     * @return void
     */
    public function setSendHtmlMail($sendHtmlMail)
    {
        $this->sendHtmlMail = $sendHtmlMail;
    }

    /**
     * Get the value of tstamp
     *
     * @return int
     */
    public function getCrdate()
    {
        return $this->crdate;
    }

    /**
     * Set the value of tstamp
     *
     * @param int $crdate
     *
     * @return self
     */
    public function setCrdate($crdate)
    {
        $this->crdate = $crdate;

        return $this;
    }

    /**
     * Get the value of tstamp
     *
     * @return int
     */
    public function getTstmp()
    {
        return $this->tstmp;
    }

    /**
     * Set the value of tstamp
     *
     * @param int $tstmp
     *
     * @return self
     */
    public function setTstmp($tstmp)
    {
        $this->tstmp = $tstmp;

        return $this;
    }


    /**
     * Get the value of speciality
     *
     * @return string
     */
    public function getSpeciality()
    {
        return $this->speciality;
    }

    /**
     * Set the value of speciality
     *
     * @param string $speciality
     *
     * @return self
     */
    public function setSpeciality($speciality)
    {
        $this->speciality = $speciality;

        return $this;
    }

    /**
     * Get the value of language
     *
     * @return string
     */
    public function getLanguage()
    {
        return $this->language;
    }

    /**
     * Set the value of language
     *
     * @param string $language
     *
     * @return self
     */
    public function setLanguage($language)
    {
        $this->language = $language;

        return $this;
    }

}
